#ifndef CUFFTDX_FFT_216_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_216_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<388, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<333>;
.reg .b32 r<17>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %12;
mad.lo.s32 r3, r1, 1728, r2;
mov.u32 r4, %tid.x;
add.f32 f25, %20, %25;
add.f32 f26, %15, f25;
add.f32 f27, %22, %27;
add.f32 f28, %16, f27;
mul.f32 f29, f25, 0f3F000000;
sub.f32 f30, %15, f29;
sub.f32 f31, %22, %27;
mul.f32 f32, f31, 0fBF5DB3D7;
add.f32 f33, f32, f30;
sub.f32 f34, f30, f32;
mul.f32 f35, f27, 0f3F000000;
sub.f32 f36, %16, f35;
sub.f32 f37, %20, %25;
mul.f32 f38, f37, 0fBF5DB3D7;
sub.f32 f39, f36, f38;
add.f32 f40, f38, f36;
add.f32 f41, %23, %28;
add.f32 f42, %17, f41;
add.f32 f43, %24, %29;
add.f32 f44, %19, f43;
mul.f32 f45, f41, 0f3F000000;
sub.f32 f46, %17, f45;
sub.f32 f47, %24, %29;
mul.f32 f48, f47, 0fBF5DB3D7;
add.f32 f49, f48, f46;
sub.f32 f50, f46, f48;
mul.f32 f51, f43, 0f3F000000;
sub.f32 f52, %19, f51;
sub.f32 f53, %23, %28;
mul.f32 f54, f53, 0fBF5DB3D7;
sub.f32 f55, f52, f54;
add.f32 f56, f54, f52;
mul.f32 f57, f49, 0f3F000000;
mul.f32 f58, f55, 0f3F5DB3D7;
sub.f32 f59, f57, f58;
mul.f32 f60, f55, 0f3F000000;
fma.rn.f32 f61, f49, 0f3F5DB3D7, f60;
mul.f32 f62, f50, 0fBF000000;
mul.f32 f63, f56, 0f3F5DB3D7;
sub.f32 f64, f62, f63;
mul.f32 f65, f56, 0fBF000000;
fma.rn.f32 f66, f50, 0f3F5DB3D7, f65;
sub.f32 f67, f26, f42;
sub.f32 f68, f28, f44;
add.f32 f69, f33, f59;
add.f32 f70, f39, f61;
sub.f32 f71, f33, f59;
sub.f32 f72, f39, f61;
add.f32 f73, f34, f64;
add.f32 f74, f40, f66;
sub.f32 f75, f34, f64;
sub.f32 f76, f40, f66;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 36;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 1728, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %13;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f77, f78}, [rd6];
mul.f32 f81, f70, f78;
mul.f32 f82, f69, f78;
mul.f32 f83, f77, f70;
mul.f32 f84, f77, f77;
mul.f32 f85, f78, f78;
sub.f32 f86, f84, f85;
mul.f32 f87, f78, f77;
fma.rn.f32 f88, f78, f77, f87;
mul.f32 f89, f74, f88;
mul.f32 f90, f73, f88;
mul.f32 f91, f86, f74;
mul.f32 f92, f77, f86;
mul.f32 f93, f78, f88;
sub.f32 f94, f92, f93;
mul.f32 f95, f77, f88;
fma.rn.f32 f96, f78, f86, f95;
mul.f32 f97, f68, f96;
mul.f32 f98, f67, f96;
mul.f32 f99, f94, f68;
mul.f32 f100, f77, f94;
mul.f32 f101, f78, f96;
sub.f32 f102, f100, f101;
mul.f32 f103, f77, f96;
fma.rn.f32 f104, f78, f94, f103;
mul.f32 f105, f72, f104;
mul.f32 f106, f71, f104;
mul.f32 f107, f102, f72;
mul.f32 f108, f77, f102;
mul.f32 f109, f78, f104;
sub.f32 f110, f108, f109;
mul.f32 f111, f77, f104;
fma.rn.f32 f112, f78, f102, f111;
mul.f32 f113, f76, f112;
mul.f32 f114, f75, f112;
mul.f32 f115, f110, f76;
barrier.sync 0;
mad.lo.s32 r9, r7, 48, r8;
add.f32 f116, f28, f44;
add.f32 f117, f26, f42;
st.shared.v2.f32 [r9], {f117, f116};
fma.rn.f32 f118, f77, f69, f81;
sub.f32 f119, f83, f82;
st.shared.v2.f32 [r9+8], {f118, f119};
fma.rn.f32 f120, f86, f73, f89;
sub.f32 f121, f91, f90;
st.shared.v2.f32 [r9+16], {f120, f121};
fma.rn.f32 f122, f94, f67, f97;
sub.f32 f123, f99, f98;
st.shared.v2.f32 [r9+24], {f122, f123};
fma.rn.f32 f124, f102, f71, f105;
sub.f32 f125, f107, f106;
st.shared.v2.f32 [r9+32], {f124, f125};
fma.rn.f32 f126, f110, f75, f113;
sub.f32 f127, f115, f114;
st.shared.v2.f32 [r9+40], {f126, f127};
barrier.sync 0;
mad.lo.s32 r10, r7, -40, r9;
ld.shared.v2.f32 {f128, f129}, [r10];
ld.shared.v2.f32 {f132, f133}, [r10+288];
ld.shared.v2.f32 {f136, f137}, [r10+576];
ld.shared.v2.f32 {f140, f141}, [r10+864];
ld.shared.v2.f32 {f144, f145}, [r10+1152];
ld.shared.v2.f32 {f148, f149}, [r10+1440];
add.f32 f152, f136, f144;
add.f32 f153, f128, f152;
add.f32 f154, f137, f145;
add.f32 f155, f129, f154;
mul.f32 f156, f152, 0f3F000000;
sub.f32 f157, f128, f156;
sub.f32 f158, f137, f145;
mul.f32 f159, f158, 0fBF5DB3D7;
add.f32 f160, f159, f157;
sub.f32 f161, f157, f159;
mul.f32 f162, f154, 0f3F000000;
sub.f32 f163, f129, f162;
sub.f32 f164, f136, f144;
mul.f32 f165, f164, 0fBF5DB3D7;
sub.f32 f166, f163, f165;
add.f32 f167, f165, f163;
add.f32 f168, f140, f148;
add.f32 f169, f132, f168;
add.f32 f170, f141, f149;
add.f32 f171, f133, f170;
mul.f32 f172, f168, 0f3F000000;
sub.f32 f173, f132, f172;
sub.f32 f174, f141, f149;
mul.f32 f175, f174, 0fBF5DB3D7;
add.f32 f176, f175, f173;
sub.f32 f177, f173, f175;
mul.f32 f178, f170, 0f3F000000;
sub.f32 f179, f133, f178;
sub.f32 f180, f140, f148;
mul.f32 f181, f180, 0fBF5DB3D7;
sub.f32 f182, f179, f181;
add.f32 f183, f181, f179;
mul.f32 f184, f176, 0f3F000000;
mul.f32 f185, f182, 0f3F5DB3D7;
sub.f32 f186, f184, f185;
mul.f32 f187, f182, 0f3F000000;
fma.rn.f32 f188, f176, 0f3F5DB3D7, f187;
mul.f32 f189, f177, 0fBF000000;
mul.f32 f190, f183, 0f3F5DB3D7;
sub.f32 f191, f189, f190;
mul.f32 f192, f183, 0fBF000000;
fma.rn.f32 f193, f177, 0f3F5DB3D7, f192;
sub.f32 f194, f153, f169;
sub.f32 f195, f155, f171;
add.f32 f196, f160, f186;
add.f32 f197, f166, f188;
sub.f32 f198, f160, f186;
sub.f32 f199, f166, f188;
add.f32 f200, f161, f191;
add.f32 f201, f167, f193;
sub.f32 f202, f161, f191;
sub.f32 f203, f167, f193;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 6;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 8;
mov.u64 rd10, %14;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f204, f205}, [rd11];
mul.f32 f208, f197, f205;
mul.f32 f209, f196, f205;
mul.f32 f210, f204, f197;
mul.f32 f211, f204, f204;
mul.f32 f212, f205, f205;
sub.f32 f213, f211, f212;
mul.f32 f214, f205, f204;
fma.rn.f32 f215, f205, f204, f214;
mul.f32 f216, f201, f215;
mul.f32 f217, f200, f215;
mul.f32 f218, f213, f201;
mul.f32 f219, f204, f213;
mul.f32 f220, f205, f215;
sub.f32 f221, f219, f220;
mul.f32 f222, f204, f215;
fma.rn.f32 f223, f205, f213, f222;
mul.f32 f224, f195, f223;
mul.f32 f225, f194, f223;
mul.f32 f226, f221, f195;
mul.f32 f227, f204, f221;
mul.f32 f228, f205, f223;
sub.f32 f229, f227, f228;
mul.f32 f230, f204, f223;
fma.rn.f32 f231, f205, f221, f230;
mul.f32 f232, f199, f231;
mul.f32 f233, f198, f231;
mul.f32 f234, f229, f199;
mul.f32 f235, f204, f229;
mul.f32 f236, f205, f231;
sub.f32 f237, f235, f236;
mul.f32 f238, f204, f231;
fma.rn.f32 f239, f205, f229, f238;
mul.f32 f240, f203, f239;
mul.f32 f241, f202, f239;
mul.f32 f242, f237, f203;
shl.b32 r14, r13, 3;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 288, r15;
add.f32 f243, f155, f171;
add.f32 f244, f153, f169;
st.shared.v2.f32 [r16], {f244, f243};
fma.rn.f32 f245, f204, f196, f208;
sub.f32 f246, f210, f209;
st.shared.v2.f32 [r16+48], {f245, f246};
fma.rn.f32 f247, f213, f200, f216;
sub.f32 f248, f218, f217;
st.shared.v2.f32 [r16+96], {f247, f248};
fma.rn.f32 f249, f221, f194, f224;
sub.f32 f250, f226, f225;
st.shared.v2.f32 [r16+144], {f249, f250};
fma.rn.f32 f251, f229, f198, f232;
sub.f32 f252, f234, f233;
st.shared.v2.f32 [r16+192], {f251, f252};
sub.f32 f253, f242, f241;
fma.rn.f32 f254, f237, f202, f240;
st.shared.v2.f32 [r16+240], {f254, f253};
barrier.sync 0;
ld.shared.v2.f32 {f255, f256}, [r10];
ld.shared.v2.f32 {f259, f260}, [r10+288];
ld.shared.v2.f32 {f263, f264}, [r10+576];
ld.shared.v2.f32 {f267, f268}, [r10+864];
ld.shared.v2.f32 {f271, f272}, [r10+1152];
ld.shared.v2.f32 {f275, f276}, [r10+1440];
add.f32 f279, f263, f271;
add.f32 f280, f255, f279;
add.f32 f281, f264, f272;
add.f32 f282, f256, f281;
mul.f32 f283, f279, 0f3F000000;
sub.f32 f284, f255, f283;
sub.f32 f285, f264, f272;
mul.f32 f286, f285, 0fBF5DB3D7;
add.f32 f287, f286, f284;
sub.f32 f288, f284, f286;
mul.f32 f289, f281, 0f3F000000;
sub.f32 f290, f256, f289;
sub.f32 f291, f263, f271;
mul.f32 f292, f291, 0fBF5DB3D7;
sub.f32 f293, f290, f292;
add.f32 f294, f292, f290;
add.f32 f295, f267, f275;
add.f32 f296, f259, f295;
add.f32 f297, f268, f276;
add.f32 f298, f260, f297;
mul.f32 f299, f295, 0f3F000000;
sub.f32 f300, f259, f299;
sub.f32 f301, f268, f276;
mul.f32 f302, f301, 0fBF5DB3D7;
add.f32 f303, f302, f300;
sub.f32 f304, f300, f302;
mul.f32 f305, f297, 0f3F000000;
sub.f32 f306, f260, f305;
sub.f32 f307, f267, f275;
mul.f32 f308, f307, 0fBF5DB3D7;
sub.f32 f309, f306, f308;
add.f32 f310, f308, f306;
mul.f32 f311, f303, 0f3F000000;
mul.f32 f312, f309, 0f3F5DB3D7;
sub.f32 f313, f311, f312;
mul.f32 f314, f309, 0f3F000000;
fma.rn.f32 f315, f303, 0f3F5DB3D7, f314;
mul.f32 f316, f304, 0fBF000000;
mul.f32 f317, f310, 0f3F5DB3D7;
sub.f32 f318, f316, f317;
mul.f32 f319, f310, 0fBF000000;
fma.rn.f32 f320, f304, 0f3F5DB3D7, f319;
add.f32 %1, f282, f298;
add.f32 %0, f280, f296;
add.f32 %3, f293, f315;
add.f32 %2, f287, f313;
add.f32 %5, f294, f320;
add.f32 %4, f288, f318;
sub.f32 %7, f282, f298;
sub.f32 %6, f280, f296;
sub.f32 %9, f293, f315;
sub.f32 %8, f287, f313;
sub.f32 %11, f294, f320;
sub.f32 %10, f288, f318;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y): "r"(smem), "l"(lut_sp_6_216), "l"(lut_sp_6_36), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<389, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<309>;
.reg .b32 r<17>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %12;
mad.lo.s32 r3, r1, 864, r2;
mov.u32 r4, %tid.x;
add.f32 f25, %20, %25;
add.f32 f26, %15, f25;
add.f32 f27, %22, %27;
add.f32 f28, %16, f27;
mul.f32 f29, f25, 0f3F000000;
sub.f32 f30, %15, f29;
sub.f32 f31, %22, %27;
mul.f32 f32, f31, 0fBF5DB3D7;
add.f32 f33, f32, f30;
sub.f32 f34, f30, f32;
mul.f32 f35, f27, 0f3F000000;
sub.f32 f36, %16, f35;
sub.f32 f37, %20, %25;
mul.f32 f38, f37, 0fBF5DB3D7;
sub.f32 f39, f36, f38;
add.f32 f40, f38, f36;
add.f32 f41, %23, %28;
add.f32 f42, %17, f41;
add.f32 f43, %24, %29;
add.f32 f44, %19, f43;
mul.f32 f45, f41, 0f3F000000;
sub.f32 f46, %17, f45;
sub.f32 f47, %24, %29;
mul.f32 f48, f47, 0fBF5DB3D7;
add.f32 f49, f48, f46;
sub.f32 f50, f46, f48;
mul.f32 f51, f43, 0f3F000000;
sub.f32 f52, %19, f51;
sub.f32 f53, %23, %28;
mul.f32 f54, f53, 0fBF5DB3D7;
sub.f32 f55, f52, f54;
add.f32 f56, f54, f52;
mul.f32 f57, f49, 0f3F000000;
mul.f32 f58, f55, 0f3F5DB3D7;
sub.f32 f59, f57, f58;
mul.f32 f60, f55, 0f3F000000;
fma.rn.f32 f61, f49, 0f3F5DB3D7, f60;
mul.f32 f62, f50, 0fBF000000;
mul.f32 f63, f56, 0f3F5DB3D7;
sub.f32 f64, f62, f63;
mul.f32 f65, f56, 0fBF000000;
fma.rn.f32 f66, f50, 0f3F5DB3D7, f65;
add.f32 f67, f26, f42;
add.f32 f68, f28, f44;
sub.f32 f69, f26, f42;
sub.f32 f70, f28, f44;
add.f32 f71, f33, f59;
add.f32 f72, f39, f61;
sub.f32 f73, f33, f59;
sub.f32 f74, f39, f61;
add.f32 f75, f34, f64;
add.f32 f76, f40, f66;
sub.f32 f77, f34, f64;
sub.f32 f78, f40, f66;
mul.wide.u32 rd2, r4, 954437177;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 36;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %13;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f79, f80}, [rd6];
mul.f32 f83, f72, f80;
fma.rn.f32 f84, f79, f71, f83;
mul.f32 f85, f71, f80;
mul.f32 f86, f79, f72;
sub.f32 f87, f86, f85;
mul.f32 f88, f79, f79;
mul.f32 f89, f80, f80;
sub.f32 f90, f88, f89;
mul.f32 f91, f80, f79;
fma.rn.f32 f92, f80, f79, f91;
mul.f32 f93, f76, f92;
fma.rn.f32 f94, f90, f75, f93;
mul.f32 f95, f75, f92;
mul.f32 f96, f90, f76;
sub.f32 f97, f96, f95;
mul.f32 f98, f79, f90;
mul.f32 f99, f80, f92;
sub.f32 f100, f98, f99;
mul.f32 f101, f79, f92;
fma.rn.f32 f102, f80, f90, f101;
mul.f32 f103, f70, f102;
fma.rn.f32 f104, f100, f69, f103;
mul.f32 f105, f69, f102;
mul.f32 f106, f100, f70;
sub.f32 f107, f106, f105;
mul.f32 f108, f79, f100;
mul.f32 f109, f80, f102;
sub.f32 f110, f108, f109;
mul.f32 f111, f79, f102;
fma.rn.f32 f112, f80, f100, f111;
mul.f32 f113, f74, f112;
fma.rn.f32 f114, f110, f73, f113;
mul.f32 f115, f73, f112;
mul.f32 f116, f110, f74;
sub.f32 f117, f116, f115;
mul.f32 f118, f79, f110;
mul.f32 f119, f80, f112;
sub.f32 f120, f118, f119;
mul.f32 f121, f79, f112;
fma.rn.f32 f122, f80, f110, f121;
mul.f32 f123, f78, f122;
fma.rn.f32 f124, f120, f77, f123;
mul.f32 f125, f77, f122;
mul.f32 f126, f120, f78;
sub.f32 f127, f126, f125;
mad.lo.s32 r8, r5, 864, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 24, r8;
st.shared.v2.f32 [r9], {f67, f84};
st.shared.v2.f32 [r9+8], {f94, f104};
st.shared.v2.f32 [r9+16], {f114, f124};
barrier.sync 0;
mad.lo.s32 r10, r7, -20, r9;
ld.shared.f32 f128, [r10];
ld.shared.f32 f129, [r10+144];
ld.shared.f32 f130, [r10+288];
ld.shared.f32 f131, [r10+432];
ld.shared.f32 f132, [r10+576];
ld.shared.f32 f133, [r10+720];
barrier.sync 0;
st.shared.v2.f32 [r9], {f68, f87};
st.shared.v2.f32 [r9+8], {f97, f107};
st.shared.v2.f32 [r9+16], {f117, f127};
barrier.sync 0;
ld.shared.f32 f134, [r10];
ld.shared.f32 f135, [r10+144];
ld.shared.f32 f136, [r10+288];
ld.shared.f32 f137, [r10+432];
ld.shared.f32 f138, [r10+576];
ld.shared.f32 f139, [r10+720];
add.f32 f140, f130, f132;
add.f32 f141, f128, f140;
add.f32 f142, f136, f138;
add.f32 f143, f134, f142;
mul.f32 f144, f140, 0f3F000000;
sub.f32 f145, f128, f144;
sub.f32 f146, f136, f138;
mul.f32 f147, f146, 0fBF5DB3D7;
add.f32 f148, f147, f145;
sub.f32 f149, f145, f147;
mul.f32 f150, f142, 0f3F000000;
sub.f32 f151, f134, f150;
sub.f32 f152, f130, f132;
mul.f32 f153, f152, 0fBF5DB3D7;
sub.f32 f154, f151, f153;
add.f32 f155, f153, f151;
add.f32 f156, f131, f133;
add.f32 f157, f129, f156;
add.f32 f158, f137, f139;
add.f32 f159, f135, f158;
mul.f32 f160, f156, 0f3F000000;
sub.f32 f161, f129, f160;
sub.f32 f162, f137, f139;
mul.f32 f163, f162, 0fBF5DB3D7;
add.f32 f164, f163, f161;
sub.f32 f165, f161, f163;
mul.f32 f166, f158, 0f3F000000;
sub.f32 f167, f135, f166;
sub.f32 f168, f131, f133;
mul.f32 f169, f168, 0fBF5DB3D7;
sub.f32 f170, f167, f169;
add.f32 f171, f169, f167;
mul.f32 f172, f164, 0f3F000000;
mul.f32 f173, f170, 0f3F5DB3D7;
sub.f32 f174, f172, f173;
mul.f32 f175, f170, 0f3F000000;
fma.rn.f32 f176, f164, 0f3F5DB3D7, f175;
mul.f32 f177, f165, 0fBF000000;
mul.f32 f178, f171, 0f3F5DB3D7;
sub.f32 f179, f177, f178;
mul.f32 f180, f171, 0fBF000000;
fma.rn.f32 f181, f165, 0f3F5DB3D7, f180;
add.f32 f182, f141, f157;
add.f32 f183, f143, f159;
sub.f32 f184, f141, f157;
sub.f32 f185, f143, f159;
add.f32 f186, f148, f174;
add.f32 f187, f154, f176;
sub.f32 f188, f148, f174;
sub.f32 f189, f154, f176;
add.f32 f190, f149, f179;
add.f32 f191, f155, f181;
sub.f32 f192, f149, f179;
sub.f32 f193, f155, f181;
mul.wide.u32 rd7, r7, -1431655765;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r11, rd8;
mul.lo.s32 r12, r11, 6;
sub.s32 r13, r7, r12;
mul.wide.u32 rd9, r11, 8;
mov.u64 rd10, %14;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f194, f195}, [rd11];
mul.f32 f198, f187, f195;
fma.rn.f32 f199, f194, f186, f198;
mul.f32 f200, f186, f195;
mul.f32 f201, f194, f187;
sub.f32 f202, f201, f200;
mul.f32 f203, f194, f194;
mul.f32 f204, f195, f195;
sub.f32 f205, f203, f204;
mul.f32 f206, f195, f194;
fma.rn.f32 f207, f195, f194, f206;
mul.f32 f208, f191, f207;
fma.rn.f32 f209, f205, f190, f208;
mul.f32 f210, f190, f207;
mul.f32 f211, f205, f191;
sub.f32 f212, f211, f210;
mul.f32 f213, f194, f205;
mul.f32 f214, f195, f207;
sub.f32 f215, f213, f214;
mul.f32 f216, f194, f207;
fma.rn.f32 f217, f195, f205, f216;
mul.f32 f218, f185, f217;
fma.rn.f32 f219, f215, f184, f218;
mul.f32 f220, f184, f217;
mul.f32 f221, f215, f185;
sub.f32 f222, f221, f220;
mul.f32 f223, f194, f215;
mul.f32 f224, f195, f217;
sub.f32 f225, f223, f224;
mul.f32 f226, f194, f217;
fma.rn.f32 f227, f195, f215, f226;
mul.f32 f228, f189, f227;
fma.rn.f32 f229, f225, f188, f228;
mul.f32 f230, f188, f227;
mul.f32 f231, f225, f189;
sub.f32 f232, f231, f230;
mul.f32 f233, f194, f225;
mul.f32 f234, f195, f227;
sub.f32 f235, f233, f234;
mul.f32 f236, f194, f227;
fma.rn.f32 f237, f195, f225, f236;
mul.f32 f238, f193, f237;
fma.rn.f32 f239, f235, f192, f238;
mul.f32 f240, f192, f237;
mul.f32 f241, f235, f193;
sub.f32 f242, f241, f240;
shl.b32 r14, r13, 2;
add.s32 r15, r8, r14;
barrier.sync 0;
mad.lo.s32 r16, r11, 144, r15;
st.shared.f32 [r16], f182;
st.shared.f32 [r16+24], f199;
st.shared.f32 [r16+48], f209;
st.shared.f32 [r16+72], f219;
st.shared.f32 [r16+96], f229;
st.shared.f32 [r16+120], f239;
barrier.sync 0;
ld.shared.f32 f243, [r10];
ld.shared.f32 f244, [r10+144];
ld.shared.f32 f245, [r10+288];
ld.shared.f32 f246, [r10+432];
ld.shared.f32 f247, [r10+576];
ld.shared.f32 f248, [r10+720];
barrier.sync 0;
st.shared.f32 [r16], f183;
st.shared.f32 [r16+24], f202;
st.shared.f32 [r16+48], f212;
st.shared.f32 [r16+72], f222;
st.shared.f32 [r16+96], f232;
st.shared.f32 [r16+120], f242;
barrier.sync 0;
ld.shared.f32 f249, [r10];
ld.shared.f32 f250, [r10+144];
ld.shared.f32 f251, [r10+288];
ld.shared.f32 f252, [r10+432];
ld.shared.f32 f253, [r10+576];
ld.shared.f32 f254, [r10+720];
add.f32 f255, f245, f247;
add.f32 f256, f243, f255;
add.f32 f257, f251, f253;
add.f32 f258, f249, f257;
mul.f32 f259, f255, 0f3F000000;
sub.f32 f260, f243, f259;
sub.f32 f261, f251, f253;
mul.f32 f262, f261, 0fBF5DB3D7;
add.f32 f263, f262, f260;
sub.f32 f264, f260, f262;
mul.f32 f265, f257, 0f3F000000;
sub.f32 f266, f249, f265;
sub.f32 f267, f245, f247;
mul.f32 f268, f267, 0fBF5DB3D7;
sub.f32 f269, f266, f268;
add.f32 f270, f268, f266;
add.f32 f271, f246, f248;
add.f32 f272, f244, f271;
add.f32 f273, f252, f254;
add.f32 f274, f250, f273;
mul.f32 f275, f271, 0f3F000000;
sub.f32 f276, f244, f275;
sub.f32 f277, f252, f254;
mul.f32 f278, f277, 0fBF5DB3D7;
add.f32 f279, f278, f276;
sub.f32 f280, f276, f278;
mul.f32 f281, f273, 0f3F000000;
sub.f32 f282, f250, f281;
sub.f32 f283, f246, f248;
mul.f32 f284, f283, 0fBF5DB3D7;
sub.f32 f285, f282, f284;
add.f32 f286, f284, f282;
mul.f32 f287, f279, 0f3F000000;
mul.f32 f288, f285, 0f3F5DB3D7;
sub.f32 f289, f287, f288;
mul.f32 f290, f285, 0f3F000000;
fma.rn.f32 f291, f279, 0f3F5DB3D7, f290;
mul.f32 f292, f280, 0fBF000000;
mul.f32 f293, f286, 0f3F5DB3D7;
sub.f32 f294, f292, f293;
mul.f32 f295, f286, 0fBF000000;
fma.rn.f32 f296, f280, 0f3F5DB3D7, f295;
add.f32 %0, f256, f272;
add.f32 %1, f258, f274;
add.f32 %3, f269, f291;
add.f32 %2, f263, f289;
add.f32 %5, f270, f296;
add.f32 %4, f264, f294;
sub.f32 %6, f256, f272;
sub.f32 %7, f258, f274;
sub.f32 %9, f269, f291;
sub.f32 %8, f263, f289;
sub.f32 %11, f270, f296;
sub.f32 %10, f264, f294;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y): "r"(smem), "l"(lut_sp_6_216), "l"(lut_sp_6_36), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y));
};


#endif
