#ifndef CUFFTDX_FFT_20_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_20_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<208, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<409>;
.reg .b64 rd<2>;
add.f32 f81, %50, %82;
add.f32 f82, %40, f81;
add.f32 f83, %61, %72;
add.f32 f84, f83, f82;
add.f32 f85, %52, %84;
add.f32 f86, %41, f85;
add.f32 f87, %63, %73;
add.f32 f88, f87, f86;
fma.rn.f32 f89, f81, 0f3E9E377A, %40;
mul.f32 f90, f83, 0f3F4F1BBD;
sub.f32 f91, f89, f90;
sub.f32 f92, %52, %84;
mul.f32 f93, f92, 0f3F737871;
sub.f32 f94, %63, %73;
fma.rn.f32 f95, f94, 0f3F167918, f93;
sub.f32 f96, f91, f95;
add.f32 f97, f95, f91;
mul.f32 f98, f81, 0f3F4F1BBD;
sub.f32 f99, %40, f98;
fma.rn.f32 f100, f83, 0f3E9E377A, f99;
mul.f32 f101, f92, 0f3F167918;
mul.f32 f102, f94, 0f3F737871;
sub.f32 f103, f101, f102;
sub.f32 f104, f100, f103;
add.f32 f105, f103, f100;
fma.rn.f32 f106, f85, 0f3E9E377A, %41;
mul.f32 f107, f87, 0f3F4F1BBD;
sub.f32 f108, f106, f107;
sub.f32 f109, %50, %82;
mul.f32 f110, f109, 0f3F737871;
sub.f32 f111, %61, %72;
fma.rn.f32 f112, f111, 0f3F167918, f110;
add.f32 f113, f112, f108;
sub.f32 f114, f108, f112;
mul.f32 f115, f85, 0f3F4F1BBD;
sub.f32 f116, %41, f115;
fma.rn.f32 f117, f87, 0f3E9E377A, f116;
mul.f32 f118, f109, 0f3F167918;
mul.f32 f119, f111, 0f3F737871;
sub.f32 f120, f118, f119;
add.f32 f121, f120, f117;
sub.f32 f122, f117, f120;
add.f32 f123, %56, %88;
add.f32 f124, %45, f123;
add.f32 f125, %66, %77;
add.f32 f126, f125, f124;
add.f32 f127, %57, %89;
add.f32 f128, %47, f127;
add.f32 f129, %68, %79;
add.f32 f130, f129, f128;
fma.rn.f32 f131, f123, 0f3E9E377A, %45;
mul.f32 f132, f125, 0f3F4F1BBD;
sub.f32 f133, f131, f132;
sub.f32 f134, %57, %89;
mul.f32 f135, f134, 0f3F737871;
sub.f32 f136, %68, %79;
fma.rn.f32 f137, f136, 0f3F167918, f135;
sub.f32 f138, f133, f137;
add.f32 f139, f137, f133;
mul.f32 f140, f123, 0f3F4F1BBD;
sub.f32 f141, %45, f140;
fma.rn.f32 f142, f125, 0f3E9E377A, f141;
mul.f32 f143, f134, 0f3F167918;
mul.f32 f144, f136, 0f3F737871;
sub.f32 f145, f143, f144;
sub.f32 f146, f142, f145;
add.f32 f147, f145, f142;
fma.rn.f32 f148, f127, 0f3E9E377A, %47;
mul.f32 f149, f129, 0f3F4F1BBD;
sub.f32 f150, f148, f149;
sub.f32 f151, %56, %88;
mul.f32 f152, f151, 0f3F737871;
sub.f32 f153, %66, %77;
fma.rn.f32 f154, f153, 0f3F167918, f152;
add.f32 f155, f154, f150;
sub.f32 f156, f150, f154;
mul.f32 f157, f127, 0f3F4F1BBD;
sub.f32 f158, %47, f157;
fma.rn.f32 f159, f129, 0f3E9E377A, f158;
mul.f32 f160, f151, 0f3F167918;
mul.f32 f161, f153, 0f3F737871;
sub.f32 f162, f160, f161;
add.f32 f163, f162, f159;
sub.f32 f164, f159, f162;
mul.f32 f165, f138, 0f3F4F1BBD;
mul.f32 f166, f155, 0f3F167918;
sub.f32 f167, f165, f166;
mul.f32 f168, f155, 0f3F4F1BBD;
fma.rn.f32 f169, f138, 0f3F167918, f168;
mul.f32 f170, f146, 0f3E9E377A;
mul.f32 f171, f163, 0f3F737871;
sub.f32 f172, f170, f171;
mul.f32 f173, f163, 0f3E9E377A;
fma.rn.f32 f174, f146, 0f3F737871, f173;
mul.f32 f175, f147, 0fBE9E377A;
mul.f32 f176, f164, 0f3F737871;
sub.f32 f177, f175, f176;
mul.f32 f178, f164, 0fBE9E377A;
fma.rn.f32 f179, f147, 0f3F737871, f178;
mul.f32 f180, f139, 0fBF4F1BBD;
mul.f32 f181, f156, 0f3F167918;
sub.f32 f182, f180, f181;
mul.f32 f183, f156, 0fBF4F1BBD;
fma.rn.f32 f184, f139, 0f3F167918, f183;
add.f32 f185, f84, f126;
add.f32 f186, f88, f130;
sub.f32 f187, f84, f126;
sub.f32 f188, f88, f130;
add.f32 f189, f96, f167;
add.f32 f190, f113, f169;
sub.f32 f191, f96, f167;
sub.f32 f192, f113, f169;
add.f32 f193, f104, f172;
add.f32 f194, f121, f174;
sub.f32 f195, f104, f172;
sub.f32 f196, f121, f174;
add.f32 f197, f105, f177;
add.f32 f198, f122, f179;
sub.f32 f199, f105, f177;
sub.f32 f200, f122, f179;
add.f32 f201, f97, f182;
add.f32 f202, f114, f184;
sub.f32 f203, f97, f182;
sub.f32 f204, f114, f184;
add.f32 f205, %53, %85;
add.f32 f206, %42, f205;
add.f32 f207, %64, %74;
add.f32 f208, f207, f206;
add.f32 f209, %55, %87;
add.f32 f210, %44, f209;
add.f32 f211, %65, %76;
add.f32 f212, f211, f210;
fma.rn.f32 f213, f205, 0f3E9E377A, %42;
mul.f32 f214, f207, 0f3F4F1BBD;
sub.f32 f215, f213, f214;
sub.f32 f216, %55, %87;
mul.f32 f217, f216, 0f3F737871;
sub.f32 f218, %65, %76;
fma.rn.f32 f219, f218, 0f3F167918, f217;
sub.f32 f220, f215, f219;
add.f32 f221, f219, f215;
mul.f32 f222, f205, 0f3F4F1BBD;
sub.f32 f223, %42, f222;
fma.rn.f32 f224, f207, 0f3E9E377A, f223;
mul.f32 f225, f216, 0f3F167918;
mul.f32 f226, f218, 0f3F737871;
sub.f32 f227, f225, f226;
sub.f32 f228, f224, f227;
add.f32 f229, f227, f224;
fma.rn.f32 f230, f209, 0f3E9E377A, %44;
mul.f32 f231, f211, 0f3F4F1BBD;
sub.f32 f232, f230, f231;
sub.f32 f233, %53, %85;
mul.f32 f234, f233, 0f3F737871;
sub.f32 f235, %64, %74;
fma.rn.f32 f236, f235, 0f3F167918, f234;
add.f32 f237, f236, f232;
sub.f32 f238, f232, f236;
mul.f32 f239, f209, 0f3F4F1BBD;
sub.f32 f240, %44, f239;
fma.rn.f32 f241, f211, 0f3E9E377A, f240;
mul.f32 f242, f233, 0f3F167918;
mul.f32 f243, f235, 0f3F737871;
sub.f32 f244, f242, f243;
add.f32 f245, f244, f241;
sub.f32 f246, f241, f244;
add.f32 f247, %58, %90;
add.f32 f248, %48, f247;
add.f32 f249, %69, %80;
add.f32 f250, f249, f248;
add.f32 f251, %60, %91;
add.f32 f252, %49, f251;
add.f32 f253, %71, %81;
add.f32 f254, f253, f252;
fma.rn.f32 f255, f247, 0f3E9E377A, %48;
mul.f32 f256, f249, 0f3F4F1BBD;
sub.f32 f257, f255, f256;
sub.f32 f258, %60, %91;
mul.f32 f259, f258, 0f3F737871;
sub.f32 f260, %71, %81;
fma.rn.f32 f261, f260, 0f3F167918, f259;
sub.f32 f262, f257, f261;
add.f32 f263, f261, f257;
mul.f32 f264, f247, 0f3F4F1BBD;
sub.f32 f265, %48, f264;
fma.rn.f32 f266, f249, 0f3E9E377A, f265;
mul.f32 f267, f258, 0f3F167918;
mul.f32 f268, f260, 0f3F737871;
sub.f32 f269, f267, f268;
sub.f32 f270, f266, f269;
add.f32 f271, f269, f266;
fma.rn.f32 f272, f251, 0f3E9E377A, %49;
mul.f32 f273, f253, 0f3F4F1BBD;
sub.f32 f274, f272, f273;
sub.f32 f275, %58, %90;
mul.f32 f276, f275, 0f3F737871;
sub.f32 f277, %69, %80;
fma.rn.f32 f278, f277, 0f3F167918, f276;
add.f32 f279, f278, f274;
sub.f32 f280, f274, f278;
mul.f32 f281, f251, 0f3F4F1BBD;
sub.f32 f282, %49, f281;
fma.rn.f32 f283, f253, 0f3E9E377A, f282;
mul.f32 f284, f275, 0f3F167918;
mul.f32 f285, f277, 0f3F737871;
sub.f32 f286, f284, f285;
add.f32 f287, f286, f283;
sub.f32 f288, f283, f286;
mul.f32 f289, f262, 0f3F4F1BBD;
mul.f32 f290, f279, 0f3F167918;
sub.f32 f291, f289, f290;
mul.f32 f292, f279, 0f3F4F1BBD;
fma.rn.f32 f293, f262, 0f3F167918, f292;
mul.f32 f294, f270, 0f3E9E377A;
mul.f32 f295, f287, 0f3F737871;
sub.f32 f296, f294, f295;
mul.f32 f297, f287, 0f3E9E377A;
fma.rn.f32 f298, f270, 0f3F737871, f297;
mul.f32 f299, f271, 0fBE9E377A;
mul.f32 f300, f288, 0f3F737871;
sub.f32 f301, f299, f300;
mul.f32 f302, f288, 0fBE9E377A;
fma.rn.f32 f303, f271, 0f3F737871, f302;
mul.f32 f304, f263, 0fBF4F1BBD;
mul.f32 f305, f280, 0f3F167918;
sub.f32 f306, f304, f305;
mul.f32 f307, f280, 0fBF4F1BBD;
fma.rn.f32 f308, f263, 0f3F167918, f307;
add.f32 f309, f208, f250;
add.f32 f310, f212, f254;
sub.f32 f311, f208, f250;
sub.f32 f312, f212, f254;
add.f32 f313, f220, f291;
add.f32 f314, f237, f293;
sub.f32 f315, f220, f291;
sub.f32 f316, f237, f293;
add.f32 f317, f228, f296;
add.f32 f318, f245, f298;
sub.f32 f319, f228, f296;
sub.f32 f320, f245, f298;
add.f32 f321, f229, f301;
add.f32 f322, f246, f303;
sub.f32 f323, f229, f301;
sub.f32 f324, f246, f303;
add.f32 f325, f221, f306;
add.f32 f326, f238, f308;
sub.f32 f327, f221, f306;
sub.f32 f328, f238, f308;
mul.f32 f329, f313, 0f3F737871;
mul.f32 f330, f314, 0f3E9E377A;
sub.f32 f331, f329, f330;
mul.f32 f332, f314, 0f3F737871;
fma.rn.f32 f333, f313, 0f3E9E377A, f332;
mul.f32 f334, f317, 0f3F4F1BBD;
mul.f32 f335, f318, 0f3F167918;
sub.f32 f336, f334, f335;
mul.f32 f337, f318, 0f3F4F1BBD;
fma.rn.f32 f338, f317, 0f3F167918, f337;
mul.f32 f339, f321, 0f3F167918;
mul.f32 f340, f322, 0f3F4F1BBD;
sub.f32 f341, f339, f340;
mul.f32 f342, f322, 0f3F167918;
fma.rn.f32 f343, f321, 0f3F4F1BBD, f342;
mul.f32 f344, f325, 0f3E9E377A;
mul.f32 f345, f326, 0f3F737871;
sub.f32 f346, f344, f345;
mul.f32 f347, f326, 0f3E9E377A;
fma.rn.f32 f348, f325, 0f3F737871, f347;
mul.f32 f349, f315, 0fBE9E377A;
mul.f32 f350, f316, 0f3F737871;
sub.f32 f351, f349, f350;
mul.f32 f352, f316, 0fBE9E377A;
fma.rn.f32 f353, f315, 0f3F737871, f352;
mul.f32 f354, f319, 0fBF167918;
mul.f32 f355, f320, 0f3F4F1BBD;
sub.f32 f356, f354, f355;
mul.f32 f357, f320, 0fBF167918;
fma.rn.f32 f358, f319, 0f3F4F1BBD, f357;
mul.f32 f359, f323, 0fBF4F1BBD;
mul.f32 f360, f324, 0f3F167918;
sub.f32 f361, f359, f360;
mul.f32 f362, f324, 0fBF4F1BBD;
fma.rn.f32 f363, f323, 0f3F167918, f362;
mul.f32 f364, f327, 0fBF737871;
mul.f32 f365, f328, 0f3E9E377A;
sub.f32 f366, f364, f365;
mul.f32 f367, f328, 0fBF737871;
fma.rn.f32 f368, f327, 0f3E9E377A, f367;
add.f32 %1, f186, f310;
add.f32 %0, f185, f309;
add.f32 %3, f190, f333;
add.f32 %2, f189, f331;
add.f32 %5, f194, f338;
add.f32 %4, f193, f336;
add.f32 %7, f198, f343;
add.f32 %6, f197, f341;
add.f32 %9, f202, f348;
add.f32 %8, f201, f346;
add.f32 %11, f188, f311;
sub.f32 %10, f187, f312;
add.f32 %13, f192, f353;
add.f32 %12, f191, f351;
add.f32 %15, f196, f358;
add.f32 %14, f195, f356;
add.f32 %17, f200, f363;
add.f32 %16, f199, f361;
add.f32 %19, f204, f368;
add.f32 %18, f203, f366;
sub.f32 %21, f186, f310;
sub.f32 %20, f185, f309;
sub.f32 %23, f190, f333;
sub.f32 %22, f189, f331;
sub.f32 %25, f194, f338;
sub.f32 %24, f193, f336;
sub.f32 %27, f198, f343;
sub.f32 %26, f197, f341;
sub.f32 %29, f202, f348;
sub.f32 %28, f201, f346;
sub.f32 %31, f188, f311;
add.f32 %30, f187, f312;
sub.f32 %33, f192, f353;
sub.f32 %32, f191, f351;
sub.f32 %35, f196, f358;
sub.f32 %34, f195, f356;
sub.f32 %37, f200, f363;
sub.f32 %36, f199, f361;
sub.f32 %39, f204, f368;
sub.f32 %38, f203, f366;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y): "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y));
};


#endif
