#ifndef CUFFTDX_FFT_1331_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_1331_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<727, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<735>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %22;
mad.lo.s32 r3, r1, 10648, r2;
add.f64 fd45, %27, %51;
add.f64 fd46, %29, %52;
sub.f64 fd47, %27, %51;
sub.f64 fd48, %29, %52;
add.f64 fd49, %30, %49;
add.f64 fd50, %32, %50;
sub.f64 fd51, %30, %49;
sub.f64 fd52, %32, %50;
add.f64 fd53, %33, %46;
add.f64 fd54, %34, %48;
sub.f64 fd55, %33, %46;
sub.f64 fd56, %34, %48;
add.f64 fd57, %35, %43;
add.f64 fd58, %37, %45;
sub.f64 fd59, %35, %43;
sub.f64 fd60, %37, %45;
add.f64 fd61, %38, %41;
add.f64 fd62, %40, %42;
sub.f64 fd63, %38, %41;
sub.f64 fd64, %40, %42;
mov.u32 r4, %tid.x;
add.f64 fd65, %25, fd45;
add.f64 fd66, %26, fd46;
add.f64 fd67, fd65, fd49;
add.f64 fd68, fd66, fd50;
add.f64 fd69, fd67, fd53;
add.f64 fd70, fd68, fd54;
add.f64 fd71, fd69, fd57;
add.f64 fd72, fd70, fd58;
add.f64 fd73, fd71, fd61;
add.f64 fd74, fd72, fd62;
fma.rn.f64 fd75, fd45, 0d3FEAEB8C8764F0BA, %25;
fma.rn.f64 fd76, fd48, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd77, fd46, 0d3FEAEB8C8764F0BA, %26;
fma.rn.f64 fd78, fd47, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd79, fd49, 0d3FDA9628D9C712B6, fd75;
fma.rn.f64 fd80, fd52, 0d3FED1BB48EEE2C13, fd76;
fma.rn.f64 fd81, fd50, 0d3FDA9628D9C712B6, fd77;
fma.rn.f64 fd82, fd51, 0d3FED1BB48EEE2C13, fd78;
fma.rn.f64 fd83, fd53, 0dBFC2375F640F44DB, fd79;
fma.rn.f64 fd84, fd56, 0d3FEFAC9E043842EF, fd80;
fma.rn.f64 fd85, fd54, 0dBFC2375F640F44DB, fd81;
fma.rn.f64 fd86, fd55, 0d3FEFAC9E043842EF, fd82;
fma.rn.f64 fd87, fd57, 0dBFE4F49E7F775887, fd83;
fma.rn.f64 fd88, fd60, 0d3FE82F19BB3A28A1, fd84;
fma.rn.f64 fd89, fd58, 0dBFE4F49E7F775887, fd85;
fma.rn.f64 fd90, fd59, 0d3FE82F19BB3A28A1, fd86;
fma.rn.f64 fd91, fd61, 0dBFEEB42A9BCD5057, fd87;
fma.rn.f64 fd92, fd64, 0d3FD207E7FD768DBF, fd88;
fma.rn.f64 fd93, fd62, 0dBFEEB42A9BCD5057, fd89;
fma.rn.f64 fd94, fd63, 0d3FD207E7FD768DBF, fd90;
sub.f64 fd95, fd91, fd92;
add.f64 fd96, fd94, fd93;
add.f64 fd97, fd92, fd91;
sub.f64 fd98, fd93, fd94;
fma.rn.f64 fd99, fd45, 0d3FDA9628D9C712B6, %25;
fma.rn.f64 fd100, fd48, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd101, fd46, 0d3FDA9628D9C712B6, %26;
fma.rn.f64 fd102, fd47, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd103, fd49, 0dBFE4F49E7F775887, fd99;
fma.rn.f64 fd104, fd52, 0d3FE82F19BB3A28A1, fd100;
fma.rn.f64 fd105, fd50, 0dBFE4F49E7F775887, fd101;
fma.rn.f64 fd106, fd51, 0d3FE82F19BB3A28A1, fd102;
fma.rn.f64 fd107, fd53, 0dBFEEB42A9BCD5057, fd103;
fma.rn.f64 fd108, fd56, 0dBFD207E7FD768DBF, fd104;
fma.rn.f64 fd109, fd54, 0dBFEEB42A9BCD5057, fd105;
fma.rn.f64 fd110, fd55, 0dBFD207E7FD768DBF, fd106;
fma.rn.f64 fd111, fd57, 0dBFC2375F640F44DB, fd107;
fma.rn.f64 fd112, fd60, 0dBFEFAC9E043842EF, fd108;
fma.rn.f64 fd113, fd58, 0dBFC2375F640F44DB, fd109;
fma.rn.f64 fd114, fd59, 0dBFEFAC9E043842EF, fd110;
fma.rn.f64 fd115, fd61, 0d3FEAEB8C8764F0BA, fd111;
fma.rn.f64 fd116, fd64, 0dBFE14CEDF8BB580B, fd112;
fma.rn.f64 fd117, fd62, 0d3FEAEB8C8764F0BA, fd113;
fma.rn.f64 fd118, fd63, 0dBFE14CEDF8BB580B, fd114;
sub.f64 fd119, fd115, fd116;
add.f64 fd120, fd118, fd117;
add.f64 fd121, fd116, fd115;
sub.f64 fd122, fd117, fd118;
fma.rn.f64 fd123, fd45, 0dBFC2375F640F44DB, %25;
fma.rn.f64 fd124, fd48, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd125, fd46, 0dBFC2375F640F44DB, %26;
fma.rn.f64 fd126, fd47, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd127, fd49, 0dBFEEB42A9BCD5057, fd123;
fma.rn.f64 fd128, fd52, 0dBFD207E7FD768DBF, fd124;
fma.rn.f64 fd129, fd50, 0dBFEEB42A9BCD5057, fd125;
fma.rn.f64 fd130, fd51, 0dBFD207E7FD768DBF, fd126;
fma.rn.f64 fd131, fd53, 0d3FDA9628D9C712B6, fd127;
fma.rn.f64 fd132, fd56, 0dBFED1BB48EEE2C13, fd128;
fma.rn.f64 fd133, fd54, 0d3FDA9628D9C712B6, fd129;
fma.rn.f64 fd134, fd55, 0dBFED1BB48EEE2C13, fd130;
fma.rn.f64 fd135, fd57, 0d3FEAEB8C8764F0BA, fd131;
fma.rn.f64 fd136, fd60, 0d3FE14CEDF8BB580B, fd132;
fma.rn.f64 fd137, fd58, 0d3FEAEB8C8764F0BA, fd133;
fma.rn.f64 fd138, fd59, 0d3FE14CEDF8BB580B, fd134;
fma.rn.f64 fd139, fd61, 0dBFE4F49E7F775887, fd135;
fma.rn.f64 fd140, fd64, 0d3FE82F19BB3A28A1, fd136;
fma.rn.f64 fd141, fd62, 0dBFE4F49E7F775887, fd137;
fma.rn.f64 fd142, fd63, 0d3FE82F19BB3A28A1, fd138;
sub.f64 fd143, fd139, fd140;
add.f64 fd144, fd142, fd141;
add.f64 fd145, fd140, fd139;
sub.f64 fd146, fd141, fd142;
fma.rn.f64 fd147, fd45, 0dBFE4F49E7F775887, %25;
fma.rn.f64 fd148, fd48, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd149, fd46, 0dBFE4F49E7F775887, %26;
fma.rn.f64 fd150, fd47, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd151, fd49, 0dBFC2375F640F44DB, fd147;
fma.rn.f64 fd152, fd52, 0dBFEFAC9E043842EF, fd148;
fma.rn.f64 fd153, fd50, 0dBFC2375F640F44DB, fd149;
fma.rn.f64 fd154, fd51, 0dBFEFAC9E043842EF, fd150;
fma.rn.f64 fd155, fd53, 0d3FEAEB8C8764F0BA, fd151;
fma.rn.f64 fd156, fd56, 0d3FE14CEDF8BB580B, fd152;
fma.rn.f64 fd157, fd54, 0d3FEAEB8C8764F0BA, fd153;
fma.rn.f64 fd158, fd55, 0d3FE14CEDF8BB580B, fd154;
fma.rn.f64 fd159, fd57, 0dBFEEB42A9BCD5057, fd155;
fma.rn.f64 fd160, fd60, 0d3FD207E7FD768DBF, fd156;
fma.rn.f64 fd161, fd58, 0dBFEEB42A9BCD5057, fd157;
fma.rn.f64 fd162, fd59, 0d3FD207E7FD768DBF, fd158;
fma.rn.f64 fd163, fd61, 0d3FDA9628D9C712B6, fd159;
fma.rn.f64 fd164, fd64, 0dBFED1BB48EEE2C13, fd160;
fma.rn.f64 fd165, fd62, 0d3FDA9628D9C712B6, fd161;
fma.rn.f64 fd166, fd63, 0dBFED1BB48EEE2C13, fd162;
sub.f64 fd167, fd163, fd164;
add.f64 fd168, fd166, fd165;
add.f64 fd169, fd164, fd163;
sub.f64 fd170, fd165, fd166;
fma.rn.f64 fd171, fd45, 0dBFEEB42A9BCD5057, %25;
fma.rn.f64 fd172, fd48, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd173, fd46, 0dBFEEB42A9BCD5057, %26;
fma.rn.f64 fd174, fd47, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd175, fd49, 0d3FEAEB8C8764F0BA, fd171;
fma.rn.f64 fd176, fd52, 0dBFE14CEDF8BB580B, fd172;
fma.rn.f64 fd177, fd50, 0d3FEAEB8C8764F0BA, fd173;
fma.rn.f64 fd178, fd51, 0dBFE14CEDF8BB580B, fd174;
fma.rn.f64 fd179, fd53, 0dBFE4F49E7F775887, fd175;
fma.rn.f64 fd180, fd56, 0d3FE82F19BB3A28A1, fd176;
fma.rn.f64 fd181, fd54, 0dBFE4F49E7F775887, fd177;
fma.rn.f64 fd182, fd55, 0d3FE82F19BB3A28A1, fd178;
fma.rn.f64 fd183, fd57, 0d3FDA9628D9C712B6, fd179;
fma.rn.f64 fd184, fd60, 0dBFED1BB48EEE2C13, fd180;
fma.rn.f64 fd185, fd58, 0d3FDA9628D9C712B6, fd181;
fma.rn.f64 fd186, fd59, 0dBFED1BB48EEE2C13, fd182;
fma.rn.f64 fd187, fd61, 0dBFC2375F640F44DB, fd183;
fma.rn.f64 fd188, fd64, 0d3FEFAC9E043842EF, fd184;
fma.rn.f64 fd189, fd62, 0dBFC2375F640F44DB, fd185;
fma.rn.f64 fd190, fd63, 0d3FEFAC9E043842EF, fd186;
sub.f64 fd191, fd187, fd188;
add.f64 fd192, fd190, fd189;
add.f64 fd193, fd188, fd187;
sub.f64 fd194, fd189, fd190;
mul.wide.u32 rd2, r4, 248469183;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 6;
mul.lo.s32 r10, r9, 121;
sub.s32 r11, r4, r10;
mul.wide.u32 rd4, r11, 16;
mov.u64 rd5, %23;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd195, fd196}, [rd6];
mul.f64 fd199, fd96, fd196;
fma.rn.f64 fd200, fd195, fd95, fd199;
mul.f64 fd201, fd95, fd196;
mul.f64 fd202, fd195, fd96;
sub.f64 fd203, fd202, fd201;
mul.f64 fd204, fd195, fd195;
mul.f64 fd205, fd196, fd196;
sub.f64 fd206, fd204, fd205;
mul.f64 fd207, fd196, fd195;
fma.rn.f64 fd208, fd196, fd195, fd207;
mul.f64 fd209, fd120, fd208;
fma.rn.f64 fd210, fd206, fd119, fd209;
mul.f64 fd211, fd119, fd208;
mul.f64 fd212, fd206, fd120;
sub.f64 fd213, fd212, fd211;
mul.f64 fd214, fd195, fd206;
mul.f64 fd215, fd196, fd208;
sub.f64 fd216, fd214, fd215;
mul.f64 fd217, fd195, fd208;
fma.rn.f64 fd218, fd196, fd206, fd217;
mul.f64 fd219, fd144, fd218;
fma.rn.f64 fd220, fd216, fd143, fd219;
mul.f64 fd221, fd143, fd218;
mul.f64 fd222, fd216, fd144;
sub.f64 fd223, fd222, fd221;
mul.f64 fd224, fd195, fd216;
mul.f64 fd225, fd196, fd218;
sub.f64 fd226, fd224, fd225;
mul.f64 fd227, fd195, fd218;
fma.rn.f64 fd228, fd196, fd216, fd227;
mul.f64 fd229, fd168, fd228;
fma.rn.f64 fd230, fd226, fd167, fd229;
mul.f64 fd231, fd167, fd228;
mul.f64 fd232, fd226, fd168;
sub.f64 fd233, fd232, fd231;
mul.f64 fd234, fd195, fd226;
mul.f64 fd235, fd196, fd228;
sub.f64 fd236, fd234, fd235;
mul.f64 fd237, fd195, fd228;
fma.rn.f64 fd238, fd196, fd226, fd237;
mul.f64 fd239, fd192, fd238;
fma.rn.f64 fd240, fd236, fd191, fd239;
mul.f64 fd241, fd191, fd238;
mul.f64 fd242, fd236, fd192;
sub.f64 fd243, fd242, fd241;
ld.global.v2.f64 {fd244, fd245}, [rd6+1936];
mul.f64 fd248, fd194, fd245;
fma.rn.f64 fd249, fd244, fd193, fd248;
mul.f64 fd250, fd193, fd245;
mul.f64 fd251, fd244, fd194;
sub.f64 fd252, fd251, fd250;
mul.f64 fd253, fd195, fd244;
mul.f64 fd254, fd196, fd245;
sub.f64 fd255, fd253, fd254;
mul.f64 fd256, fd195, fd245;
fma.rn.f64 fd257, fd196, fd244, fd256;
mul.f64 fd258, fd170, fd257;
fma.rn.f64 fd259, fd255, fd169, fd258;
mul.f64 fd260, fd169, fd257;
mul.f64 fd261, fd255, fd170;
sub.f64 fd262, fd261, fd260;
mul.f64 fd263, fd195, fd255;
mul.f64 fd264, fd196, fd257;
sub.f64 fd265, fd263, fd264;
mul.f64 fd266, fd195, fd257;
fma.rn.f64 fd267, fd196, fd255, fd266;
mul.f64 fd268, fd146, fd267;
fma.rn.f64 fd269, fd265, fd145, fd268;
mul.f64 fd270, fd145, fd267;
mul.f64 fd271, fd265, fd146;
sub.f64 fd272, fd271, fd270;
mul.f64 fd273, fd195, fd265;
mul.f64 fd274, fd196, fd267;
sub.f64 fd275, fd273, fd274;
mul.f64 fd276, fd195, fd267;
fma.rn.f64 fd277, fd196, fd265, fd276;
mul.f64 fd278, fd122, fd277;
fma.rn.f64 fd279, fd275, fd121, fd278;
mul.f64 fd280, fd121, fd277;
mul.f64 fd281, fd275, fd122;
sub.f64 fd282, fd281, fd280;
mul.f64 fd283, fd195, fd275;
mul.f64 fd284, fd196, fd277;
sub.f64 fd285, fd283, fd284;
mul.f64 fd286, fd195, fd277;
fma.rn.f64 fd287, fd196, fd275, fd286;
mul.f64 fd288, fd98, fd287;
fma.rn.f64 fd289, fd285, fd97, fd288;
mul.f64 fd290, fd97, fd287;
mul.f64 fd291, fd285, fd98;
sub.f64 fd292, fd291, fd290;
mad.lo.s32 r12, r9, 10648, r3;
barrier.sync 0;
mad.lo.s32 r13, r11, 88, r12;
st.shared.f64 [r13], fd73;
st.shared.f64 [r13+8], fd200;
st.shared.f64 [r13+16], fd210;
st.shared.f64 [r13+24], fd220;
st.shared.f64 [r13+32], fd230;
st.shared.f64 [r13+40], fd240;
st.shared.f64 [r13+48], fd249;
st.shared.f64 [r13+56], fd259;
st.shared.f64 [r13+64], fd269;
st.shared.f64 [r13+72], fd279;
st.shared.f64 [r13+80], fd289;
barrier.sync 0;
mad.lo.s32 r14, r11, -80, r13;
ld.shared.f64 fd293, [r14];
ld.shared.f64 fd294, [r14+968];
ld.shared.f64 fd295, [r14+1936];
ld.shared.f64 fd296, [r14+2904];
ld.shared.f64 fd297, [r14+3872];
ld.shared.f64 fd298, [r14+4840];
ld.shared.f64 fd299, [r14+5808];
ld.shared.f64 fd300, [r14+6776];
ld.shared.f64 fd301, [r14+7744];
ld.shared.f64 fd302, [r14+8712];
ld.shared.f64 fd303, [r14+9680];
barrier.sync 0;
st.shared.f64 [r13], fd74;
st.shared.f64 [r13+8], fd203;
st.shared.f64 [r13+16], fd213;
st.shared.f64 [r13+24], fd223;
st.shared.f64 [r13+32], fd233;
st.shared.f64 [r13+40], fd243;
st.shared.f64 [r13+48], fd252;
st.shared.f64 [r13+56], fd262;
st.shared.f64 [r13+64], fd272;
st.shared.f64 [r13+72], fd282;
st.shared.f64 [r13+80], fd292;
barrier.sync 0;
ld.shared.f64 fd304, [r14];
ld.shared.f64 fd305, [r14+968];
ld.shared.f64 fd306, [r14+1936];
ld.shared.f64 fd307, [r14+2904];
ld.shared.f64 fd308, [r14+3872];
ld.shared.f64 fd309, [r14+4840];
ld.shared.f64 fd310, [r14+5808];
ld.shared.f64 fd311, [r14+6776];
ld.shared.f64 fd312, [r14+7744];
ld.shared.f64 fd313, [r14+8712];
ld.shared.f64 fd314, [r14+9680];
add.f64 fd315, fd294, fd303;
add.f64 fd316, fd305, fd314;
sub.f64 fd317, fd294, fd303;
sub.f64 fd318, fd305, fd314;
add.f64 fd319, fd295, fd302;
add.f64 fd320, fd306, fd313;
sub.f64 fd321, fd295, fd302;
sub.f64 fd322, fd306, fd313;
add.f64 fd323, fd296, fd301;
add.f64 fd324, fd307, fd312;
sub.f64 fd325, fd296, fd301;
sub.f64 fd326, fd307, fd312;
add.f64 fd327, fd297, fd300;
add.f64 fd328, fd308, fd311;
sub.f64 fd329, fd297, fd300;
sub.f64 fd330, fd308, fd311;
add.f64 fd331, fd298, fd299;
add.f64 fd332, fd309, fd310;
sub.f64 fd333, fd298, fd299;
sub.f64 fd334, fd309, fd310;
add.f64 fd335, fd293, fd315;
add.f64 fd336, fd304, fd316;
add.f64 fd337, fd335, fd319;
add.f64 fd338, fd336, fd320;
add.f64 fd339, fd337, fd323;
add.f64 fd340, fd338, fd324;
add.f64 fd341, fd339, fd327;
add.f64 fd342, fd340, fd328;
add.f64 fd343, fd341, fd331;
add.f64 fd344, fd342, fd332;
fma.rn.f64 fd345, fd315, 0d3FEAEB8C8764F0BA, fd293;
fma.rn.f64 fd346, fd318, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd347, fd316, 0d3FEAEB8C8764F0BA, fd304;
fma.rn.f64 fd348, fd317, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd349, fd319, 0d3FDA9628D9C712B6, fd345;
fma.rn.f64 fd350, fd322, 0d3FED1BB48EEE2C13, fd346;
fma.rn.f64 fd351, fd320, 0d3FDA9628D9C712B6, fd347;
fma.rn.f64 fd352, fd321, 0d3FED1BB48EEE2C13, fd348;
fma.rn.f64 fd353, fd323, 0dBFC2375F640F44DB, fd349;
fma.rn.f64 fd354, fd326, 0d3FEFAC9E043842EF, fd350;
fma.rn.f64 fd355, fd324, 0dBFC2375F640F44DB, fd351;
fma.rn.f64 fd356, fd325, 0d3FEFAC9E043842EF, fd352;
fma.rn.f64 fd357, fd327, 0dBFE4F49E7F775887, fd353;
fma.rn.f64 fd358, fd330, 0d3FE82F19BB3A28A1, fd354;
fma.rn.f64 fd359, fd328, 0dBFE4F49E7F775887, fd355;
fma.rn.f64 fd360, fd329, 0d3FE82F19BB3A28A1, fd356;
fma.rn.f64 fd361, fd331, 0dBFEEB42A9BCD5057, fd357;
fma.rn.f64 fd362, fd334, 0d3FD207E7FD768DBF, fd358;
fma.rn.f64 fd363, fd332, 0dBFEEB42A9BCD5057, fd359;
fma.rn.f64 fd364, fd333, 0d3FD207E7FD768DBF, fd360;
sub.f64 fd365, fd361, fd362;
add.f64 fd366, fd364, fd363;
add.f64 fd367, fd362, fd361;
sub.f64 fd368, fd363, fd364;
fma.rn.f64 fd369, fd315, 0d3FDA9628D9C712B6, fd293;
fma.rn.f64 fd370, fd318, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd371, fd316, 0d3FDA9628D9C712B6, fd304;
fma.rn.f64 fd372, fd317, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd373, fd319, 0dBFE4F49E7F775887, fd369;
fma.rn.f64 fd374, fd322, 0d3FE82F19BB3A28A1, fd370;
fma.rn.f64 fd375, fd320, 0dBFE4F49E7F775887, fd371;
fma.rn.f64 fd376, fd321, 0d3FE82F19BB3A28A1, fd372;
fma.rn.f64 fd377, fd323, 0dBFEEB42A9BCD5057, fd373;
fma.rn.f64 fd378, fd326, 0dBFD207E7FD768DBF, fd374;
fma.rn.f64 fd379, fd324, 0dBFEEB42A9BCD5057, fd375;
fma.rn.f64 fd380, fd325, 0dBFD207E7FD768DBF, fd376;
fma.rn.f64 fd381, fd327, 0dBFC2375F640F44DB, fd377;
fma.rn.f64 fd382, fd330, 0dBFEFAC9E043842EF, fd378;
fma.rn.f64 fd383, fd328, 0dBFC2375F640F44DB, fd379;
fma.rn.f64 fd384, fd329, 0dBFEFAC9E043842EF, fd380;
fma.rn.f64 fd385, fd331, 0d3FEAEB8C8764F0BA, fd381;
fma.rn.f64 fd386, fd334, 0dBFE14CEDF8BB580B, fd382;
fma.rn.f64 fd387, fd332, 0d3FEAEB8C8764F0BA, fd383;
fma.rn.f64 fd388, fd333, 0dBFE14CEDF8BB580B, fd384;
sub.f64 fd389, fd385, fd386;
add.f64 fd390, fd388, fd387;
add.f64 fd391, fd386, fd385;
sub.f64 fd392, fd387, fd388;
fma.rn.f64 fd393, fd315, 0dBFC2375F640F44DB, fd293;
fma.rn.f64 fd394, fd318, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd395, fd316, 0dBFC2375F640F44DB, fd304;
fma.rn.f64 fd396, fd317, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd397, fd319, 0dBFEEB42A9BCD5057, fd393;
fma.rn.f64 fd398, fd322, 0dBFD207E7FD768DBF, fd394;
fma.rn.f64 fd399, fd320, 0dBFEEB42A9BCD5057, fd395;
fma.rn.f64 fd400, fd321, 0dBFD207E7FD768DBF, fd396;
fma.rn.f64 fd401, fd323, 0d3FDA9628D9C712B6, fd397;
fma.rn.f64 fd402, fd326, 0dBFED1BB48EEE2C13, fd398;
fma.rn.f64 fd403, fd324, 0d3FDA9628D9C712B6, fd399;
fma.rn.f64 fd404, fd325, 0dBFED1BB48EEE2C13, fd400;
fma.rn.f64 fd405, fd327, 0d3FEAEB8C8764F0BA, fd401;
fma.rn.f64 fd406, fd330, 0d3FE14CEDF8BB580B, fd402;
fma.rn.f64 fd407, fd328, 0d3FEAEB8C8764F0BA, fd403;
fma.rn.f64 fd408, fd329, 0d3FE14CEDF8BB580B, fd404;
fma.rn.f64 fd409, fd331, 0dBFE4F49E7F775887, fd405;
fma.rn.f64 fd410, fd334, 0d3FE82F19BB3A28A1, fd406;
fma.rn.f64 fd411, fd332, 0dBFE4F49E7F775887, fd407;
fma.rn.f64 fd412, fd333, 0d3FE82F19BB3A28A1, fd408;
sub.f64 fd413, fd409, fd410;
add.f64 fd414, fd412, fd411;
add.f64 fd415, fd410, fd409;
sub.f64 fd416, fd411, fd412;
fma.rn.f64 fd417, fd315, 0dBFE4F49E7F775887, fd293;
fma.rn.f64 fd418, fd318, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd419, fd316, 0dBFE4F49E7F775887, fd304;
fma.rn.f64 fd420, fd317, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd421, fd319, 0dBFC2375F640F44DB, fd417;
fma.rn.f64 fd422, fd322, 0dBFEFAC9E043842EF, fd418;
fma.rn.f64 fd423, fd320, 0dBFC2375F640F44DB, fd419;
fma.rn.f64 fd424, fd321, 0dBFEFAC9E043842EF, fd420;
fma.rn.f64 fd425, fd323, 0d3FEAEB8C8764F0BA, fd421;
fma.rn.f64 fd426, fd326, 0d3FE14CEDF8BB580B, fd422;
fma.rn.f64 fd427, fd324, 0d3FEAEB8C8764F0BA, fd423;
fma.rn.f64 fd428, fd325, 0d3FE14CEDF8BB580B, fd424;
fma.rn.f64 fd429, fd327, 0dBFEEB42A9BCD5057, fd425;
fma.rn.f64 fd430, fd330, 0d3FD207E7FD768DBF, fd426;
fma.rn.f64 fd431, fd328, 0dBFEEB42A9BCD5057, fd427;
fma.rn.f64 fd432, fd329, 0d3FD207E7FD768DBF, fd428;
fma.rn.f64 fd433, fd331, 0d3FDA9628D9C712B6, fd429;
fma.rn.f64 fd434, fd334, 0dBFED1BB48EEE2C13, fd430;
fma.rn.f64 fd435, fd332, 0d3FDA9628D9C712B6, fd431;
fma.rn.f64 fd436, fd333, 0dBFED1BB48EEE2C13, fd432;
sub.f64 fd437, fd433, fd434;
add.f64 fd438, fd436, fd435;
add.f64 fd439, fd434, fd433;
sub.f64 fd440, fd435, fd436;
fma.rn.f64 fd441, fd315, 0dBFEEB42A9BCD5057, fd293;
fma.rn.f64 fd442, fd318, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd443, fd316, 0dBFEEB42A9BCD5057, fd304;
fma.rn.f64 fd444, fd317, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd445, fd319, 0d3FEAEB8C8764F0BA, fd441;
fma.rn.f64 fd446, fd322, 0dBFE14CEDF8BB580B, fd442;
fma.rn.f64 fd447, fd320, 0d3FEAEB8C8764F0BA, fd443;
fma.rn.f64 fd448, fd321, 0dBFE14CEDF8BB580B, fd444;
fma.rn.f64 fd449, fd323, 0dBFE4F49E7F775887, fd445;
fma.rn.f64 fd450, fd326, 0d3FE82F19BB3A28A1, fd446;
fma.rn.f64 fd451, fd324, 0dBFE4F49E7F775887, fd447;
fma.rn.f64 fd452, fd325, 0d3FE82F19BB3A28A1, fd448;
fma.rn.f64 fd453, fd327, 0d3FDA9628D9C712B6, fd449;
fma.rn.f64 fd454, fd330, 0dBFED1BB48EEE2C13, fd450;
fma.rn.f64 fd455, fd328, 0d3FDA9628D9C712B6, fd451;
fma.rn.f64 fd456, fd329, 0dBFED1BB48EEE2C13, fd452;
fma.rn.f64 fd457, fd331, 0dBFC2375F640F44DB, fd453;
fma.rn.f64 fd458, fd334, 0d3FEFAC9E043842EF, fd454;
fma.rn.f64 fd459, fd332, 0dBFC2375F640F44DB, fd455;
fma.rn.f64 fd460, fd333, 0d3FEFAC9E043842EF, fd456;
sub.f64 fd461, fd457, fd458;
add.f64 fd462, fd460, fd459;
add.f64 fd463, fd458, fd457;
sub.f64 fd464, fd459, fd460;
mul.wide.u32 rd7, r11, -1171354717;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r15, rd8;
mul.lo.s32 r16, r15, 11;
sub.s32 r17, r11, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %24;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd465, fd466}, [rd11];
mul.f64 fd469, fd366, fd466;
fma.rn.f64 fd470, fd465, fd365, fd469;
mul.f64 fd471, fd365, fd466;
mul.f64 fd472, fd465, fd366;
sub.f64 fd473, fd472, fd471;
mul.f64 fd474, fd465, fd465;
mul.f64 fd475, fd466, fd466;
sub.f64 fd476, fd474, fd475;
mul.f64 fd477, fd466, fd465;
fma.rn.f64 fd478, fd466, fd465, fd477;
mul.f64 fd479, fd390, fd478;
fma.rn.f64 fd480, fd476, fd389, fd479;
mul.f64 fd481, fd389, fd478;
mul.f64 fd482, fd476, fd390;
sub.f64 fd483, fd482, fd481;
mul.f64 fd484, fd465, fd476;
mul.f64 fd485, fd466, fd478;
sub.f64 fd486, fd484, fd485;
mul.f64 fd487, fd465, fd478;
fma.rn.f64 fd488, fd466, fd476, fd487;
mul.f64 fd489, fd414, fd488;
fma.rn.f64 fd490, fd486, fd413, fd489;
mul.f64 fd491, fd413, fd488;
mul.f64 fd492, fd486, fd414;
sub.f64 fd493, fd492, fd491;
mul.f64 fd494, fd465, fd486;
mul.f64 fd495, fd466, fd488;
sub.f64 fd496, fd494, fd495;
mul.f64 fd497, fd465, fd488;
fma.rn.f64 fd498, fd466, fd486, fd497;
mul.f64 fd499, fd438, fd498;
fma.rn.f64 fd500, fd496, fd437, fd499;
mul.f64 fd501, fd437, fd498;
mul.f64 fd502, fd496, fd438;
sub.f64 fd503, fd502, fd501;
mul.f64 fd504, fd465, fd496;
mul.f64 fd505, fd466, fd498;
sub.f64 fd506, fd504, fd505;
mul.f64 fd507, fd465, fd498;
fma.rn.f64 fd508, fd466, fd496, fd507;
mul.f64 fd509, fd462, fd508;
fma.rn.f64 fd510, fd506, fd461, fd509;
mul.f64 fd511, fd461, fd508;
mul.f64 fd512, fd506, fd462;
sub.f64 fd513, fd512, fd511;
ld.global.v2.f64 {fd514, fd515}, [rd11+176];
mul.f64 fd518, fd464, fd515;
fma.rn.f64 fd519, fd514, fd463, fd518;
mul.f64 fd520, fd463, fd515;
mul.f64 fd521, fd514, fd464;
sub.f64 fd522, fd521, fd520;
mul.f64 fd523, fd465, fd514;
mul.f64 fd524, fd466, fd515;
sub.f64 fd525, fd523, fd524;
mul.f64 fd526, fd465, fd515;
fma.rn.f64 fd527, fd466, fd514, fd526;
mul.f64 fd528, fd440, fd527;
fma.rn.f64 fd529, fd525, fd439, fd528;
mul.f64 fd530, fd439, fd527;
mul.f64 fd531, fd525, fd440;
sub.f64 fd532, fd531, fd530;
mul.f64 fd533, fd465, fd525;
mul.f64 fd534, fd466, fd527;
sub.f64 fd535, fd533, fd534;
mul.f64 fd536, fd465, fd527;
fma.rn.f64 fd537, fd466, fd525, fd536;
mul.f64 fd538, fd416, fd537;
fma.rn.f64 fd539, fd535, fd415, fd538;
mul.f64 fd540, fd415, fd537;
mul.f64 fd541, fd535, fd416;
sub.f64 fd542, fd541, fd540;
mul.f64 fd543, fd465, fd535;
mul.f64 fd544, fd466, fd537;
sub.f64 fd545, fd543, fd544;
mul.f64 fd546, fd465, fd537;
fma.rn.f64 fd547, fd466, fd535, fd546;
mul.f64 fd548, fd392, fd547;
fma.rn.f64 fd549, fd545, fd391, fd548;
mul.f64 fd550, fd391, fd547;
mul.f64 fd551, fd545, fd392;
sub.f64 fd552, fd551, fd550;
mul.f64 fd553, fd465, fd545;
mul.f64 fd554, fd466, fd547;
sub.f64 fd555, fd553, fd554;
mul.f64 fd556, fd465, fd547;
fma.rn.f64 fd557, fd466, fd545, fd556;
mul.f64 fd558, fd368, fd557;
fma.rn.f64 fd559, fd555, fd367, fd558;
mul.f64 fd560, fd367, fd557;
mul.f64 fd561, fd555, fd368;
sub.f64 fd562, fd561, fd560;
shl.b32 r18, r17, 3;
add.s32 r19, r12, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 968, r19;
st.shared.f64 [r20], fd343;
st.shared.f64 [r20+88], fd470;
st.shared.f64 [r20+176], fd480;
st.shared.f64 [r20+264], fd490;
st.shared.f64 [r20+352], fd500;
st.shared.f64 [r20+440], fd510;
st.shared.f64 [r20+528], fd519;
st.shared.f64 [r20+616], fd529;
st.shared.f64 [r20+704], fd539;
st.shared.f64 [r20+792], fd549;
st.shared.f64 [r20+880], fd559;
barrier.sync 0;
ld.shared.f64 fd563, [r14];
ld.shared.f64 fd564, [r14+968];
ld.shared.f64 fd565, [r14+1936];
ld.shared.f64 fd566, [r14+2904];
ld.shared.f64 fd567, [r14+3872];
ld.shared.f64 fd568, [r14+4840];
ld.shared.f64 fd569, [r14+5808];
ld.shared.f64 fd570, [r14+6776];
ld.shared.f64 fd571, [r14+7744];
ld.shared.f64 fd572, [r14+8712];
ld.shared.f64 fd573, [r14+9680];
barrier.sync 0;
st.shared.f64 [r20], fd344;
st.shared.f64 [r20+88], fd473;
st.shared.f64 [r20+176], fd483;
st.shared.f64 [r20+264], fd493;
st.shared.f64 [r20+352], fd503;
st.shared.f64 [r20+440], fd513;
st.shared.f64 [r20+528], fd522;
st.shared.f64 [r20+616], fd532;
st.shared.f64 [r20+704], fd542;
st.shared.f64 [r20+792], fd552;
st.shared.f64 [r20+880], fd562;
barrier.sync 0;
ld.shared.f64 fd574, [r14];
ld.shared.f64 fd575, [r14+968];
ld.shared.f64 fd576, [r14+1936];
ld.shared.f64 fd577, [r14+2904];
ld.shared.f64 fd578, [r14+3872];
ld.shared.f64 fd579, [r14+4840];
ld.shared.f64 fd580, [r14+5808];
ld.shared.f64 fd581, [r14+6776];
ld.shared.f64 fd582, [r14+7744];
ld.shared.f64 fd583, [r14+8712];
ld.shared.f64 fd584, [r14+9680];
add.f64 fd585, fd564, fd573;
add.f64 fd586, fd575, fd584;
sub.f64 fd587, fd564, fd573;
sub.f64 fd588, fd575, fd584;
add.f64 fd589, fd565, fd572;
add.f64 fd590, fd576, fd583;
sub.f64 fd591, fd565, fd572;
sub.f64 fd592, fd576, fd583;
add.f64 fd593, fd566, fd571;
add.f64 fd594, fd577, fd582;
sub.f64 fd595, fd566, fd571;
sub.f64 fd596, fd577, fd582;
add.f64 fd597, fd567, fd570;
add.f64 fd598, fd578, fd581;
sub.f64 fd599, fd567, fd570;
sub.f64 fd600, fd578, fd581;
add.f64 fd601, fd568, fd569;
add.f64 fd602, fd579, fd580;
sub.f64 fd603, fd568, fd569;
sub.f64 fd604, fd579, fd580;
add.f64 fd605, fd563, fd585;
add.f64 fd606, fd574, fd586;
add.f64 fd607, fd605, fd589;
add.f64 fd608, fd606, fd590;
add.f64 fd609, fd607, fd593;
add.f64 fd610, fd608, fd594;
add.f64 fd611, fd609, fd597;
add.f64 fd612, fd610, fd598;
fma.rn.f64 fd613, fd585, 0d3FEAEB8C8764F0BA, fd563;
fma.rn.f64 fd614, fd588, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd615, fd586, 0d3FEAEB8C8764F0BA, fd574;
fma.rn.f64 fd616, fd587, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd617, fd589, 0d3FDA9628D9C712B6, fd613;
fma.rn.f64 fd618, fd592, 0d3FED1BB48EEE2C13, fd614;
fma.rn.f64 fd619, fd590, 0d3FDA9628D9C712B6, fd615;
fma.rn.f64 fd620, fd591, 0d3FED1BB48EEE2C13, fd616;
fma.rn.f64 fd621, fd593, 0dBFC2375F640F44DB, fd617;
fma.rn.f64 fd622, fd596, 0d3FEFAC9E043842EF, fd618;
fma.rn.f64 fd623, fd594, 0dBFC2375F640F44DB, fd619;
fma.rn.f64 fd624, fd595, 0d3FEFAC9E043842EF, fd620;
fma.rn.f64 fd625, fd597, 0dBFE4F49E7F775887, fd621;
fma.rn.f64 fd626, fd600, 0d3FE82F19BB3A28A1, fd622;
fma.rn.f64 fd627, fd598, 0dBFE4F49E7F775887, fd623;
fma.rn.f64 fd628, fd599, 0d3FE82F19BB3A28A1, fd624;
fma.rn.f64 fd629, fd601, 0dBFEEB42A9BCD5057, fd625;
fma.rn.f64 fd630, fd604, 0d3FD207E7FD768DBF, fd626;
fma.rn.f64 fd631, fd602, 0dBFEEB42A9BCD5057, fd627;
fma.rn.f64 fd632, fd603, 0d3FD207E7FD768DBF, fd628;
fma.rn.f64 fd633, fd585, 0d3FDA9628D9C712B6, fd563;
fma.rn.f64 fd634, fd588, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd635, fd586, 0d3FDA9628D9C712B6, fd574;
fma.rn.f64 fd636, fd587, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd637, fd589, 0dBFE4F49E7F775887, fd633;
fma.rn.f64 fd638, fd592, 0d3FE82F19BB3A28A1, fd634;
fma.rn.f64 fd639, fd590, 0dBFE4F49E7F775887, fd635;
fma.rn.f64 fd640, fd591, 0d3FE82F19BB3A28A1, fd636;
fma.rn.f64 fd641, fd593, 0dBFEEB42A9BCD5057, fd637;
fma.rn.f64 fd642, fd596, 0dBFD207E7FD768DBF, fd638;
fma.rn.f64 fd643, fd594, 0dBFEEB42A9BCD5057, fd639;
fma.rn.f64 fd644, fd595, 0dBFD207E7FD768DBF, fd640;
fma.rn.f64 fd645, fd597, 0dBFC2375F640F44DB, fd641;
fma.rn.f64 fd646, fd600, 0dBFEFAC9E043842EF, fd642;
fma.rn.f64 fd647, fd598, 0dBFC2375F640F44DB, fd643;
fma.rn.f64 fd648, fd599, 0dBFEFAC9E043842EF, fd644;
fma.rn.f64 fd649, fd601, 0d3FEAEB8C8764F0BA, fd645;
fma.rn.f64 fd650, fd604, 0dBFE14CEDF8BB580B, fd646;
fma.rn.f64 fd651, fd602, 0d3FEAEB8C8764F0BA, fd647;
fma.rn.f64 fd652, fd603, 0dBFE14CEDF8BB580B, fd648;
fma.rn.f64 fd653, fd585, 0dBFC2375F640F44DB, fd563;
fma.rn.f64 fd654, fd588, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd655, fd586, 0dBFC2375F640F44DB, fd574;
fma.rn.f64 fd656, fd587, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd657, fd589, 0dBFEEB42A9BCD5057, fd653;
fma.rn.f64 fd658, fd592, 0dBFD207E7FD768DBF, fd654;
fma.rn.f64 fd659, fd590, 0dBFEEB42A9BCD5057, fd655;
fma.rn.f64 fd660, fd591, 0dBFD207E7FD768DBF, fd656;
fma.rn.f64 fd661, fd593, 0d3FDA9628D9C712B6, fd657;
fma.rn.f64 fd662, fd596, 0dBFED1BB48EEE2C13, fd658;
fma.rn.f64 fd663, fd594, 0d3FDA9628D9C712B6, fd659;
fma.rn.f64 fd664, fd595, 0dBFED1BB48EEE2C13, fd660;
fma.rn.f64 fd665, fd597, 0d3FEAEB8C8764F0BA, fd661;
fma.rn.f64 fd666, fd600, 0d3FE14CEDF8BB580B, fd662;
fma.rn.f64 fd667, fd598, 0d3FEAEB8C8764F0BA, fd663;
fma.rn.f64 fd668, fd599, 0d3FE14CEDF8BB580B, fd664;
fma.rn.f64 fd669, fd601, 0dBFE4F49E7F775887, fd665;
fma.rn.f64 fd670, fd604, 0d3FE82F19BB3A28A1, fd666;
fma.rn.f64 fd671, fd602, 0dBFE4F49E7F775887, fd667;
fma.rn.f64 fd672, fd603, 0d3FE82F19BB3A28A1, fd668;
fma.rn.f64 fd673, fd585, 0dBFE4F49E7F775887, fd563;
fma.rn.f64 fd674, fd588, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd675, fd586, 0dBFE4F49E7F775887, fd574;
fma.rn.f64 fd676, fd587, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd677, fd589, 0dBFC2375F640F44DB, fd673;
fma.rn.f64 fd678, fd592, 0dBFEFAC9E043842EF, fd674;
fma.rn.f64 fd679, fd590, 0dBFC2375F640F44DB, fd675;
fma.rn.f64 fd680, fd591, 0dBFEFAC9E043842EF, fd676;
fma.rn.f64 fd681, fd593, 0d3FEAEB8C8764F0BA, fd677;
fma.rn.f64 fd682, fd596, 0d3FE14CEDF8BB580B, fd678;
fma.rn.f64 fd683, fd594, 0d3FEAEB8C8764F0BA, fd679;
fma.rn.f64 fd684, fd595, 0d3FE14CEDF8BB580B, fd680;
fma.rn.f64 fd685, fd597, 0dBFEEB42A9BCD5057, fd681;
fma.rn.f64 fd686, fd600, 0d3FD207E7FD768DBF, fd682;
fma.rn.f64 fd687, fd598, 0dBFEEB42A9BCD5057, fd683;
fma.rn.f64 fd688, fd599, 0d3FD207E7FD768DBF, fd684;
fma.rn.f64 fd689, fd601, 0d3FDA9628D9C712B6, fd685;
fma.rn.f64 fd690, fd604, 0dBFED1BB48EEE2C13, fd686;
fma.rn.f64 fd691, fd602, 0d3FDA9628D9C712B6, fd687;
fma.rn.f64 fd692, fd603, 0dBFED1BB48EEE2C13, fd688;
fma.rn.f64 fd693, fd585, 0dBFEEB42A9BCD5057, fd563;
fma.rn.f64 fd694, fd588, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd695, fd586, 0dBFEEB42A9BCD5057, fd574;
fma.rn.f64 fd696, fd587, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd697, fd589, 0d3FEAEB8C8764F0BA, fd693;
fma.rn.f64 fd698, fd592, 0dBFE14CEDF8BB580B, fd694;
fma.rn.f64 fd699, fd590, 0d3FEAEB8C8764F0BA, fd695;
fma.rn.f64 fd700, fd591, 0dBFE14CEDF8BB580B, fd696;
fma.rn.f64 fd701, fd593, 0dBFE4F49E7F775887, fd697;
fma.rn.f64 fd702, fd596, 0d3FE82F19BB3A28A1, fd698;
fma.rn.f64 fd703, fd594, 0dBFE4F49E7F775887, fd699;
fma.rn.f64 fd704, fd595, 0d3FE82F19BB3A28A1, fd700;
fma.rn.f64 fd705, fd597, 0d3FDA9628D9C712B6, fd701;
fma.rn.f64 fd706, fd600, 0dBFED1BB48EEE2C13, fd702;
fma.rn.f64 fd707, fd598, 0d3FDA9628D9C712B6, fd703;
fma.rn.f64 fd708, fd599, 0dBFED1BB48EEE2C13, fd704;
fma.rn.f64 fd709, fd601, 0dBFC2375F640F44DB, fd705;
fma.rn.f64 fd710, fd604, 0d3FEFAC9E043842EF, fd706;
fma.rn.f64 fd711, fd602, 0dBFC2375F640F44DB, fd707;
fma.rn.f64 fd712, fd603, 0d3FEFAC9E043842EF, fd708;
add.f64 %0, fd611, fd601;
add.f64 %1, fd612, fd602;
add.f64 %3, fd632, fd631;
sub.f64 %2, fd629, fd630;
add.f64 %5, fd652, fd651;
sub.f64 %4, fd649, fd650;
add.f64 %7, fd672, fd671;
sub.f64 %6, fd669, fd670;
add.f64 %9, fd692, fd691;
sub.f64 %8, fd689, fd690;
add.f64 %11, fd712, fd711;
sub.f64 %10, fd709, fd710;
sub.f64 %13, fd711, fd712;
add.f64 %12, fd710, fd709;
sub.f64 %15, fd691, fd692;
add.f64 %14, fd690, fd689;
sub.f64 %17, fd671, fd672;
add.f64 %16, fd670, fd669;
sub.f64 %19, fd651, fd652;
add.f64 %18, fd650, fd649;
sub.f64 %21, fd631, fd632;
add.f64 %20, fd630, fd629;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y): "r"(smem), "l"(lut_dp_11_1331), "l"(lut_dp_11_121), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<728, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<21>;
.reg .f64 fd<779>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %22;
mad.lo.s32 r3, r1, 21296, r2;
add.f64 fd45, %27, %51;
add.f64 fd46, %29, %52;
sub.f64 fd47, %27, %51;
sub.f64 fd48, %29, %52;
add.f64 fd49, %30, %49;
add.f64 fd50, %32, %50;
sub.f64 fd51, %30, %49;
sub.f64 fd52, %32, %50;
add.f64 fd53, %33, %46;
add.f64 fd54, %34, %48;
sub.f64 fd55, %33, %46;
sub.f64 fd56, %34, %48;
add.f64 fd57, %35, %43;
add.f64 fd58, %37, %45;
sub.f64 fd59, %35, %43;
sub.f64 fd60, %37, %45;
add.f64 fd61, %38, %41;
add.f64 fd62, %40, %42;
sub.f64 fd63, %38, %41;
sub.f64 fd64, %40, %42;
mov.u32 r4, %tid.x;
add.f64 fd65, %25, fd45;
add.f64 fd66, %26, fd46;
add.f64 fd67, fd65, fd49;
add.f64 fd68, fd66, fd50;
add.f64 fd69, fd67, fd53;
add.f64 fd70, fd68, fd54;
add.f64 fd71, fd69, fd57;
add.f64 fd72, fd70, fd58;
fma.rn.f64 fd73, fd45, 0d3FEAEB8C8764F0BA, %25;
fma.rn.f64 fd74, fd48, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd75, fd46, 0d3FEAEB8C8764F0BA, %26;
fma.rn.f64 fd76, fd47, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd77, fd49, 0d3FDA9628D9C712B6, fd73;
fma.rn.f64 fd78, fd52, 0d3FED1BB48EEE2C13, fd74;
fma.rn.f64 fd79, fd50, 0d3FDA9628D9C712B6, fd75;
fma.rn.f64 fd80, fd51, 0d3FED1BB48EEE2C13, fd76;
fma.rn.f64 fd81, fd53, 0dBFC2375F640F44DB, fd77;
fma.rn.f64 fd82, fd56, 0d3FEFAC9E043842EF, fd78;
fma.rn.f64 fd83, fd54, 0dBFC2375F640F44DB, fd79;
fma.rn.f64 fd84, fd55, 0d3FEFAC9E043842EF, fd80;
fma.rn.f64 fd85, fd57, 0dBFE4F49E7F775887, fd81;
fma.rn.f64 fd86, fd60, 0d3FE82F19BB3A28A1, fd82;
fma.rn.f64 fd87, fd58, 0dBFE4F49E7F775887, fd83;
fma.rn.f64 fd88, fd59, 0d3FE82F19BB3A28A1, fd84;
fma.rn.f64 fd89, fd61, 0dBFEEB42A9BCD5057, fd85;
fma.rn.f64 fd90, fd64, 0d3FD207E7FD768DBF, fd86;
fma.rn.f64 fd91, fd62, 0dBFEEB42A9BCD5057, fd87;
fma.rn.f64 fd92, fd63, 0d3FD207E7FD768DBF, fd88;
sub.f64 fd93, fd89, fd90;
add.f64 fd94, fd92, fd91;
add.f64 fd95, fd90, fd89;
sub.f64 fd96, fd91, fd92;
fma.rn.f64 fd97, fd45, 0d3FDA9628D9C712B6, %25;
fma.rn.f64 fd98, fd48, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd99, fd46, 0d3FDA9628D9C712B6, %26;
fma.rn.f64 fd100, fd47, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd101, fd49, 0dBFE4F49E7F775887, fd97;
fma.rn.f64 fd102, fd52, 0d3FE82F19BB3A28A1, fd98;
fma.rn.f64 fd103, fd50, 0dBFE4F49E7F775887, fd99;
fma.rn.f64 fd104, fd51, 0d3FE82F19BB3A28A1, fd100;
fma.rn.f64 fd105, fd53, 0dBFEEB42A9BCD5057, fd101;
fma.rn.f64 fd106, fd56, 0dBFD207E7FD768DBF, fd102;
fma.rn.f64 fd107, fd54, 0dBFEEB42A9BCD5057, fd103;
fma.rn.f64 fd108, fd55, 0dBFD207E7FD768DBF, fd104;
fma.rn.f64 fd109, fd57, 0dBFC2375F640F44DB, fd105;
fma.rn.f64 fd110, fd60, 0dBFEFAC9E043842EF, fd106;
fma.rn.f64 fd111, fd58, 0dBFC2375F640F44DB, fd107;
fma.rn.f64 fd112, fd59, 0dBFEFAC9E043842EF, fd108;
fma.rn.f64 fd113, fd61, 0d3FEAEB8C8764F0BA, fd109;
fma.rn.f64 fd114, fd64, 0dBFE14CEDF8BB580B, fd110;
fma.rn.f64 fd115, fd62, 0d3FEAEB8C8764F0BA, fd111;
fma.rn.f64 fd116, fd63, 0dBFE14CEDF8BB580B, fd112;
sub.f64 fd117, fd113, fd114;
add.f64 fd118, fd116, fd115;
add.f64 fd119, fd114, fd113;
sub.f64 fd120, fd115, fd116;
fma.rn.f64 fd121, fd45, 0dBFC2375F640F44DB, %25;
fma.rn.f64 fd122, fd48, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd123, fd46, 0dBFC2375F640F44DB, %26;
fma.rn.f64 fd124, fd47, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd125, fd49, 0dBFEEB42A9BCD5057, fd121;
fma.rn.f64 fd126, fd52, 0dBFD207E7FD768DBF, fd122;
fma.rn.f64 fd127, fd50, 0dBFEEB42A9BCD5057, fd123;
fma.rn.f64 fd128, fd51, 0dBFD207E7FD768DBF, fd124;
fma.rn.f64 fd129, fd53, 0d3FDA9628D9C712B6, fd125;
fma.rn.f64 fd130, fd56, 0dBFED1BB48EEE2C13, fd126;
fma.rn.f64 fd131, fd54, 0d3FDA9628D9C712B6, fd127;
fma.rn.f64 fd132, fd55, 0dBFED1BB48EEE2C13, fd128;
fma.rn.f64 fd133, fd57, 0d3FEAEB8C8764F0BA, fd129;
fma.rn.f64 fd134, fd60, 0d3FE14CEDF8BB580B, fd130;
fma.rn.f64 fd135, fd58, 0d3FEAEB8C8764F0BA, fd131;
fma.rn.f64 fd136, fd59, 0d3FE14CEDF8BB580B, fd132;
fma.rn.f64 fd137, fd61, 0dBFE4F49E7F775887, fd133;
fma.rn.f64 fd138, fd64, 0d3FE82F19BB3A28A1, fd134;
fma.rn.f64 fd139, fd62, 0dBFE4F49E7F775887, fd135;
fma.rn.f64 fd140, fd63, 0d3FE82F19BB3A28A1, fd136;
sub.f64 fd141, fd137, fd138;
add.f64 fd142, fd140, fd139;
add.f64 fd143, fd138, fd137;
sub.f64 fd144, fd139, fd140;
fma.rn.f64 fd145, fd45, 0dBFE4F49E7F775887, %25;
fma.rn.f64 fd146, fd48, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd147, fd46, 0dBFE4F49E7F775887, %26;
fma.rn.f64 fd148, fd47, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd149, fd49, 0dBFC2375F640F44DB, fd145;
fma.rn.f64 fd150, fd52, 0dBFEFAC9E043842EF, fd146;
fma.rn.f64 fd151, fd50, 0dBFC2375F640F44DB, fd147;
fma.rn.f64 fd152, fd51, 0dBFEFAC9E043842EF, fd148;
fma.rn.f64 fd153, fd53, 0d3FEAEB8C8764F0BA, fd149;
fma.rn.f64 fd154, fd56, 0d3FE14CEDF8BB580B, fd150;
fma.rn.f64 fd155, fd54, 0d3FEAEB8C8764F0BA, fd151;
fma.rn.f64 fd156, fd55, 0d3FE14CEDF8BB580B, fd152;
fma.rn.f64 fd157, fd57, 0dBFEEB42A9BCD5057, fd153;
fma.rn.f64 fd158, fd60, 0d3FD207E7FD768DBF, fd154;
fma.rn.f64 fd159, fd58, 0dBFEEB42A9BCD5057, fd155;
fma.rn.f64 fd160, fd59, 0d3FD207E7FD768DBF, fd156;
fma.rn.f64 fd161, fd61, 0d3FDA9628D9C712B6, fd157;
fma.rn.f64 fd162, fd64, 0dBFED1BB48EEE2C13, fd158;
fma.rn.f64 fd163, fd62, 0d3FDA9628D9C712B6, fd159;
fma.rn.f64 fd164, fd63, 0dBFED1BB48EEE2C13, fd160;
sub.f64 fd165, fd161, fd162;
add.f64 fd166, fd164, fd163;
add.f64 fd167, fd162, fd161;
sub.f64 fd168, fd163, fd164;
fma.rn.f64 fd169, fd45, 0dBFEEB42A9BCD5057, %25;
fma.rn.f64 fd170, fd48, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd171, fd46, 0dBFEEB42A9BCD5057, %26;
fma.rn.f64 fd172, fd47, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd173, fd49, 0d3FEAEB8C8764F0BA, fd169;
fma.rn.f64 fd174, fd52, 0dBFE14CEDF8BB580B, fd170;
fma.rn.f64 fd175, fd50, 0d3FEAEB8C8764F0BA, fd171;
fma.rn.f64 fd176, fd51, 0dBFE14CEDF8BB580B, fd172;
fma.rn.f64 fd177, fd53, 0dBFE4F49E7F775887, fd173;
fma.rn.f64 fd178, fd56, 0d3FE82F19BB3A28A1, fd174;
fma.rn.f64 fd179, fd54, 0dBFE4F49E7F775887, fd175;
fma.rn.f64 fd180, fd55, 0d3FE82F19BB3A28A1, fd176;
fma.rn.f64 fd181, fd57, 0d3FDA9628D9C712B6, fd177;
fma.rn.f64 fd182, fd60, 0dBFED1BB48EEE2C13, fd178;
fma.rn.f64 fd183, fd58, 0d3FDA9628D9C712B6, fd179;
fma.rn.f64 fd184, fd59, 0dBFED1BB48EEE2C13, fd180;
fma.rn.f64 fd185, fd61, 0dBFC2375F640F44DB, fd181;
fma.rn.f64 fd186, fd64, 0d3FEFAC9E043842EF, fd182;
fma.rn.f64 fd187, fd62, 0dBFC2375F640F44DB, fd183;
fma.rn.f64 fd188, fd63, 0d3FEFAC9E043842EF, fd184;
sub.f64 fd189, fd185, fd186;
add.f64 fd190, fd188, fd187;
add.f64 fd191, fd186, fd185;
sub.f64 fd192, fd187, fd188;
mul.wide.u32 rd2, r4, 248469183;
shr.u64 rd3, rd2, 32;
cvt.u32.u64 r5, rd3;
sub.s32 r6, r4, r5;
shr.u32 r7, r6, 1;
add.s32 r8, r7, r5;
shr.u32 r9, r8, 6;
mul.lo.s32 r10, r9, 121;
sub.s32 r11, r4, r10;
mad.lo.s32 r12, r9, 21296, r3;
mul.wide.u32 rd4, r11, 16;
mov.u64 rd5, %23;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd193, fd194}, [rd6];
mul.f64 fd197, fd94, fd194;
mul.f64 fd198, fd93, fd194;
mul.f64 fd199, fd193, fd94;
mul.f64 fd200, fd193, fd193;
mul.f64 fd201, fd194, fd194;
sub.f64 fd202, fd200, fd201;
mul.f64 fd203, fd194, fd193;
fma.rn.f64 fd204, fd194, fd193, fd203;
mul.f64 fd205, fd118, fd204;
mul.f64 fd206, fd117, fd204;
mul.f64 fd207, fd202, fd118;
mul.f64 fd208, fd193, fd202;
mul.f64 fd209, fd194, fd204;
sub.f64 fd210, fd208, fd209;
mul.f64 fd211, fd193, fd204;
fma.rn.f64 fd212, fd194, fd202, fd211;
mul.f64 fd213, fd142, fd212;
mul.f64 fd214, fd141, fd212;
mul.f64 fd215, fd210, fd142;
mul.f64 fd216, fd193, fd210;
mul.f64 fd217, fd194, fd212;
sub.f64 fd218, fd216, fd217;
mul.f64 fd219, fd193, fd212;
fma.rn.f64 fd220, fd194, fd210, fd219;
mul.f64 fd221, fd166, fd220;
mul.f64 fd222, fd165, fd220;
mul.f64 fd223, fd218, fd166;
mul.f64 fd224, fd193, fd218;
mul.f64 fd225, fd194, fd220;
sub.f64 fd226, fd224, fd225;
mul.f64 fd227, fd193, fd220;
fma.rn.f64 fd228, fd194, fd218, fd227;
mul.f64 fd229, fd190, fd228;
mul.f64 fd230, fd189, fd228;
mul.f64 fd231, fd226, fd190;
ld.global.v2.f64 {fd232, fd233}, [rd6+1936];
mul.f64 fd236, fd192, fd233;
mul.f64 fd237, fd191, fd233;
mul.f64 fd238, fd232, fd192;
mul.f64 fd239, fd193, fd232;
mul.f64 fd240, fd194, fd233;
sub.f64 fd241, fd239, fd240;
mul.f64 fd242, fd193, fd233;
fma.rn.f64 fd243, fd194, fd232, fd242;
mul.f64 fd244, fd168, fd243;
mul.f64 fd245, fd167, fd243;
mul.f64 fd246, fd241, fd168;
mul.f64 fd247, fd193, fd241;
mul.f64 fd248, fd194, fd243;
sub.f64 fd249, fd247, fd248;
mul.f64 fd250, fd193, fd243;
fma.rn.f64 fd251, fd194, fd241, fd250;
mul.f64 fd252, fd144, fd251;
mul.f64 fd253, fd143, fd251;
mul.f64 fd254, fd249, fd144;
mul.f64 fd255, fd193, fd249;
mul.f64 fd256, fd194, fd251;
sub.f64 fd257, fd255, fd256;
mul.f64 fd258, fd193, fd251;
fma.rn.f64 fd259, fd194, fd249, fd258;
mul.f64 fd260, fd120, fd259;
mul.f64 fd261, fd119, fd259;
mul.f64 fd262, fd257, fd120;
mul.f64 fd263, fd193, fd257;
mul.f64 fd264, fd194, fd259;
sub.f64 fd265, fd263, fd264;
mul.f64 fd266, fd193, fd259;
fma.rn.f64 fd267, fd194, fd257, fd266;
mul.f64 fd268, fd96, fd267;
mul.f64 fd269, fd95, fd267;
mul.f64 fd270, fd265, fd96;
barrier.sync 0;
mad.lo.s32 r13, r11, 176, r12;
add.f64 fd271, fd72, fd62;
add.f64 fd272, fd71, fd61;
st.shared.v2.f64 [r13], {fd272, fd271};
fma.rn.f64 fd273, fd193, fd93, fd197;
sub.f64 fd274, fd199, fd198;
st.shared.v2.f64 [r13+16], {fd273, fd274};
fma.rn.f64 fd275, fd202, fd117, fd205;
sub.f64 fd276, fd207, fd206;
st.shared.v2.f64 [r13+32], {fd275, fd276};
sub.f64 fd277, fd215, fd214;
fma.rn.f64 fd278, fd210, fd141, fd213;
st.shared.v2.f64 [r13+48], {fd278, fd277};
fma.rn.f64 fd279, fd218, fd165, fd221;
sub.f64 fd280, fd223, fd222;
st.shared.v2.f64 [r13+64], {fd279, fd280};
fma.rn.f64 fd281, fd226, fd189, fd229;
sub.f64 fd282, fd231, fd230;
st.shared.v2.f64 [r13+80], {fd281, fd282};
fma.rn.f64 fd283, fd232, fd191, fd236;
sub.f64 fd284, fd238, fd237;
st.shared.v2.f64 [r13+96], {fd283, fd284};
fma.rn.f64 fd285, fd241, fd167, fd244;
sub.f64 fd286, fd246, fd245;
st.shared.v2.f64 [r13+112], {fd285, fd286};
sub.f64 fd287, fd254, fd253;
fma.rn.f64 fd288, fd249, fd143, fd252;
st.shared.v2.f64 [r13+128], {fd288, fd287};
fma.rn.f64 fd289, fd257, fd119, fd260;
sub.f64 fd290, fd262, fd261;
st.shared.v2.f64 [r13+144], {fd289, fd290};
fma.rn.f64 fd291, fd265, fd95, fd268;
sub.f64 fd292, fd270, fd269;
st.shared.v2.f64 [r13+160], {fd291, fd292};
barrier.sync 0;
mad.lo.s32 r14, r11, -160, r13;
ld.shared.v2.f64 {fd293, fd294}, [r14];
ld.shared.v2.f64 {fd297, fd298}, [r14+1936];
ld.shared.v2.f64 {fd301, fd302}, [r14+3872];
ld.shared.v2.f64 {fd305, fd306}, [r14+5808];
ld.shared.v2.f64 {fd309, fd310}, [r14+7744];
ld.shared.v2.f64 {fd313, fd314}, [r14+9680];
ld.shared.v2.f64 {fd317, fd318}, [r14+11616];
ld.shared.v2.f64 {fd321, fd322}, [r14+13552];
ld.shared.v2.f64 {fd325, fd326}, [r14+15488];
ld.shared.v2.f64 {fd329, fd330}, [r14+17424];
ld.shared.v2.f64 {fd333, fd334}, [r14+19360];
add.f64 fd337, fd297, fd333;
add.f64 fd338, fd298, fd334;
sub.f64 fd339, fd297, fd333;
sub.f64 fd340, fd298, fd334;
add.f64 fd341, fd301, fd329;
add.f64 fd342, fd302, fd330;
sub.f64 fd343, fd301, fd329;
sub.f64 fd344, fd302, fd330;
add.f64 fd345, fd305, fd325;
add.f64 fd346, fd306, fd326;
sub.f64 fd347, fd305, fd325;
sub.f64 fd348, fd306, fd326;
add.f64 fd349, fd309, fd321;
add.f64 fd350, fd310, fd322;
sub.f64 fd351, fd309, fd321;
sub.f64 fd352, fd310, fd322;
add.f64 fd353, fd313, fd317;
add.f64 fd354, fd314, fd318;
sub.f64 fd355, fd313, fd317;
sub.f64 fd356, fd314, fd318;
add.f64 fd357, fd293, fd337;
add.f64 fd358, fd294, fd338;
add.f64 fd359, fd357, fd341;
add.f64 fd360, fd358, fd342;
add.f64 fd361, fd359, fd345;
add.f64 fd362, fd360, fd346;
add.f64 fd363, fd361, fd349;
add.f64 fd364, fd362, fd350;
fma.rn.f64 fd365, fd337, 0d3FEAEB8C8764F0BA, fd293;
fma.rn.f64 fd366, fd340, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd367, fd338, 0d3FEAEB8C8764F0BA, fd294;
fma.rn.f64 fd368, fd339, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd369, fd341, 0d3FDA9628D9C712B6, fd365;
fma.rn.f64 fd370, fd344, 0d3FED1BB48EEE2C13, fd366;
fma.rn.f64 fd371, fd342, 0d3FDA9628D9C712B6, fd367;
fma.rn.f64 fd372, fd343, 0d3FED1BB48EEE2C13, fd368;
fma.rn.f64 fd373, fd345, 0dBFC2375F640F44DB, fd369;
fma.rn.f64 fd374, fd348, 0d3FEFAC9E043842EF, fd370;
fma.rn.f64 fd375, fd346, 0dBFC2375F640F44DB, fd371;
fma.rn.f64 fd376, fd347, 0d3FEFAC9E043842EF, fd372;
fma.rn.f64 fd377, fd349, 0dBFE4F49E7F775887, fd373;
fma.rn.f64 fd378, fd352, 0d3FE82F19BB3A28A1, fd374;
fma.rn.f64 fd379, fd350, 0dBFE4F49E7F775887, fd375;
fma.rn.f64 fd380, fd351, 0d3FE82F19BB3A28A1, fd376;
fma.rn.f64 fd381, fd353, 0dBFEEB42A9BCD5057, fd377;
fma.rn.f64 fd382, fd356, 0d3FD207E7FD768DBF, fd378;
fma.rn.f64 fd383, fd354, 0dBFEEB42A9BCD5057, fd379;
fma.rn.f64 fd384, fd355, 0d3FD207E7FD768DBF, fd380;
sub.f64 fd385, fd381, fd382;
add.f64 fd386, fd384, fd383;
add.f64 fd387, fd382, fd381;
sub.f64 fd388, fd383, fd384;
fma.rn.f64 fd389, fd337, 0d3FDA9628D9C712B6, fd293;
fma.rn.f64 fd390, fd340, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd391, fd338, 0d3FDA9628D9C712B6, fd294;
fma.rn.f64 fd392, fd339, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd393, fd341, 0dBFE4F49E7F775887, fd389;
fma.rn.f64 fd394, fd344, 0d3FE82F19BB3A28A1, fd390;
fma.rn.f64 fd395, fd342, 0dBFE4F49E7F775887, fd391;
fma.rn.f64 fd396, fd343, 0d3FE82F19BB3A28A1, fd392;
fma.rn.f64 fd397, fd345, 0dBFEEB42A9BCD5057, fd393;
fma.rn.f64 fd398, fd348, 0dBFD207E7FD768DBF, fd394;
fma.rn.f64 fd399, fd346, 0dBFEEB42A9BCD5057, fd395;
fma.rn.f64 fd400, fd347, 0dBFD207E7FD768DBF, fd396;
fma.rn.f64 fd401, fd349, 0dBFC2375F640F44DB, fd397;
fma.rn.f64 fd402, fd352, 0dBFEFAC9E043842EF, fd398;
fma.rn.f64 fd403, fd350, 0dBFC2375F640F44DB, fd399;
fma.rn.f64 fd404, fd351, 0dBFEFAC9E043842EF, fd400;
fma.rn.f64 fd405, fd353, 0d3FEAEB8C8764F0BA, fd401;
fma.rn.f64 fd406, fd356, 0dBFE14CEDF8BB580B, fd402;
fma.rn.f64 fd407, fd354, 0d3FEAEB8C8764F0BA, fd403;
fma.rn.f64 fd408, fd355, 0dBFE14CEDF8BB580B, fd404;
sub.f64 fd409, fd405, fd406;
add.f64 fd410, fd408, fd407;
add.f64 fd411, fd406, fd405;
sub.f64 fd412, fd407, fd408;
fma.rn.f64 fd413, fd337, 0dBFC2375F640F44DB, fd293;
fma.rn.f64 fd414, fd340, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd415, fd338, 0dBFC2375F640F44DB, fd294;
fma.rn.f64 fd416, fd339, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd417, fd341, 0dBFEEB42A9BCD5057, fd413;
fma.rn.f64 fd418, fd344, 0dBFD207E7FD768DBF, fd414;
fma.rn.f64 fd419, fd342, 0dBFEEB42A9BCD5057, fd415;
fma.rn.f64 fd420, fd343, 0dBFD207E7FD768DBF, fd416;
fma.rn.f64 fd421, fd345, 0d3FDA9628D9C712B6, fd417;
fma.rn.f64 fd422, fd348, 0dBFED1BB48EEE2C13, fd418;
fma.rn.f64 fd423, fd346, 0d3FDA9628D9C712B6, fd419;
fma.rn.f64 fd424, fd347, 0dBFED1BB48EEE2C13, fd420;
fma.rn.f64 fd425, fd349, 0d3FEAEB8C8764F0BA, fd421;
fma.rn.f64 fd426, fd352, 0d3FE14CEDF8BB580B, fd422;
fma.rn.f64 fd427, fd350, 0d3FEAEB8C8764F0BA, fd423;
fma.rn.f64 fd428, fd351, 0d3FE14CEDF8BB580B, fd424;
fma.rn.f64 fd429, fd353, 0dBFE4F49E7F775887, fd425;
fma.rn.f64 fd430, fd356, 0d3FE82F19BB3A28A1, fd426;
fma.rn.f64 fd431, fd354, 0dBFE4F49E7F775887, fd427;
fma.rn.f64 fd432, fd355, 0d3FE82F19BB3A28A1, fd428;
sub.f64 fd433, fd429, fd430;
add.f64 fd434, fd432, fd431;
add.f64 fd435, fd430, fd429;
sub.f64 fd436, fd431, fd432;
fma.rn.f64 fd437, fd337, 0dBFE4F49E7F775887, fd293;
fma.rn.f64 fd438, fd340, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd439, fd338, 0dBFE4F49E7F775887, fd294;
fma.rn.f64 fd440, fd339, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd441, fd341, 0dBFC2375F640F44DB, fd437;
fma.rn.f64 fd442, fd344, 0dBFEFAC9E043842EF, fd438;
fma.rn.f64 fd443, fd342, 0dBFC2375F640F44DB, fd439;
fma.rn.f64 fd444, fd343, 0dBFEFAC9E043842EF, fd440;
fma.rn.f64 fd445, fd345, 0d3FEAEB8C8764F0BA, fd441;
fma.rn.f64 fd446, fd348, 0d3FE14CEDF8BB580B, fd442;
fma.rn.f64 fd447, fd346, 0d3FEAEB8C8764F0BA, fd443;
fma.rn.f64 fd448, fd347, 0d3FE14CEDF8BB580B, fd444;
fma.rn.f64 fd449, fd349, 0dBFEEB42A9BCD5057, fd445;
fma.rn.f64 fd450, fd352, 0d3FD207E7FD768DBF, fd446;
fma.rn.f64 fd451, fd350, 0dBFEEB42A9BCD5057, fd447;
fma.rn.f64 fd452, fd351, 0d3FD207E7FD768DBF, fd448;
fma.rn.f64 fd453, fd353, 0d3FDA9628D9C712B6, fd449;
fma.rn.f64 fd454, fd356, 0dBFED1BB48EEE2C13, fd450;
fma.rn.f64 fd455, fd354, 0d3FDA9628D9C712B6, fd451;
fma.rn.f64 fd456, fd355, 0dBFED1BB48EEE2C13, fd452;
sub.f64 fd457, fd453, fd454;
add.f64 fd458, fd456, fd455;
add.f64 fd459, fd454, fd453;
sub.f64 fd460, fd455, fd456;
fma.rn.f64 fd461, fd337, 0dBFEEB42A9BCD5057, fd293;
fma.rn.f64 fd462, fd340, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd463, fd338, 0dBFEEB42A9BCD5057, fd294;
fma.rn.f64 fd464, fd339, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd465, fd341, 0d3FEAEB8C8764F0BA, fd461;
fma.rn.f64 fd466, fd344, 0dBFE14CEDF8BB580B, fd462;
fma.rn.f64 fd467, fd342, 0d3FEAEB8C8764F0BA, fd463;
fma.rn.f64 fd468, fd343, 0dBFE14CEDF8BB580B, fd464;
fma.rn.f64 fd469, fd345, 0dBFE4F49E7F775887, fd465;
fma.rn.f64 fd470, fd348, 0d3FE82F19BB3A28A1, fd466;
fma.rn.f64 fd471, fd346, 0dBFE4F49E7F775887, fd467;
fma.rn.f64 fd472, fd347, 0d3FE82F19BB3A28A1, fd468;
fma.rn.f64 fd473, fd349, 0d3FDA9628D9C712B6, fd469;
fma.rn.f64 fd474, fd352, 0dBFED1BB48EEE2C13, fd470;
fma.rn.f64 fd475, fd350, 0d3FDA9628D9C712B6, fd471;
fma.rn.f64 fd476, fd351, 0dBFED1BB48EEE2C13, fd472;
fma.rn.f64 fd477, fd353, 0dBFC2375F640F44DB, fd473;
fma.rn.f64 fd478, fd356, 0d3FEFAC9E043842EF, fd474;
fma.rn.f64 fd479, fd354, 0dBFC2375F640F44DB, fd475;
fma.rn.f64 fd480, fd355, 0d3FEFAC9E043842EF, fd476;
sub.f64 fd481, fd477, fd478;
add.f64 fd482, fd480, fd479;
add.f64 fd483, fd478, fd477;
sub.f64 fd484, fd479, fd480;
mul.wide.u32 rd7, r11, -1171354717;
shr.u64 rd8, rd7, 35;
cvt.u32.u64 r15, rd8;
mul.lo.s32 r16, r15, 11;
sub.s32 r17, r11, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %24;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd485, fd486}, [rd11];
mul.f64 fd489, fd386, fd486;
mul.f64 fd490, fd385, fd486;
mul.f64 fd491, fd485, fd386;
mul.f64 fd492, fd485, fd485;
mul.f64 fd493, fd486, fd486;
sub.f64 fd494, fd492, fd493;
mul.f64 fd495, fd486, fd485;
fma.rn.f64 fd496, fd486, fd485, fd495;
mul.f64 fd497, fd410, fd496;
mul.f64 fd498, fd409, fd496;
mul.f64 fd499, fd494, fd410;
mul.f64 fd500, fd485, fd494;
mul.f64 fd501, fd486, fd496;
sub.f64 fd502, fd500, fd501;
mul.f64 fd503, fd485, fd496;
fma.rn.f64 fd504, fd486, fd494, fd503;
mul.f64 fd505, fd434, fd504;
mul.f64 fd506, fd433, fd504;
mul.f64 fd507, fd502, fd434;
mul.f64 fd508, fd485, fd502;
mul.f64 fd509, fd486, fd504;
sub.f64 fd510, fd508, fd509;
mul.f64 fd511, fd485, fd504;
fma.rn.f64 fd512, fd486, fd502, fd511;
mul.f64 fd513, fd458, fd512;
mul.f64 fd514, fd457, fd512;
mul.f64 fd515, fd510, fd458;
mul.f64 fd516, fd485, fd510;
mul.f64 fd517, fd486, fd512;
sub.f64 fd518, fd516, fd517;
mul.f64 fd519, fd485, fd512;
fma.rn.f64 fd520, fd486, fd510, fd519;
mul.f64 fd521, fd482, fd520;
mul.f64 fd522, fd481, fd520;
mul.f64 fd523, fd518, fd482;
ld.global.v2.f64 {fd524, fd525}, [rd11+176];
mul.f64 fd528, fd484, fd525;
mul.f64 fd529, fd483, fd525;
mul.f64 fd530, fd524, fd484;
mul.f64 fd531, fd485, fd524;
mul.f64 fd532, fd486, fd525;
sub.f64 fd533, fd531, fd532;
mul.f64 fd534, fd485, fd525;
fma.rn.f64 fd535, fd486, fd524, fd534;
mul.f64 fd536, fd460, fd535;
mul.f64 fd537, fd459, fd535;
mul.f64 fd538, fd533, fd460;
mul.f64 fd539, fd485, fd533;
mul.f64 fd540, fd486, fd535;
sub.f64 fd541, fd539, fd540;
mul.f64 fd542, fd485, fd535;
fma.rn.f64 fd543, fd486, fd533, fd542;
mul.f64 fd544, fd436, fd543;
mul.f64 fd545, fd435, fd543;
mul.f64 fd546, fd541, fd436;
mul.f64 fd547, fd485, fd541;
mul.f64 fd548, fd486, fd543;
sub.f64 fd549, fd547, fd548;
mul.f64 fd550, fd485, fd543;
fma.rn.f64 fd551, fd486, fd541, fd550;
mul.f64 fd552, fd412, fd551;
mul.f64 fd553, fd411, fd551;
mul.f64 fd554, fd549, fd412;
mul.f64 fd555, fd485, fd549;
mul.f64 fd556, fd486, fd551;
sub.f64 fd557, fd555, fd556;
mul.f64 fd558, fd485, fd551;
fma.rn.f64 fd559, fd486, fd549, fd558;
mul.f64 fd560, fd388, fd559;
mul.f64 fd561, fd387, fd559;
mul.f64 fd562, fd557, fd388;
shl.b32 r18, r17, 4;
add.s32 r19, r12, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 1936, r19;
add.f64 fd563, fd364, fd354;
add.f64 fd564, fd363, fd353;
st.shared.v2.f64 [r20], {fd564, fd563};
fma.rn.f64 fd565, fd485, fd385, fd489;
sub.f64 fd566, fd491, fd490;
st.shared.v2.f64 [r20+176], {fd565, fd566};
fma.rn.f64 fd567, fd494, fd409, fd497;
sub.f64 fd568, fd499, fd498;
st.shared.v2.f64 [r20+352], {fd567, fd568};
fma.rn.f64 fd569, fd502, fd433, fd505;
sub.f64 fd570, fd507, fd506;
st.shared.v2.f64 [r20+528], {fd569, fd570};
fma.rn.f64 fd571, fd510, fd457, fd513;
sub.f64 fd572, fd515, fd514;
st.shared.v2.f64 [r20+704], {fd571, fd572};
sub.f64 fd573, fd523, fd522;
fma.rn.f64 fd574, fd518, fd481, fd521;
st.shared.v2.f64 [r20+880], {fd574, fd573};
fma.rn.f64 fd575, fd524, fd483, fd528;
sub.f64 fd576, fd530, fd529;
st.shared.v2.f64 [r20+1056], {fd575, fd576};
fma.rn.f64 fd577, fd533, fd459, fd536;
sub.f64 fd578, fd538, fd537;
st.shared.v2.f64 [r20+1232], {fd577, fd578};
fma.rn.f64 fd579, fd541, fd435, fd544;
sub.f64 fd580, fd546, fd545;
st.shared.v2.f64 [r20+1408], {fd579, fd580};
fma.rn.f64 fd581, fd549, fd411, fd552;
sub.f64 fd582, fd554, fd553;
st.shared.v2.f64 [r20+1584], {fd581, fd582};
sub.f64 fd583, fd562, fd561;
fma.rn.f64 fd584, fd557, fd387, fd560;
st.shared.v2.f64 [r20+1760], {fd584, fd583};
barrier.sync 0;
ld.shared.v2.f64 {fd585, fd586}, [r14];
ld.shared.v2.f64 {fd589, fd590}, [r14+1936];
ld.shared.v2.f64 {fd593, fd594}, [r14+3872];
ld.shared.v2.f64 {fd597, fd598}, [r14+5808];
ld.shared.v2.f64 {fd601, fd602}, [r14+7744];
ld.shared.v2.f64 {fd605, fd606}, [r14+9680];
ld.shared.v2.f64 {fd609, fd610}, [r14+11616];
ld.shared.v2.f64 {fd613, fd614}, [r14+13552];
ld.shared.v2.f64 {fd617, fd618}, [r14+15488];
ld.shared.v2.f64 {fd621, fd622}, [r14+17424];
ld.shared.v2.f64 {fd625, fd626}, [r14+19360];
add.f64 fd629, fd589, fd625;
add.f64 fd630, fd590, fd626;
sub.f64 fd631, fd589, fd625;
sub.f64 fd632, fd590, fd626;
add.f64 fd633, fd593, fd621;
add.f64 fd634, fd594, fd622;
sub.f64 fd635, fd593, fd621;
sub.f64 fd636, fd594, fd622;
add.f64 fd637, fd597, fd617;
add.f64 fd638, fd598, fd618;
sub.f64 fd639, fd597, fd617;
sub.f64 fd640, fd598, fd618;
add.f64 fd641, fd601, fd613;
add.f64 fd642, fd602, fd614;
sub.f64 fd643, fd601, fd613;
sub.f64 fd644, fd602, fd614;
add.f64 fd645, fd605, fd609;
add.f64 fd646, fd606, fd610;
sub.f64 fd647, fd605, fd609;
sub.f64 fd648, fd606, fd610;
add.f64 fd649, fd585, fd629;
add.f64 fd650, fd586, fd630;
add.f64 fd651, fd649, fd633;
add.f64 fd652, fd650, fd634;
add.f64 fd653, fd651, fd637;
add.f64 fd654, fd652, fd638;
add.f64 fd655, fd653, fd641;
add.f64 fd656, fd654, fd642;
fma.rn.f64 fd657, fd629, 0d3FEAEB8C8764F0BA, fd585;
fma.rn.f64 fd658, fd632, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd659, fd630, 0d3FEAEB8C8764F0BA, fd586;
fma.rn.f64 fd660, fd631, 0d3FE14CEDF8BB580B, 0d0000000000000000;
fma.rn.f64 fd661, fd633, 0d3FDA9628D9C712B6, fd657;
fma.rn.f64 fd662, fd636, 0d3FED1BB48EEE2C13, fd658;
fma.rn.f64 fd663, fd634, 0d3FDA9628D9C712B6, fd659;
fma.rn.f64 fd664, fd635, 0d3FED1BB48EEE2C13, fd660;
fma.rn.f64 fd665, fd637, 0dBFC2375F640F44DB, fd661;
fma.rn.f64 fd666, fd640, 0d3FEFAC9E043842EF, fd662;
fma.rn.f64 fd667, fd638, 0dBFC2375F640F44DB, fd663;
fma.rn.f64 fd668, fd639, 0d3FEFAC9E043842EF, fd664;
fma.rn.f64 fd669, fd641, 0dBFE4F49E7F775887, fd665;
fma.rn.f64 fd670, fd644, 0d3FE82F19BB3A28A1, fd666;
fma.rn.f64 fd671, fd642, 0dBFE4F49E7F775887, fd667;
fma.rn.f64 fd672, fd643, 0d3FE82F19BB3A28A1, fd668;
fma.rn.f64 fd673, fd645, 0dBFEEB42A9BCD5057, fd669;
fma.rn.f64 fd674, fd648, 0d3FD207E7FD768DBF, fd670;
fma.rn.f64 fd675, fd646, 0dBFEEB42A9BCD5057, fd671;
fma.rn.f64 fd676, fd647, 0d3FD207E7FD768DBF, fd672;
fma.rn.f64 fd677, fd629, 0d3FDA9628D9C712B6, fd585;
fma.rn.f64 fd678, fd632, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd679, fd630, 0d3FDA9628D9C712B6, fd586;
fma.rn.f64 fd680, fd631, 0d3FED1BB48EEE2C13, 0d0000000000000000;
fma.rn.f64 fd681, fd633, 0dBFE4F49E7F775887, fd677;
fma.rn.f64 fd682, fd636, 0d3FE82F19BB3A28A1, fd678;
fma.rn.f64 fd683, fd634, 0dBFE4F49E7F775887, fd679;
fma.rn.f64 fd684, fd635, 0d3FE82F19BB3A28A1, fd680;
fma.rn.f64 fd685, fd637, 0dBFEEB42A9BCD5057, fd681;
fma.rn.f64 fd686, fd640, 0dBFD207E7FD768DBF, fd682;
fma.rn.f64 fd687, fd638, 0dBFEEB42A9BCD5057, fd683;
fma.rn.f64 fd688, fd639, 0dBFD207E7FD768DBF, fd684;
fma.rn.f64 fd689, fd641, 0dBFC2375F640F44DB, fd685;
fma.rn.f64 fd690, fd644, 0dBFEFAC9E043842EF, fd686;
fma.rn.f64 fd691, fd642, 0dBFC2375F640F44DB, fd687;
fma.rn.f64 fd692, fd643, 0dBFEFAC9E043842EF, fd688;
fma.rn.f64 fd693, fd645, 0d3FEAEB8C8764F0BA, fd689;
fma.rn.f64 fd694, fd648, 0dBFE14CEDF8BB580B, fd690;
fma.rn.f64 fd695, fd646, 0d3FEAEB8C8764F0BA, fd691;
fma.rn.f64 fd696, fd647, 0dBFE14CEDF8BB580B, fd692;
fma.rn.f64 fd697, fd629, 0dBFC2375F640F44DB, fd585;
fma.rn.f64 fd698, fd632, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd699, fd630, 0dBFC2375F640F44DB, fd586;
fma.rn.f64 fd700, fd631, 0d3FEFAC9E043842EF, 0d0000000000000000;
fma.rn.f64 fd701, fd633, 0dBFEEB42A9BCD5057, fd697;
fma.rn.f64 fd702, fd636, 0dBFD207E7FD768DBF, fd698;
fma.rn.f64 fd703, fd634, 0dBFEEB42A9BCD5057, fd699;
fma.rn.f64 fd704, fd635, 0dBFD207E7FD768DBF, fd700;
fma.rn.f64 fd705, fd637, 0d3FDA9628D9C712B6, fd701;
fma.rn.f64 fd706, fd640, 0dBFED1BB48EEE2C13, fd702;
fma.rn.f64 fd707, fd638, 0d3FDA9628D9C712B6, fd703;
fma.rn.f64 fd708, fd639, 0dBFED1BB48EEE2C13, fd704;
fma.rn.f64 fd709, fd641, 0d3FEAEB8C8764F0BA, fd705;
fma.rn.f64 fd710, fd644, 0d3FE14CEDF8BB580B, fd706;
fma.rn.f64 fd711, fd642, 0d3FEAEB8C8764F0BA, fd707;
fma.rn.f64 fd712, fd643, 0d3FE14CEDF8BB580B, fd708;
fma.rn.f64 fd713, fd645, 0dBFE4F49E7F775887, fd709;
fma.rn.f64 fd714, fd648, 0d3FE82F19BB3A28A1, fd710;
fma.rn.f64 fd715, fd646, 0dBFE4F49E7F775887, fd711;
fma.rn.f64 fd716, fd647, 0d3FE82F19BB3A28A1, fd712;
fma.rn.f64 fd717, fd629, 0dBFE4F49E7F775887, fd585;
fma.rn.f64 fd718, fd632, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd719, fd630, 0dBFE4F49E7F775887, fd586;
fma.rn.f64 fd720, fd631, 0d3FE82F19BB3A28A1, 0d0000000000000000;
fma.rn.f64 fd721, fd633, 0dBFC2375F640F44DB, fd717;
fma.rn.f64 fd722, fd636, 0dBFEFAC9E043842EF, fd718;
fma.rn.f64 fd723, fd634, 0dBFC2375F640F44DB, fd719;
fma.rn.f64 fd724, fd635, 0dBFEFAC9E043842EF, fd720;
fma.rn.f64 fd725, fd637, 0d3FEAEB8C8764F0BA, fd721;
fma.rn.f64 fd726, fd640, 0d3FE14CEDF8BB580B, fd722;
fma.rn.f64 fd727, fd638, 0d3FEAEB8C8764F0BA, fd723;
fma.rn.f64 fd728, fd639, 0d3FE14CEDF8BB580B, fd724;
fma.rn.f64 fd729, fd641, 0dBFEEB42A9BCD5057, fd725;
fma.rn.f64 fd730, fd644, 0d3FD207E7FD768DBF, fd726;
fma.rn.f64 fd731, fd642, 0dBFEEB42A9BCD5057, fd727;
fma.rn.f64 fd732, fd643, 0d3FD207E7FD768DBF, fd728;
fma.rn.f64 fd733, fd645, 0d3FDA9628D9C712B6, fd729;
fma.rn.f64 fd734, fd648, 0dBFED1BB48EEE2C13, fd730;
fma.rn.f64 fd735, fd646, 0d3FDA9628D9C712B6, fd731;
fma.rn.f64 fd736, fd647, 0dBFED1BB48EEE2C13, fd732;
fma.rn.f64 fd737, fd629, 0dBFEEB42A9BCD5057, fd585;
fma.rn.f64 fd738, fd632, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd739, fd630, 0dBFEEB42A9BCD5057, fd586;
fma.rn.f64 fd740, fd631, 0d3FD207E7FD768DBF, 0d0000000000000000;
fma.rn.f64 fd741, fd633, 0d3FEAEB8C8764F0BA, fd737;
fma.rn.f64 fd742, fd636, 0dBFE14CEDF8BB580B, fd738;
fma.rn.f64 fd743, fd634, 0d3FEAEB8C8764F0BA, fd739;
fma.rn.f64 fd744, fd635, 0dBFE14CEDF8BB580B, fd740;
fma.rn.f64 fd745, fd637, 0dBFE4F49E7F775887, fd741;
fma.rn.f64 fd746, fd640, 0d3FE82F19BB3A28A1, fd742;
fma.rn.f64 fd747, fd638, 0dBFE4F49E7F775887, fd743;
fma.rn.f64 fd748, fd639, 0d3FE82F19BB3A28A1, fd744;
fma.rn.f64 fd749, fd641, 0d3FDA9628D9C712B6, fd745;
fma.rn.f64 fd750, fd644, 0dBFED1BB48EEE2C13, fd746;
fma.rn.f64 fd751, fd642, 0d3FDA9628D9C712B6, fd747;
fma.rn.f64 fd752, fd643, 0dBFED1BB48EEE2C13, fd748;
fma.rn.f64 fd753, fd645, 0dBFC2375F640F44DB, fd749;
fma.rn.f64 fd754, fd648, 0d3FEFAC9E043842EF, fd750;
fma.rn.f64 fd755, fd646, 0dBFC2375F640F44DB, fd751;
fma.rn.f64 fd756, fd647, 0d3FEFAC9E043842EF, fd752;
add.f64 %1, fd656, fd646;
add.f64 %0, fd655, fd645;
add.f64 %3, fd676, fd675;
sub.f64 %2, fd673, fd674;
add.f64 %5, fd696, fd695;
sub.f64 %4, fd693, fd694;
add.f64 %7, fd716, fd715;
sub.f64 %6, fd713, fd714;
add.f64 %9, fd736, fd735;
sub.f64 %8, fd733, fd734;
add.f64 %11, fd756, fd755;
sub.f64 %10, fd753, fd754;
sub.f64 %13, fd755, fd756;
add.f64 %12, fd754, fd753;
sub.f64 %15, fd735, fd736;
add.f64 %14, fd734, fd733;
sub.f64 %17, fd715, fd716;
add.f64 %16, fd714, fd713;
sub.f64 %19, fd695, fd696;
add.f64 %18, fd694, fd693;
sub.f64 %21, fd675, fd676;
add.f64 %20, fd674, fd673;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y): "r"(smem), "l"(lut_dp_11_1331), "l"(lut_dp_11_121), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y));
};


#endif
