#ifndef CUFFTDX_FFT_26_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_26_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<586, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .f64 fd<734>;
.reg .b64 rd<7>;
add.f64 fd105, %57, %101;
sub.f64 fd107, %57, %101;
add.f64 fd730, %105, %102;
sub.f64 fd108, %105, %102;
add.f64 fd109, %61, %97;
sub.f64 fd111, %61, %97;
add.f64 fd727, %106, %107;
sub.f64 fd112, %106, %107;
add.f64 fd113, %65, %93;
sub.f64 fd115, %65, %93;
add.f64 fd725, %66, %108;
sub.f64 fd116, %66, %108;
add.f64 fd117, %69, %89;
sub.f64 fd119, %69, %89;
add.f64 fd723, %109, %90;
sub.f64 fd120, %109, %90;
add.f64 fd121, %73, %85;
sub.f64 fd123, %73, %85;
add.f64 fd720, %110, %111;
sub.f64 fd124, %110, %111;
add.f64 fd125, %77, %81;
sub.f64 fd127, %77, %81;
add.f64 fd718, %78, %112;
sub.f64 fd128, %78, %112;
add.f64 fd129, %53, fd105;
add.f64 fd131, fd129, fd109;
add.f64 fd717, %54, fd730;
add.f64 fd132, fd717, fd727;
add.f64 fd133, fd131, fd113;
add.f64 fd134, fd132, fd725;
add.f64 fd135, fd133, fd117;
add.f64 fd136, fd134, fd723;
add.f64 fd137, fd135, fd121;
add.f64 fd138, fd136, fd720;
add.f64 fd139, fd137, fd125;
add.f64 fd140, fd138, fd718;
fma.rn.f64 fd141, fd105, 0d3FEC55A7E00740E9, %53;
fma.rn.f64 fd145, fd109, 0d3FE22D961EA71119, fd141;
fma.rn.f64 fd716, fd108, 0d3FDDBE064267C47C, 0d0000000000000000;
fma.rn.f64 fd146, fd112, 0d3FEA55E242A4C3D2, fd716;
fma.rn.f64 fd715, fd730, 0d3FEC55A7E00740E9, %54;
fma.rn.f64 fd147, fd727, 0d3FE22D961EA71119, fd715;
fma.rn.f64 fd714, fd107, 0d3FDDBE064267C47C, 0d0000000000000000;
fma.rn.f64 fd148, fd111, 0d3FEA55E242A4C3D2, fd714;
fma.rn.f64 fd149, fd113, 0d3FBEDB7DEBAA3ED8, fd145;
fma.rn.f64 fd150, fd116, 0d3FEFC44566966769, fd146;
fma.rn.f64 fd151, fd725, 0d3FBEDB7DEBAA3ED8, fd147;
fma.rn.f64 fd152, fd115, 0d3FEFC44566966769, fd148;
fma.rn.f64 fd153, fd117, 0dBFD6B1D8B2365DA1, fd149;
fma.rn.f64 fd154, fd120, 0d3FEDEBA72EF20147, fd150;
fma.rn.f64 fd155, fd723, 0dBFD6B1D8B2365DA1, fd151;
fma.rn.f64 fd156, fd119, 0d3FEDEBA72EF20147, fd152;
fma.rn.f64 fd157, fd121, 0dBFE7F3CCD0032E0C, fd153;
fma.rn.f64 fd158, fd124, 0d3FE5384D024C2F84, fd154;
fma.rn.f64 fd159, fd720, 0dBFE7F3CCD0032E0C, fd155;
fma.rn.f64 fd160, fd123, 0d3FE5384D024C2F84, fd156;
fma.rn.f64 fd161, fd125, 0dBFEF11F493053D00, fd157;
fma.rn.f64 fd162, fd128, 0d3FCEA1E54BC48DBF, fd158;
fma.rn.f64 fd163, fd718, 0dBFEF11F493053D00, fd159;
fma.rn.f64 fd164, fd127, 0d3FCEA1E54BC48DBF, fd160;
sub.f64 fd165, fd161, fd162;
add.f64 fd167, fd162, fd161;
add.f64 fd713, fd164, fd163;
sub.f64 fd168, fd163, fd164;
fma.rn.f64 fd169, fd105, 0d3FE22D961EA71119, %53;
fma.rn.f64 fd173, fd109, 0dBFD6B1D8B2365DA1, fd169;
fma.rn.f64 fd712, fd108, 0d3FEA55E242A4C3D2, 0d0000000000000000;
fma.rn.f64 fd174, fd112, 0d3FEDEBA72EF20147, fd712;
fma.rn.f64 fd711, fd730, 0d3FE22D961EA71119, %54;
fma.rn.f64 fd175, fd727, 0dBFD6B1D8B2365DA1, fd711;
fma.rn.f64 fd710, fd107, 0d3FEA55E242A4C3D2, 0d0000000000000000;
fma.rn.f64 fd176, fd111, 0d3FEDEBA72EF20147, fd710;
fma.rn.f64 fd177, fd113, 0dBFEF11F493053D00, fd173;
fma.rn.f64 fd178, fd116, 0d3FCEA1E54BC48DBF, fd174;
fma.rn.f64 fd179, fd725, 0dBFEF11F493053D00, fd175;
fma.rn.f64 fd180, fd115, 0d3FCEA1E54BC48DBF, fd176;
fma.rn.f64 fd181, fd117, 0dBFE7F3CCD0032E0C, fd177;
fma.rn.f64 fd182, fd120, 0dBFE5384D024C2F84, fd178;
fma.rn.f64 fd183, fd723, 0dBFE7F3CCD0032E0C, fd179;
fma.rn.f64 fd184, fd119, 0dBFE5384D024C2F84, fd180;
fma.rn.f64 fd185, fd121, 0d3FBEDB7DEBAA3ED8, fd181;
fma.rn.f64 fd186, fd124, 0dBFEFC44566966769, fd182;
fma.rn.f64 fd187, fd720, 0d3FBEDB7DEBAA3ED8, fd183;
fma.rn.f64 fd188, fd123, 0dBFEFC44566966769, fd184;
fma.rn.f64 fd189, fd125, 0d3FEC55A7E00740E9, fd185;
fma.rn.f64 fd190, fd128, 0dBFDDBE064267C47C, fd186;
fma.rn.f64 fd191, fd718, 0d3FEC55A7E00740E9, fd187;
fma.rn.f64 fd192, fd127, 0dBFDDBE064267C47C, fd188;
sub.f64 fd193, fd189, fd190;
add.f64 fd195, fd190, fd189;
add.f64 fd709, fd192, fd191;
sub.f64 fd196, fd191, fd192;
fma.rn.f64 fd197, fd105, 0d3FBEDB7DEBAA3ED8, %53;
fma.rn.f64 fd201, fd109, 0dBFEF11F493053D00, fd197;
fma.rn.f64 fd708, fd108, 0d3FEFC44566966769, 0d0000000000000000;
fma.rn.f64 fd202, fd112, 0d3FCEA1E54BC48DBF, fd708;
fma.rn.f64 fd707, fd730, 0d3FBEDB7DEBAA3ED8, %54;
fma.rn.f64 fd203, fd727, 0dBFEF11F493053D00, fd707;
fma.rn.f64 fd706, fd107, 0d3FEFC44566966769, 0d0000000000000000;
fma.rn.f64 fd204, fd111, 0d3FCEA1E54BC48DBF, fd706;
fma.rn.f64 fd205, fd113, 0dBFD6B1D8B2365DA1, fd201;
fma.rn.f64 fd206, fd116, 0dBFEDEBA72EF20147, fd202;
fma.rn.f64 fd207, fd725, 0dBFD6B1D8B2365DA1, fd203;
fma.rn.f64 fd208, fd115, 0dBFEDEBA72EF20147, fd204;
fma.rn.f64 fd209, fd117, 0d3FEC55A7E00740E9, fd205;
fma.rn.f64 fd210, fd120, 0dBFDDBE064267C47C, fd206;
fma.rn.f64 fd211, fd723, 0d3FEC55A7E00740E9, fd207;
fma.rn.f64 fd212, fd119, 0dBFDDBE064267C47C, fd208;
fma.rn.f64 fd213, fd121, 0d3FE22D961EA71119, fd209;
fma.rn.f64 fd214, fd124, 0d3FEA55E242A4C3D2, fd210;
fma.rn.f64 fd215, fd720, 0d3FE22D961EA71119, fd211;
fma.rn.f64 fd216, fd123, 0d3FEA55E242A4C3D2, fd212;
fma.rn.f64 fd217, fd125, 0dBFE7F3CCD0032E0C, fd213;
fma.rn.f64 fd218, fd128, 0d3FE5384D024C2F84, fd214;
fma.rn.f64 fd219, fd718, 0dBFE7F3CCD0032E0C, fd215;
fma.rn.f64 fd220, fd127, 0d3FE5384D024C2F84, fd216;
sub.f64 fd221, fd217, fd218;
add.f64 fd223, fd218, fd217;
add.f64 fd705, fd220, fd219;
sub.f64 fd224, fd219, fd220;
fma.rn.f64 fd225, fd105, 0dBFD6B1D8B2365DA1, %53;
fma.rn.f64 fd229, fd109, 0dBFE7F3CCD0032E0C, fd225;
fma.rn.f64 fd704, fd108, 0d3FEDEBA72EF20147, 0d0000000000000000;
fma.rn.f64 fd230, fd112, 0dBFE5384D024C2F84, fd704;
fma.rn.f64 fd703, fd730, 0dBFD6B1D8B2365DA1, %54;
fma.rn.f64 fd231, fd727, 0dBFE7F3CCD0032E0C, fd703;
fma.rn.f64 fd702, fd107, 0d3FEDEBA72EF20147, 0d0000000000000000;
fma.rn.f64 fd232, fd111, 0dBFE5384D024C2F84, fd702;
fma.rn.f64 fd233, fd113, 0d3FEC55A7E00740E9, fd229;
fma.rn.f64 fd234, fd116, 0dBFDDBE064267C47C, fd230;
fma.rn.f64 fd235, fd725, 0d3FEC55A7E00740E9, fd231;
fma.rn.f64 fd236, fd115, 0dBFDDBE064267C47C, fd232;
fma.rn.f64 fd237, fd117, 0d3FBEDB7DEBAA3ED8, fd233;
fma.rn.f64 fd238, fd120, 0d3FEFC44566966769, fd234;
fma.rn.f64 fd239, fd723, 0d3FBEDB7DEBAA3ED8, fd235;
fma.rn.f64 fd240, fd119, 0d3FEFC44566966769, fd236;
fma.rn.f64 fd241, fd121, 0dBFEF11F493053D00, fd237;
fma.rn.f64 fd242, fd124, 0dBFCEA1E54BC48DBF, fd238;
fma.rn.f64 fd243, fd720, 0dBFEF11F493053D00, fd239;
fma.rn.f64 fd244, fd123, 0dBFCEA1E54BC48DBF, fd240;
fma.rn.f64 fd245, fd125, 0d3FE22D961EA71119, fd241;
fma.rn.f64 fd246, fd128, 0dBFEA55E242A4C3D2, fd242;
fma.rn.f64 fd247, fd718, 0d3FE22D961EA71119, fd243;
fma.rn.f64 fd248, fd127, 0dBFEA55E242A4C3D2, fd244;
sub.f64 fd249, fd245, fd246;
add.f64 fd251, fd246, fd245;
add.f64 fd701, fd248, fd247;
sub.f64 fd252, fd247, fd248;
fma.rn.f64 fd253, fd105, 0dBFE7F3CCD0032E0C, %53;
fma.rn.f64 fd257, fd109, 0d3FBEDB7DEBAA3ED8, fd253;
fma.rn.f64 fd700, fd108, 0d3FE5384D024C2F84, 0d0000000000000000;
fma.rn.f64 fd258, fd112, 0dBFEFC44566966769, fd700;
fma.rn.f64 fd699, fd730, 0dBFE7F3CCD0032E0C, %54;
fma.rn.f64 fd259, fd727, 0d3FBEDB7DEBAA3ED8, fd699;
fma.rn.f64 fd698, fd107, 0d3FE5384D024C2F84, 0d0000000000000000;
fma.rn.f64 fd260, fd111, 0dBFEFC44566966769, fd698;
fma.rn.f64 fd261, fd113, 0d3FE22D961EA71119, fd257;
fma.rn.f64 fd262, fd116, 0d3FEA55E242A4C3D2, fd258;
fma.rn.f64 fd263, fd725, 0d3FE22D961EA71119, fd259;
fma.rn.f64 fd264, fd115, 0d3FEA55E242A4C3D2, fd260;
fma.rn.f64 fd265, fd117, 0dBFEF11F493053D00, fd261;
fma.rn.f64 fd266, fd120, 0dBFCEA1E54BC48DBF, fd262;
fma.rn.f64 fd267, fd723, 0dBFEF11F493053D00, fd263;
fma.rn.f64 fd268, fd119, 0dBFCEA1E54BC48DBF, fd264;
fma.rn.f64 fd269, fd121, 0d3FEC55A7E00740E9, fd265;
fma.rn.f64 fd270, fd124, 0dBFDDBE064267C47C, fd266;
fma.rn.f64 fd271, fd720, 0d3FEC55A7E00740E9, fd267;
fma.rn.f64 fd272, fd123, 0dBFDDBE064267C47C, fd268;
fma.rn.f64 fd273, fd125, 0dBFD6B1D8B2365DA1, fd269;
fma.rn.f64 fd274, fd128, 0d3FEDEBA72EF20147, fd270;
fma.rn.f64 fd275, fd718, 0dBFD6B1D8B2365DA1, fd271;
fma.rn.f64 fd276, fd127, 0d3FEDEBA72EF20147, fd272;
sub.f64 fd277, fd273, fd274;
add.f64 fd279, fd274, fd273;
add.f64 fd697, fd276, fd275;
sub.f64 fd280, fd275, fd276;
fma.rn.f64 fd281, fd105, 0dBFEF11F493053D00, %53;
fma.rn.f64 fd282, fd108, 0d3FCEA1E54BC48DBF, 0d0000000000000000;
fma.rn.f64 fd283, fd730, 0dBFEF11F493053D00, %54;
fma.rn.f64 fd284, fd107, 0d3FCEA1E54BC48DBF, 0d0000000000000000;
fma.rn.f64 fd285, fd109, 0d3FEC55A7E00740E9, fd281;
fma.rn.f64 fd286, fd112, 0dBFDDBE064267C47C, fd282;
fma.rn.f64 fd287, fd727, 0d3FEC55A7E00740E9, fd283;
fma.rn.f64 fd288, fd111, 0dBFDDBE064267C47C, fd284;
fma.rn.f64 fd289, fd113, 0dBFE7F3CCD0032E0C, fd285;
fma.rn.f64 fd290, fd116, 0d3FE5384D024C2F84, fd286;
fma.rn.f64 fd291, fd725, 0dBFE7F3CCD0032E0C, fd287;
fma.rn.f64 fd292, fd115, 0d3FE5384D024C2F84, fd288;
fma.rn.f64 fd293, fd117, 0d3FE22D961EA71119, fd289;
fma.rn.f64 fd294, fd120, 0dBFEA55E242A4C3D2, fd290;
fma.rn.f64 fd295, fd723, 0d3FE22D961EA71119, fd291;
fma.rn.f64 fd296, fd119, 0dBFEA55E242A4C3D2, fd292;
fma.rn.f64 fd297, fd121, 0dBFD6B1D8B2365DA1, fd293;
fma.rn.f64 fd298, fd124, 0d3FEDEBA72EF20147, fd294;
fma.rn.f64 fd299, fd720, 0dBFD6B1D8B2365DA1, fd295;
fma.rn.f64 fd300, fd123, 0d3FEDEBA72EF20147, fd296;
fma.rn.f64 fd301, fd125, 0d3FBEDB7DEBAA3ED8, fd297;
fma.rn.f64 fd302, fd128, 0dBFEFC44566966769, fd298;
fma.rn.f64 fd303, fd718, 0d3FBEDB7DEBAA3ED8, fd299;
fma.rn.f64 fd304, fd127, 0dBFEFC44566966769, fd300;
sub.f64 fd305, fd301, fd302;
add.f64 fd307, fd302, fd301;
add.f64 fd696, fd304, fd303;
sub.f64 fd308, fd303, fd304;
add.f64 fd309, %59, %103;
sub.f64 fd311, %59, %103;
add.f64 fd695, %60, %104;
sub.f64 fd312, %60, %104;
add.f64 fd313, %63, %99;
sub.f64 fd315, %63, %99;
add.f64 fd692, %114, %113;
sub.f64 fd316, %114, %113;
add.f64 fd317, %67, %95;
sub.f64 fd319, %67, %95;
add.f64 fd690, %115, %96;
sub.f64 fd320, %115, %96;
add.f64 fd321, %71, %91;
sub.f64 fd323, %71, %91;
add.f64 fd688, %72, %116;
sub.f64 fd324, %72, %116;
add.f64 fd325, %75, %87;
sub.f64 fd327, %75, %87;
add.f64 fd685, %117, %118;
sub.f64 fd328, %117, %118;
add.f64 fd329, %79, %83;
sub.f64 fd331, %79, %83;
add.f64 fd683, %119, %84;
sub.f64 fd332, %119, %84;
add.f64 fd333, %55, fd309;
add.f64 fd335, fd333, fd313;
add.f64 fd681, %120, fd695;
add.f64 fd336, fd681, fd692;
add.f64 fd337, fd335, fd317;
add.f64 fd338, fd336, fd690;
add.f64 fd339, fd337, fd321;
add.f64 fd340, fd338, fd688;
add.f64 fd341, fd339, fd325;
add.f64 fd342, fd340, fd685;
add.f64 fd343, fd341, fd329;
add.f64 fd344, fd342, fd683;
fma.rn.f64 fd345, fd309, 0d3FEC55A7E00740E9, %55;
fma.rn.f64 fd349, fd313, 0d3FE22D961EA71119, fd345;
fma.rn.f64 fd680, fd312, 0d3FDDBE064267C47C, 0d0000000000000000;
fma.rn.f64 fd350, fd316, 0d3FEA55E242A4C3D2, fd680;
fma.rn.f64 fd679, fd695, 0d3FEC55A7E00740E9, %120;
fma.rn.f64 fd351, fd692, 0d3FE22D961EA71119, fd679;
fma.rn.f64 fd678, fd311, 0d3FDDBE064267C47C, 0d0000000000000000;
fma.rn.f64 fd352, fd315, 0d3FEA55E242A4C3D2, fd678;
fma.rn.f64 fd353, fd317, 0d3FBEDB7DEBAA3ED8, fd349;
fma.rn.f64 fd354, fd320, 0d3FEFC44566966769, fd350;
fma.rn.f64 fd355, fd690, 0d3FBEDB7DEBAA3ED8, fd351;
fma.rn.f64 fd356, fd319, 0d3FEFC44566966769, fd352;
fma.rn.f64 fd357, fd321, 0dBFD6B1D8B2365DA1, fd353;
fma.rn.f64 fd358, fd324, 0d3FEDEBA72EF20147, fd354;
fma.rn.f64 fd359, fd688, 0dBFD6B1D8B2365DA1, fd355;
fma.rn.f64 fd360, fd323, 0d3FEDEBA72EF20147, fd356;
fma.rn.f64 fd361, fd325, 0dBFE7F3CCD0032E0C, fd357;
fma.rn.f64 fd362, fd328, 0d3FE5384D024C2F84, fd358;
fma.rn.f64 fd363, fd685, 0dBFE7F3CCD0032E0C, fd359;
fma.rn.f64 fd364, fd327, 0d3FE5384D024C2F84, fd360;
fma.rn.f64 fd365, fd329, 0dBFEF11F493053D00, fd361;
fma.rn.f64 fd366, fd332, 0d3FCEA1E54BC48DBF, fd362;
fma.rn.f64 fd367, fd683, 0dBFEF11F493053D00, fd363;
fma.rn.f64 fd368, fd331, 0d3FCEA1E54BC48DBF, fd364;
sub.f64 fd369, fd365, fd366;
add.f64 fd371, fd366, fd365;
add.f64 fd677, fd368, fd367;
sub.f64 fd372, fd367, fd368;
fma.rn.f64 fd373, fd309, 0d3FE22D961EA71119, %55;
fma.rn.f64 fd377, fd313, 0dBFD6B1D8B2365DA1, fd373;
fma.rn.f64 fd676, fd312, 0d3FEA55E242A4C3D2, 0d0000000000000000;
fma.rn.f64 fd378, fd316, 0d3FEDEBA72EF20147, fd676;
fma.rn.f64 fd675, fd695, 0d3FE22D961EA71119, %120;
fma.rn.f64 fd379, fd692, 0dBFD6B1D8B2365DA1, fd675;
fma.rn.f64 fd674, fd311, 0d3FEA55E242A4C3D2, 0d0000000000000000;
fma.rn.f64 fd380, fd315, 0d3FEDEBA72EF20147, fd674;
fma.rn.f64 fd381, fd317, 0dBFEF11F493053D00, fd377;
fma.rn.f64 fd382, fd320, 0d3FCEA1E54BC48DBF, fd378;
fma.rn.f64 fd383, fd690, 0dBFEF11F493053D00, fd379;
fma.rn.f64 fd384, fd319, 0d3FCEA1E54BC48DBF, fd380;
fma.rn.f64 fd385, fd321, 0dBFE7F3CCD0032E0C, fd381;
fma.rn.f64 fd386, fd324, 0dBFE5384D024C2F84, fd382;
fma.rn.f64 fd387, fd688, 0dBFE7F3CCD0032E0C, fd383;
fma.rn.f64 fd388, fd323, 0dBFE5384D024C2F84, fd384;
fma.rn.f64 fd389, fd325, 0d3FBEDB7DEBAA3ED8, fd385;
fma.rn.f64 fd390, fd328, 0dBFEFC44566966769, fd386;
fma.rn.f64 fd391, fd685, 0d3FBEDB7DEBAA3ED8, fd387;
fma.rn.f64 fd392, fd327, 0dBFEFC44566966769, fd388;
fma.rn.f64 fd393, fd329, 0d3FEC55A7E00740E9, fd389;
fma.rn.f64 fd394, fd332, 0dBFDDBE064267C47C, fd390;
fma.rn.f64 fd395, fd683, 0d3FEC55A7E00740E9, fd391;
fma.rn.f64 fd396, fd331, 0dBFDDBE064267C47C, fd392;
sub.f64 fd397, fd393, fd394;
add.f64 fd399, fd394, fd393;
add.f64 fd673, fd396, fd395;
sub.f64 fd400, fd395, fd396;
fma.rn.f64 fd401, fd309, 0d3FBEDB7DEBAA3ED8, %55;
fma.rn.f64 fd405, fd313, 0dBFEF11F493053D00, fd401;
fma.rn.f64 fd672, fd312, 0d3FEFC44566966769, 0d0000000000000000;
fma.rn.f64 fd406, fd316, 0d3FCEA1E54BC48DBF, fd672;
fma.rn.f64 fd671, fd695, 0d3FBEDB7DEBAA3ED8, %120;
fma.rn.f64 fd407, fd692, 0dBFEF11F493053D00, fd671;
fma.rn.f64 fd670, fd311, 0d3FEFC44566966769, 0d0000000000000000;
fma.rn.f64 fd408, fd315, 0d3FCEA1E54BC48DBF, fd670;
fma.rn.f64 fd409, fd317, 0dBFD6B1D8B2365DA1, fd405;
fma.rn.f64 fd410, fd320, 0dBFEDEBA72EF20147, fd406;
fma.rn.f64 fd411, fd690, 0dBFD6B1D8B2365DA1, fd407;
fma.rn.f64 fd412, fd319, 0dBFEDEBA72EF20147, fd408;
fma.rn.f64 fd413, fd321, 0d3FEC55A7E00740E9, fd409;
fma.rn.f64 fd414, fd324, 0dBFDDBE064267C47C, fd410;
fma.rn.f64 fd415, fd688, 0d3FEC55A7E00740E9, fd411;
fma.rn.f64 fd416, fd323, 0dBFDDBE064267C47C, fd412;
fma.rn.f64 fd417, fd325, 0d3FE22D961EA71119, fd413;
fma.rn.f64 fd418, fd328, 0d3FEA55E242A4C3D2, fd414;
fma.rn.f64 fd419, fd685, 0d3FE22D961EA71119, fd415;
fma.rn.f64 fd420, fd327, 0d3FEA55E242A4C3D2, fd416;
fma.rn.f64 fd421, fd329, 0dBFE7F3CCD0032E0C, fd417;
fma.rn.f64 fd422, fd332, 0d3FE5384D024C2F84, fd418;
fma.rn.f64 fd423, fd683, 0dBFE7F3CCD0032E0C, fd419;
fma.rn.f64 fd424, fd331, 0d3FE5384D024C2F84, fd420;
sub.f64 fd425, fd421, fd422;
add.f64 fd427, fd422, fd421;
add.f64 fd669, fd424, fd423;
sub.f64 fd428, fd423, fd424;
fma.rn.f64 fd429, fd309, 0dBFD6B1D8B2365DA1, %55;
fma.rn.f64 fd433, fd313, 0dBFE7F3CCD0032E0C, fd429;
fma.rn.f64 fd668, fd312, 0d3FEDEBA72EF20147, 0d0000000000000000;
fma.rn.f64 fd434, fd316, 0dBFE5384D024C2F84, fd668;
fma.rn.f64 fd667, fd695, 0dBFD6B1D8B2365DA1, %120;
fma.rn.f64 fd435, fd692, 0dBFE7F3CCD0032E0C, fd667;
fma.rn.f64 fd666, fd311, 0d3FEDEBA72EF20147, 0d0000000000000000;
fma.rn.f64 fd436, fd315, 0dBFE5384D024C2F84, fd666;
fma.rn.f64 fd437, fd317, 0d3FEC55A7E00740E9, fd433;
fma.rn.f64 fd438, fd320, 0dBFDDBE064267C47C, fd434;
fma.rn.f64 fd439, fd690, 0d3FEC55A7E00740E9, fd435;
fma.rn.f64 fd440, fd319, 0dBFDDBE064267C47C, fd436;
fma.rn.f64 fd441, fd321, 0d3FBEDB7DEBAA3ED8, fd437;
fma.rn.f64 fd442, fd324, 0d3FEFC44566966769, fd438;
fma.rn.f64 fd443, fd688, 0d3FBEDB7DEBAA3ED8, fd439;
fma.rn.f64 fd444, fd323, 0d3FEFC44566966769, fd440;
fma.rn.f64 fd445, fd325, 0dBFEF11F493053D00, fd441;
fma.rn.f64 fd446, fd328, 0dBFCEA1E54BC48DBF, fd442;
fma.rn.f64 fd447, fd685, 0dBFEF11F493053D00, fd443;
fma.rn.f64 fd448, fd327, 0dBFCEA1E54BC48DBF, fd444;
fma.rn.f64 fd449, fd329, 0d3FE22D961EA71119, fd445;
fma.rn.f64 fd450, fd332, 0dBFEA55E242A4C3D2, fd446;
fma.rn.f64 fd451, fd683, 0d3FE22D961EA71119, fd447;
fma.rn.f64 fd452, fd331, 0dBFEA55E242A4C3D2, fd448;
sub.f64 fd453, fd449, fd450;
add.f64 fd455, fd450, fd449;
add.f64 fd665, fd452, fd451;
sub.f64 fd456, fd451, fd452;
fma.rn.f64 fd457, fd309, 0dBFE7F3CCD0032E0C, %55;
fma.rn.f64 fd461, fd313, 0d3FBEDB7DEBAA3ED8, fd457;
fma.rn.f64 fd664, fd312, 0d3FE5384D024C2F84, 0d0000000000000000;
fma.rn.f64 fd462, fd316, 0dBFEFC44566966769, fd664;
fma.rn.f64 fd663, fd695, 0dBFE7F3CCD0032E0C, %120;
fma.rn.f64 fd463, fd692, 0d3FBEDB7DEBAA3ED8, fd663;
fma.rn.f64 fd662, fd311, 0d3FE5384D024C2F84, 0d0000000000000000;
fma.rn.f64 fd464, fd315, 0dBFEFC44566966769, fd662;
fma.rn.f64 fd465, fd317, 0d3FE22D961EA71119, fd461;
fma.rn.f64 fd466, fd320, 0d3FEA55E242A4C3D2, fd462;
fma.rn.f64 fd467, fd690, 0d3FE22D961EA71119, fd463;
fma.rn.f64 fd468, fd319, 0d3FEA55E242A4C3D2, fd464;
fma.rn.f64 fd469, fd321, 0dBFEF11F493053D00, fd465;
fma.rn.f64 fd470, fd324, 0dBFCEA1E54BC48DBF, fd466;
fma.rn.f64 fd471, fd688, 0dBFEF11F493053D00, fd467;
fma.rn.f64 fd472, fd323, 0dBFCEA1E54BC48DBF, fd468;
fma.rn.f64 fd473, fd325, 0d3FEC55A7E00740E9, fd469;
fma.rn.f64 fd474, fd328, 0dBFDDBE064267C47C, fd470;
fma.rn.f64 fd475, fd685, 0d3FEC55A7E00740E9, fd471;
fma.rn.f64 fd476, fd327, 0dBFDDBE064267C47C, fd472;
fma.rn.f64 fd477, fd329, 0dBFD6B1D8B2365DA1, fd473;
fma.rn.f64 fd478, fd332, 0d3FEDEBA72EF20147, fd474;
fma.rn.f64 fd479, fd683, 0dBFD6B1D8B2365DA1, fd475;
fma.rn.f64 fd480, fd331, 0d3FEDEBA72EF20147, fd476;
sub.f64 fd481, fd477, fd478;
add.f64 fd483, fd478, fd477;
add.f64 fd661, fd480, fd479;
sub.f64 fd484, fd479, fd480;
fma.rn.f64 fd485, fd309, 0dBFEF11F493053D00, %55;
fma.rn.f64 fd486, fd312, 0d3FCEA1E54BC48DBF, 0d0000000000000000;
fma.rn.f64 fd487, fd695, 0dBFEF11F493053D00, %52;
fma.rn.f64 fd488, fd311, 0d3FCEA1E54BC48DBF, 0d0000000000000000;
fma.rn.f64 fd489, fd313, 0d3FEC55A7E00740E9, fd485;
fma.rn.f64 fd490, fd316, 0dBFDDBE064267C47C, fd486;
fma.rn.f64 fd491, fd692, 0d3FEC55A7E00740E9, fd487;
fma.rn.f64 fd492, fd315, 0dBFDDBE064267C47C, fd488;
fma.rn.f64 fd493, fd317, 0dBFE7F3CCD0032E0C, fd489;
fma.rn.f64 fd494, fd320, 0d3FE5384D024C2F84, fd490;
fma.rn.f64 fd495, fd690, 0dBFE7F3CCD0032E0C, fd491;
fma.rn.f64 fd496, fd319, 0d3FE5384D024C2F84, fd492;
fma.rn.f64 fd497, fd321, 0d3FE22D961EA71119, fd493;
fma.rn.f64 fd498, fd324, 0dBFEA55E242A4C3D2, fd494;
fma.rn.f64 fd499, fd688, 0d3FE22D961EA71119, fd495;
fma.rn.f64 fd500, fd323, 0dBFEA55E242A4C3D2, fd496;
fma.rn.f64 fd501, fd325, 0dBFD6B1D8B2365DA1, fd497;
fma.rn.f64 fd502, fd328, 0d3FEDEBA72EF20147, fd498;
fma.rn.f64 fd503, fd685, 0dBFD6B1D8B2365DA1, fd499;
fma.rn.f64 fd504, fd327, 0d3FEDEBA72EF20147, fd500;
fma.rn.f64 fd505, fd329, 0d3FBEDB7DEBAA3ED8, fd501;
fma.rn.f64 fd506, fd332, 0dBFEFC44566966769, fd502;
fma.rn.f64 fd507, fd683, 0d3FBEDB7DEBAA3ED8, fd503;
fma.rn.f64 fd508, fd331, 0dBFEFC44566966769, fd504;
sub.f64 fd509, fd505, fd506;
add.f64 fd511, fd506, fd505;
add.f64 fd660, fd508, fd507;
sub.f64 fd512, fd507, fd508;
mul.f64 fd514, fd677, 0d3FCEA1E54BC48DBF;
mul.f64 fd659, fd369, 0d3FEF11F493053D00;
sub.f64 fd515, fd659, fd514;
mul.f64 fd516, fd677, 0d3FEF11F493053D00;
fma.rn.f64 fd517, fd369, 0d3FCEA1E54BC48DBF, fd516;
mul.f64 fd519, fd673, 0d3FDDBE064267C47C;
mul.f64 fd658, fd397, 0d3FEC55A7E00740E9;
sub.f64 fd520, fd658, fd519;
mul.f64 fd521, fd673, 0d3FEC55A7E00740E9;
fma.rn.f64 fd522, fd397, 0d3FDDBE064267C47C, fd521;
mul.f64 fd656, fd425, 0d3FE7F3CCD0032E0C;
mul.f64 fd657, fd669, 0d3FE5384D024C2F84;
sub.f64 fd525, fd656, fd657;
mul.f64 fd526, fd669, 0d3FE7F3CCD0032E0C;
fma.rn.f64 fd527, fd425, 0d3FE5384D024C2F84, fd526;
mul.f64 fd654, fd453, 0d3FE22D961EA71119;
mul.f64 fd655, fd665, 0d3FEA55E242A4C3D2;
sub.f64 fd530, fd654, fd655;
mul.f64 fd531, fd665, 0d3FE22D961EA71119;
fma.rn.f64 fd532, fd453, 0d3FEA55E242A4C3D2, fd531;
mul.f64 fd652, fd481, 0d3FD6B1D8B2365DA1;
mul.f64 fd653, fd661, 0d3FEDEBA72EF20147;
sub.f64 fd535, fd652, fd653;
mul.f64 fd536, fd661, 0d3FD6B1D8B2365DA1;
fma.rn.f64 fd537, fd481, 0d3FEDEBA72EF20147, fd536;
mul.f64 fd650, fd509, 0d3FBEDB7DEBAA3ED8;
mul.f64 fd651, fd660, 0d3FEFC44566966769;
sub.f64 fd540, fd650, fd651;
mul.f64 fd541, fd660, 0d3FBEDB7DEBAA3ED8;
fma.rn.f64 fd542, fd509, 0d3FEFC44566966769, fd541;
mul.f64 fd544, fd512, 0d3FEFC44566966769;
mul.f64 fd649, fd511, 0dBFBEDB7DEBAA3ED8;
sub.f64 fd545, fd649, fd544;
mul.f64 fd546, fd512, 0dBFBEDB7DEBAA3ED8;
fma.rn.f64 fd547, fd511, 0d3FEFC44566966769, fd546;
mul.f64 fd549, fd484, 0d3FEDEBA72EF20147;
mul.f64 fd648, fd483, 0dBFD6B1D8B2365DA1;
sub.f64 fd550, fd648, fd549;
mul.f64 fd551, fd484, 0dBFD6B1D8B2365DA1;
fma.rn.f64 fd552, fd483, 0d3FEDEBA72EF20147, fd551;
mul.f64 fd554, fd456, 0d3FEA55E242A4C3D2;
mul.f64 fd647, fd455, 0dBFE22D961EA71119;
sub.f64 fd555, fd647, fd554;
mul.f64 fd556, fd456, 0dBFE22D961EA71119;
fma.rn.f64 fd557, fd455, 0d3FEA55E242A4C3D2, fd556;
mul.f64 fd559, fd428, 0d3FE5384D024C2F84;
mul.f64 fd646, fd427, 0dBFE7F3CCD0032E0C;
sub.f64 fd560, fd646, fd559;
mul.f64 fd561, fd428, 0dBFE7F3CCD0032E0C;
fma.rn.f64 fd562, fd427, 0d3FE5384D024C2F84, fd561;
mul.f64 fd564, fd400, 0d3FDDBE064267C47C;
mul.f64 fd645, fd399, 0dBFEC55A7E00740E9;
sub.f64 fd565, fd645, fd564;
mul.f64 fd566, fd400, 0dBFEC55A7E00740E9;
fma.rn.f64 fd567, fd399, 0d3FDDBE064267C47C, fd566;
mul.f64 fd643, fd371, 0dBFEF11F493053D00;
mul.f64 fd644, fd372, 0d3FCEA1E54BC48DBF;
sub.f64 fd570, fd643, fd644;
mul.f64 fd571, fd372, 0dBFEF11F493053D00;
fma.rn.f64 fd572, fd371, 0d3FCEA1E54BC48DBF, fd571;
add.f64 %1, fd140, fd344;
add.f64 %0, fd139, fd343;
add.f64 %2, fd165, fd515;
add.f64 %3, fd713, fd517;
add.f64 %4, fd193, fd520;
add.f64 %5, fd709, fd522;
add.f64 %6, fd221, fd525;
add.f64 %7, fd705, fd527;
add.f64 %8, fd249, fd530;
add.f64 %9, fd701, fd532;
add.f64 %11, fd697, fd537;
add.f64 %10, fd277, fd535;
add.f64 %13, fd696, fd542;
add.f64 %12, fd305, fd540;
add.f64 %15, fd308, fd547;
add.f64 %14, fd307, fd545;
add.f64 %16, fd279, fd550;
add.f64 %17, fd280, fd552;
add.f64 %18, fd251, fd555;
add.f64 %19, fd252, fd557;
add.f64 %20, fd223, fd560;
add.f64 %21, fd224, fd562;
add.f64 %22, fd195, fd565;
add.f64 %23, fd196, fd567;
add.f64 %25, fd168, fd572;
add.f64 %24, fd167, fd570;
sub.f64 %27, fd140, fd344;
sub.f64 %26, fd139, fd343;
sub.f64 %29, fd713, fd517;
sub.f64 %28, fd165, fd515;
sub.f64 %31, fd709, fd522;
sub.f64 %30, fd193, fd520;
sub.f64 %33, fd705, fd527;
sub.f64 %32, fd221, fd525;
sub.f64 %35, fd701, fd532;
sub.f64 %34, fd249, fd530;
sub.f64 %37, fd697, fd537;
sub.f64 %36, fd277, fd535;
sub.f64 %39, fd696, fd542;
sub.f64 %38, fd305, fd540;
sub.f64 %41, fd308, fd547;
sub.f64 %40, fd307, fd545;
sub.f64 %43, fd280, fd552;
sub.f64 %42, fd279, fd550;
sub.f64 %45, fd252, fd557;
sub.f64 %44, fd251, fd555;
sub.f64 %47, fd224, fd562;
sub.f64 %46, fd223, fd560;
sub.f64 %49, fd196, fd567;
sub.f64 %48, fd195, fd565;
sub.f64 %51, fd168, fd572;
sub.f64 %50, fd167, fd570;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y), "=d"(rmem[7].x), "=d"(rmem[7].y), "=d"(rmem[8].x), "=d"(rmem[8].y), "=d"(rmem[9].x), "=d"(rmem[9].y), "=d"(rmem[10].x), "=d"(rmem[10].y), "=d"(rmem[11].x), "=d"(rmem[11].y), "=d"(rmem[12].x), "=d"(rmem[12].y), "=d"(rmem[13].x), "=d"(rmem[13].y), "=d"(rmem[14].x), "=d"(rmem[14].y), "=d"(rmem[15].x), "=d"(rmem[15].y), "=d"(rmem[16].x), "=d"(rmem[16].y), "=d"(rmem[17].x), "=d"(rmem[17].y), "=d"(rmem[18].x), "=d"(rmem[18].y), "=d"(rmem[19].x), "=d"(rmem[19].y), "=d"(rmem[20].x), "=d"(rmem[20].y), "=d"(rmem[21].x), "=d"(rmem[21].y), "=d"(rmem[22].x), "=d"(rmem[22].y), "=d"(rmem[23].x), "=d"(rmem[23].y), "=d"(rmem[24].x), "=d"(rmem[24].y), "=d"(rmem[25].x), "=d"(rmem[25].y): "d"(rmem[1].y), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y), "d"(rmem[7].x), "d"(rmem[7].y), "d"(rmem[8].x), "d"(rmem[8].y), "d"(rmem[9].x), "d"(rmem[9].y), "d"(rmem[10].x), "d"(rmem[10].y), "d"(rmem[11].x), "d"(rmem[11].y), "d"(rmem[12].x), "d"(rmem[12].y), "d"(rmem[13].x), "d"(rmem[13].y), "d"(rmem[14].x), "d"(rmem[14].y), "d"(rmem[15].x), "d"(rmem[15].y), "d"(rmem[16].x), "d"(rmem[16].y), "d"(rmem[17].x), "d"(rmem[17].y), "d"(rmem[18].x), "d"(rmem[18].y), "d"(rmem[19].x), "d"(rmem[19].y), "d"(rmem[20].x), "d"(rmem[20].y), "d"(rmem[21].x), "d"(rmem[21].y), "d"(rmem[22].x), "d"(rmem[22].y), "d"(rmem[23].x), "d"(rmem[23].y), "d"(rmem[24].x), "d"(rmem[24].y), "d"(rmem[25].x), "d"(rmem[25].y), "d"(rmem[2].y), "d"(rmem[4].y), "d"(rmem[22].y), "d"(rmem[20].y), "d"(rmem[8].y), "d"(rmem[10].y), "d"(rmem[16].y), "d"(rmem[14].y), "d"(rmem[23].y), "d"(rmem[5].y), "d"(rmem[7].y), "d"(rmem[19].y), "d"(rmem[11].y), "d"(rmem[17].y), "d"(rmem[13].y), "d"(rmem[1].y));
};


#endif
