#ifndef CUFFTDX_FFT_100_FP32_FWD_PTX_HPP
#define CUFFTDX_FFT_100_FP32_FWD_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<192, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<426>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 800, r2;
mov.u32 r4, %tid.x;
add.f32 f41, %27, %43;
add.f32 f42, %22, f41;
add.f32 f43, %32, %38;
add.f32 f44, f43, f42;
add.f32 f45, %29, %45;
add.f32 f46, %23, f45;
add.f32 f47, %34, %39;
add.f32 f48, f47, f46;
fma.rn.f32 f49, f41, 0f3E9E377A, %22;
mul.f32 f50, f43, 0f3F4F1BBD;
sub.f32 f51, f49, f50;
sub.f32 f52, %29, %45;
mul.f32 f53, f52, 0f3F737871;
sub.f32 f54, %34, %39;
mul.f32 f55, f54, 0fBF167918;
sub.f32 f56, f55, f53;
sub.f32 f57, f51, f56;
add.f32 f58, f56, f51;
mul.f32 f59, f41, 0f3F4F1BBD;
sub.f32 f60, %22, f59;
fma.rn.f32 f61, f43, 0f3E9E377A, f60;
mul.f32 f62, f52, 0f3F167918;
mul.f32 f63, f54, 0f3F737871;
sub.f32 f64, f63, f62;
sub.f32 f65, f61, f64;
add.f32 f66, f64, f61;
fma.rn.f32 f67, f45, 0f3E9E377A, %23;
mul.f32 f68, f47, 0f3F4F1BBD;
sub.f32 f69, f67, f68;
sub.f32 f70, %27, %43;
mul.f32 f71, f70, 0f3F737871;
sub.f32 f72, %32, %38;
mul.f32 f73, f72, 0fBF167918;
sub.f32 f74, f73, f71;
add.f32 f75, f74, f69;
sub.f32 f76, f69, f74;
mul.f32 f77, f45, 0f3F4F1BBD;
sub.f32 f78, %23, f77;
fma.rn.f32 f79, f47, 0f3E9E377A, f78;
mul.f32 f80, f70, 0f3F167918;
mul.f32 f81, f72, 0f3F737871;
sub.f32 f82, f81, f80;
add.f32 f83, f82, f79;
sub.f32 f84, f79, f82;
add.f32 f85, %30, %46;
add.f32 f86, %24, f85;
add.f32 f87, %35, %40;
add.f32 f88, f87, f86;
add.f32 f89, %31, %47;
add.f32 f90, %26, f89;
add.f32 f91, %37, %42;
add.f32 f92, f91, f90;
fma.rn.f32 f93, f85, 0f3E9E377A, %24;
mul.f32 f94, f87, 0f3F4F1BBD;
sub.f32 f95, f93, f94;
sub.f32 f96, %31, %47;
mul.f32 f97, f96, 0f3F737871;
sub.f32 f98, %37, %42;
mul.f32 f99, f98, 0fBF167918;
sub.f32 f100, f99, f97;
sub.f32 f101, f95, f100;
add.f32 f102, f100, f95;
mul.f32 f103, f85, 0f3F4F1BBD;
sub.f32 f104, %24, f103;
fma.rn.f32 f105, f87, 0f3E9E377A, f104;
mul.f32 f106, f96, 0f3F167918;
mul.f32 f107, f98, 0f3F737871;
sub.f32 f108, f107, f106;
sub.f32 f109, f105, f108;
add.f32 f110, f108, f105;
fma.rn.f32 f111, f89, 0f3E9E377A, %26;
mul.f32 f112, f91, 0f3F4F1BBD;
sub.f32 f113, f111, f112;
sub.f32 f114, %30, %46;
mul.f32 f115, f114, 0f3F737871;
sub.f32 f116, %35, %40;
mul.f32 f117, f116, 0fBF167918;
sub.f32 f118, f117, f115;
add.f32 f119, f118, f113;
sub.f32 f120, f113, f118;
mul.f32 f121, f89, 0f3F4F1BBD;
sub.f32 f122, %26, f121;
fma.rn.f32 f123, f91, 0f3E9E377A, f122;
mul.f32 f124, f114, 0f3F167918;
mul.f32 f125, f116, 0f3F737871;
sub.f32 f126, f125, f124;
add.f32 f127, f126, f123;
sub.f32 f128, f123, f126;
mul.f32 f129, f101, 0f3F4F1BBD;
mul.f32 f130, f119, 0fBF167918;
sub.f32 f131, f129, f130;
mul.f32 f132, f119, 0f3F4F1BBD;
fma.rn.f32 f133, f101, 0fBF167918, f132;
mul.f32 f134, f109, 0f3E9E377A;
mul.f32 f135, f127, 0fBF737871;
sub.f32 f136, f134, f135;
mul.f32 f137, f127, 0f3E9E377A;
fma.rn.f32 f138, f109, 0fBF737871, f137;
mul.f32 f139, f110, 0fBE9E377A;
mul.f32 f140, f128, 0fBF737871;
sub.f32 f141, f139, f140;
mul.f32 f142, f128, 0fBE9E377A;
fma.rn.f32 f143, f110, 0fBF737871, f142;
mul.f32 f144, f102, 0fBF4F1BBD;
mul.f32 f145, f120, 0fBF167918;
sub.f32 f146, f144, f145;
mul.f32 f147, f120, 0fBF4F1BBD;
fma.rn.f32 f148, f102, 0fBF167918, f147;
sub.f32 f149, f44, f88;
sub.f32 f150, f48, f92;
add.f32 f151, f57, f131;
add.f32 f152, f75, f133;
sub.f32 f153, f57, f131;
sub.f32 f154, f75, f133;
add.f32 f155, f65, f136;
add.f32 f156, f83, f138;
sub.f32 f157, f65, f136;
sub.f32 f158, f83, f138;
add.f32 f159, f66, f141;
add.f32 f160, f84, f143;
sub.f32 f161, f66, f141;
sub.f32 f162, f84, f143;
add.f32 f163, f58, f146;
add.f32 f164, f76, f148;
sub.f32 f165, f58, f146;
sub.f32 f166, f76, f148;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 10;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 800, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f167, f168}, [rd6];
mul.f32 f171, f167, f151;
mul.f32 f172, f168, f152;
mul.f32 f173, f167, f152;
mul.f32 f174, f167, f167;
mul.f32 f175, f168, f168;
sub.f32 f176, f174, f175;
mul.f32 f177, f168, f167;
fma.rn.f32 f178, f168, f167, f177;
mul.f32 f179, f176, f155;
mul.f32 f180, f178, f156;
mul.f32 f181, f176, f156;
mul.f32 f182, f167, f176;
mul.f32 f183, f168, f178;
sub.f32 f184, f182, f183;
mul.f32 f185, f167, f178;
fma.rn.f32 f186, f168, f176, f185;
mul.f32 f187, f184, f159;
mul.f32 f188, f186, f160;
mul.f32 f189, f184, f160;
mul.f32 f190, f167, f184;
mul.f32 f191, f168, f186;
sub.f32 f192, f190, f191;
mul.f32 f193, f167, f186;
fma.rn.f32 f194, f168, f184, f193;
mul.f32 f195, f192, f163;
mul.f32 f196, f194, f164;
mul.f32 f197, f192, f164;
mul.f32 f198, f167, f192;
mul.f32 f199, f168, f194;
sub.f32 f200, f198, f199;
mul.f32 f201, f167, f194;
fma.rn.f32 f202, f168, f192, f201;
mul.f32 f203, f200, f149;
mul.f32 f204, f202, f150;
mul.f32 f205, f200, f150;
mul.f32 f206, f167, f200;
mul.f32 f207, f168, f202;
sub.f32 f208, f206, f207;
mul.f32 f209, f167, f202;
fma.rn.f32 f210, f168, f200, f209;
mul.f32 f211, f208, f153;
mul.f32 f212, f210, f154;
mul.f32 f213, f208, f154;
mul.f32 f214, f167, f208;
mul.f32 f215, f168, f210;
sub.f32 f216, f214, f215;
mul.f32 f217, f167, f210;
fma.rn.f32 f218, f168, f208, f217;
mul.f32 f219, f216, f157;
mul.f32 f220, f218, f158;
mul.f32 f221, f216, f158;
mul.f32 f222, f167, f216;
mul.f32 f223, f168, f218;
sub.f32 f224, f222, f223;
mul.f32 f225, f167, f218;
fma.rn.f32 f226, f168, f216, f225;
mul.f32 f227, f224, f161;
mul.f32 f228, f226, f162;
mul.f32 f229, f224, f162;
mul.f32 f230, f167, f224;
mul.f32 f231, f168, f226;
sub.f32 f232, f230, f231;
mul.f32 f233, f167, f226;
fma.rn.f32 f234, f168, f224, f233;
mul.f32 f235, f232, f165;
mul.f32 f236, f234, f166;
mul.f32 f237, f232, f166;
barrier.sync 0;
mad.lo.s32 r9, r7, 80, r8;
add.f32 f238, f48, f92;
add.f32 f239, f44, f88;
st.shared.v2.f32 [r9], {f239, f238};
fma.rn.f32 f240, f168, f151, f173;
sub.f32 f241, f171, f172;
st.shared.v2.f32 [r9+8], {f241, f240};
fma.rn.f32 f242, f178, f155, f181;
sub.f32 f243, f179, f180;
st.shared.v2.f32 [r9+16], {f243, f242};
fma.rn.f32 f244, f186, f159, f189;
sub.f32 f245, f187, f188;
st.shared.v2.f32 [r9+24], {f245, f244};
sub.f32 f246, f195, f196;
fma.rn.f32 f247, f194, f163, f197;
st.shared.v2.f32 [r9+32], {f246, f247};
fma.rn.f32 f248, f202, f149, f205;
sub.f32 f249, f203, f204;
st.shared.v2.f32 [r9+40], {f249, f248};
fma.rn.f32 f250, f210, f153, f213;
sub.f32 f251, f211, f212;
st.shared.v2.f32 [r9+48], {f251, f250};
fma.rn.f32 f252, f218, f157, f221;
sub.f32 f253, f219, f220;
st.shared.v2.f32 [r9+56], {f253, f252};
fma.rn.f32 f254, f226, f161, f229;
sub.f32 f255, f227, f228;
st.shared.v2.f32 [r9+64], {f255, f254};
fma.rn.f32 f256, f234, f165, f237;
sub.f32 f257, f235, f236;
st.shared.v2.f32 [r9+72], {f257, f256};
barrier.sync 0;
mad.lo.s32 r10, r7, -72, r9;
ld.shared.v2.f32 {f258, f259}, [r10];
ld.shared.v2.f32 {f262, f263}, [r10+80];
ld.shared.v2.f32 {f266, f267}, [r10+160];
ld.shared.v2.f32 {f270, f271}, [r10+240];
ld.shared.v2.f32 {f274, f275}, [r10+320];
ld.shared.v2.f32 {f278, f279}, [r10+400];
ld.shared.v2.f32 {f282, f283}, [r10+480];
ld.shared.v2.f32 {f286, f287}, [r10+560];
ld.shared.v2.f32 {f290, f291}, [r10+640];
ld.shared.v2.f32 {f294, f295}, [r10+720];
add.f32 f298, f266, f290;
add.f32 f299, f258, f298;
add.f32 f300, f274, f282;
add.f32 f301, f300, f299;
add.f32 f302, f267, f291;
add.f32 f303, f259, f302;
add.f32 f304, f275, f283;
add.f32 f305, f304, f303;
fma.rn.f32 f306, f298, 0f3E9E377A, f258;
mul.f32 f307, f300, 0f3F4F1BBD;
sub.f32 f308, f306, f307;
sub.f32 f309, f267, f291;
mul.f32 f310, f309, 0f3F737871;
sub.f32 f311, f275, f283;
mul.f32 f312, f311, 0fBF167918;
sub.f32 f313, f312, f310;
sub.f32 f314, f308, f313;
add.f32 f315, f313, f308;
mul.f32 f316, f298, 0f3F4F1BBD;
sub.f32 f317, f258, f316;
fma.rn.f32 f318, f300, 0f3E9E377A, f317;
mul.f32 f319, f309, 0f3F167918;
mul.f32 f320, f311, 0f3F737871;
sub.f32 f321, f320, f319;
sub.f32 f322, f318, f321;
add.f32 f323, f321, f318;
fma.rn.f32 f324, f302, 0f3E9E377A, f259;
mul.f32 f325, f304, 0f3F4F1BBD;
sub.f32 f326, f324, f325;
sub.f32 f327, f266, f290;
mul.f32 f328, f327, 0f3F737871;
sub.f32 f329, f274, f282;
mul.f32 f330, f329, 0fBF167918;
sub.f32 f331, f330, f328;
add.f32 f332, f331, f326;
sub.f32 f333, f326, f331;
mul.f32 f334, f302, 0f3F4F1BBD;
sub.f32 f335, f259, f334;
fma.rn.f32 f336, f304, 0f3E9E377A, f335;
mul.f32 f337, f327, 0f3F167918;
mul.f32 f338, f329, 0f3F737871;
sub.f32 f339, f338, f337;
add.f32 f340, f339, f336;
sub.f32 f341, f336, f339;
add.f32 f342, f270, f294;
add.f32 f343, f262, f342;
add.f32 f344, f278, f286;
add.f32 f345, f344, f343;
add.f32 f346, f271, f295;
add.f32 f347, f263, f346;
add.f32 f348, f279, f287;
add.f32 f349, f348, f347;
fma.rn.f32 f350, f342, 0f3E9E377A, f262;
mul.f32 f351, f344, 0f3F4F1BBD;
sub.f32 f352, f350, f351;
sub.f32 f353, f271, f295;
mul.f32 f354, f353, 0f3F737871;
sub.f32 f355, f279, f287;
mul.f32 f356, f355, 0fBF167918;
sub.f32 f357, f356, f354;
sub.f32 f358, f352, f357;
add.f32 f359, f357, f352;
mul.f32 f360, f342, 0f3F4F1BBD;
sub.f32 f361, f262, f360;
fma.rn.f32 f362, f344, 0f3E9E377A, f361;
mul.f32 f363, f353, 0f3F167918;
mul.f32 f364, f355, 0f3F737871;
sub.f32 f365, f364, f363;
sub.f32 f366, f362, f365;
add.f32 f367, f365, f362;
fma.rn.f32 f368, f346, 0f3E9E377A, f263;
mul.f32 f369, f348, 0f3F4F1BBD;
sub.f32 f370, f368, f369;
sub.f32 f371, f270, f294;
mul.f32 f372, f371, 0f3F737871;
sub.f32 f373, f278, f286;
mul.f32 f374, f373, 0fBF167918;
sub.f32 f375, f374, f372;
add.f32 f376, f375, f370;
sub.f32 f377, f370, f375;
mul.f32 f378, f346, 0f3F4F1BBD;
sub.f32 f379, f263, f378;
fma.rn.f32 f380, f348, 0f3E9E377A, f379;
mul.f32 f381, f371, 0f3F167918;
mul.f32 f382, f373, 0f3F737871;
sub.f32 f383, f382, f381;
add.f32 f384, f383, f380;
sub.f32 f385, f380, f383;
mul.f32 f386, f358, 0f3F4F1BBD;
mul.f32 f387, f376, 0fBF167918;
sub.f32 f388, f386, f387;
mul.f32 f389, f376, 0f3F4F1BBD;
fma.rn.f32 f390, f358, 0fBF167918, f389;
mul.f32 f391, f366, 0f3E9E377A;
mul.f32 f392, f384, 0fBF737871;
sub.f32 f393, f391, f392;
mul.f32 f394, f384, 0f3E9E377A;
fma.rn.f32 f395, f366, 0fBF737871, f394;
mul.f32 f396, f367, 0fBE9E377A;
mul.f32 f397, f385, 0fBF737871;
sub.f32 f398, f396, f397;
mul.f32 f399, f385, 0fBE9E377A;
fma.rn.f32 f400, f367, 0fBF737871, f399;
mul.f32 f401, f359, 0fBF4F1BBD;
mul.f32 f402, f377, 0fBF167918;
sub.f32 f403, f401, f402;
mul.f32 f404, f377, 0fBF4F1BBD;
fma.rn.f32 f405, f359, 0fBF167918, f404;
add.f32 %1, f305, f349;
add.f32 %0, f301, f345;
add.f32 %3, f332, f390;
add.f32 %2, f314, f388;
add.f32 %5, f340, f395;
add.f32 %4, f322, f393;
add.f32 %7, f341, f400;
add.f32 %6, f323, f398;
add.f32 %9, f333, f405;
add.f32 %8, f315, f403;
sub.f32 %11, f305, f349;
sub.f32 %10, f301, f345;
sub.f32 %13, f332, f390;
sub.f32 %12, f314, f388;
sub.f32 %15, f340, f395;
sub.f32 %14, f322, f393;
sub.f32 %17, f341, f400;
sub.f32 %16, f323, f398;
sub.f32 %19, f333, f405;
sub.f32 %18, f315, f403;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y): "r"(smem), "l"(lut_sp_10_100), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<191, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<406>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %20;
mad.lo.s32 r3, r1, 400, r2;
mov.u32 r4, %tid.x;
add.f32 f41, %27, %43;
add.f32 f42, %22, f41;
add.f32 f43, %32, %38;
add.f32 f44, f43, f42;
add.f32 f45, %29, %45;
add.f32 f46, %23, f45;
add.f32 f47, %34, %39;
add.f32 f48, f47, f46;
fma.rn.f32 f49, f41, 0f3E9E377A, %22;
mul.f32 f50, f43, 0f3F4F1BBD;
sub.f32 f51, f49, f50;
sub.f32 f52, %29, %45;
mul.f32 f53, f52, 0f3F737871;
sub.f32 f54, %34, %39;
mul.f32 f55, f54, 0fBF167918;
sub.f32 f56, f55, f53;
sub.f32 f57, f51, f56;
add.f32 f58, f56, f51;
mul.f32 f59, f41, 0f3F4F1BBD;
sub.f32 f60, %22, f59;
fma.rn.f32 f61, f43, 0f3E9E377A, f60;
mul.f32 f62, f52, 0f3F167918;
mul.f32 f63, f54, 0f3F737871;
sub.f32 f64, f63, f62;
sub.f32 f65, f61, f64;
add.f32 f66, f64, f61;
fma.rn.f32 f67, f45, 0f3E9E377A, %23;
mul.f32 f68, f47, 0f3F4F1BBD;
sub.f32 f69, f67, f68;
sub.f32 f70, %27, %43;
mul.f32 f71, f70, 0f3F737871;
sub.f32 f72, %32, %38;
mul.f32 f73, f72, 0fBF167918;
sub.f32 f74, f73, f71;
add.f32 f75, f74, f69;
sub.f32 f76, f69, f74;
mul.f32 f77, f45, 0f3F4F1BBD;
sub.f32 f78, %23, f77;
fma.rn.f32 f79, f47, 0f3E9E377A, f78;
mul.f32 f80, f70, 0f3F167918;
mul.f32 f81, f72, 0f3F737871;
sub.f32 f82, f81, f80;
add.f32 f83, f82, f79;
sub.f32 f84, f79, f82;
add.f32 f85, %30, %46;
add.f32 f86, %24, f85;
add.f32 f87, %35, %40;
add.f32 f88, f87, f86;
add.f32 f89, %31, %47;
add.f32 f90, %26, f89;
add.f32 f91, %37, %42;
add.f32 f92, f91, f90;
fma.rn.f32 f93, f85, 0f3E9E377A, %24;
mul.f32 f94, f87, 0f3F4F1BBD;
sub.f32 f95, f93, f94;
sub.f32 f96, %31, %47;
mul.f32 f97, f96, 0f3F737871;
sub.f32 f98, %37, %42;
mul.f32 f99, f98, 0fBF167918;
sub.f32 f100, f99, f97;
sub.f32 f101, f95, f100;
add.f32 f102, f100, f95;
mul.f32 f103, f85, 0f3F4F1BBD;
sub.f32 f104, %24, f103;
fma.rn.f32 f105, f87, 0f3E9E377A, f104;
mul.f32 f106, f96, 0f3F167918;
mul.f32 f107, f98, 0f3F737871;
sub.f32 f108, f107, f106;
sub.f32 f109, f105, f108;
add.f32 f110, f108, f105;
fma.rn.f32 f111, f89, 0f3E9E377A, %26;
mul.f32 f112, f91, 0f3F4F1BBD;
sub.f32 f113, f111, f112;
sub.f32 f114, %30, %46;
mul.f32 f115, f114, 0f3F737871;
sub.f32 f116, %35, %40;
mul.f32 f117, f116, 0fBF167918;
sub.f32 f118, f117, f115;
add.f32 f119, f118, f113;
sub.f32 f120, f113, f118;
mul.f32 f121, f89, 0f3F4F1BBD;
sub.f32 f122, %26, f121;
fma.rn.f32 f123, f91, 0f3E9E377A, f122;
mul.f32 f124, f114, 0f3F167918;
mul.f32 f125, f116, 0f3F737871;
sub.f32 f126, f125, f124;
add.f32 f127, f126, f123;
sub.f32 f128, f123, f126;
mul.f32 f129, f101, 0f3F4F1BBD;
mul.f32 f130, f119, 0fBF167918;
sub.f32 f131, f129, f130;
mul.f32 f132, f119, 0f3F4F1BBD;
fma.rn.f32 f133, f101, 0fBF167918, f132;
mul.f32 f134, f109, 0f3E9E377A;
mul.f32 f135, f127, 0fBF737871;
sub.f32 f136, f134, f135;
mul.f32 f137, f127, 0f3E9E377A;
fma.rn.f32 f138, f109, 0fBF737871, f137;
mul.f32 f139, f110, 0fBE9E377A;
mul.f32 f140, f128, 0fBF737871;
sub.f32 f141, f139, f140;
mul.f32 f142, f128, 0fBE9E377A;
fma.rn.f32 f143, f110, 0fBF737871, f142;
mul.f32 f144, f102, 0fBF4F1BBD;
mul.f32 f145, f120, 0fBF167918;
sub.f32 f146, f144, f145;
mul.f32 f147, f120, 0fBF4F1BBD;
fma.rn.f32 f148, f102, 0fBF167918, f147;
add.f32 f149, f44, f88;
add.f32 f150, f48, f92;
sub.f32 f151, f44, f88;
sub.f32 f152, f48, f92;
add.f32 f153, f57, f131;
add.f32 f154, f75, f133;
sub.f32 f155, f57, f131;
sub.f32 f156, f75, f133;
add.f32 f157, f65, f136;
add.f32 f158, f83, f138;
sub.f32 f159, f65, f136;
sub.f32 f160, f83, f138;
add.f32 f161, f66, f141;
add.f32 f162, f84, f143;
sub.f32 f163, f66, f141;
sub.f32 f164, f84, f143;
add.f32 f165, f58, f146;
add.f32 f166, f76, f148;
sub.f32 f167, f58, f146;
sub.f32 f168, f76, f148;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 10;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %21;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f169, f170}, [rd6];
mul.f32 f173, f169, f153;
mul.f32 f174, f170, f154;
sub.f32 f175, f173, f174;
mul.f32 f176, f169, f154;
fma.rn.f32 f177, f170, f153, f176;
mul.f32 f178, f169, f169;
mul.f32 f179, f170, f170;
sub.f32 f180, f178, f179;
mul.f32 f181, f170, f169;
fma.rn.f32 f182, f170, f169, f181;
mul.f32 f183, f180, f157;
mul.f32 f184, f182, f158;
sub.f32 f185, f183, f184;
mul.f32 f186, f180, f158;
fma.rn.f32 f187, f182, f157, f186;
mul.f32 f188, f169, f180;
mul.f32 f189, f170, f182;
sub.f32 f190, f188, f189;
mul.f32 f191, f169, f182;
fma.rn.f32 f192, f170, f180, f191;
mul.f32 f193, f190, f161;
mul.f32 f194, f192, f162;
sub.f32 f195, f193, f194;
mul.f32 f196, f190, f162;
fma.rn.f32 f197, f192, f161, f196;
mul.f32 f198, f169, f190;
mul.f32 f199, f170, f192;
sub.f32 f200, f198, f199;
mul.f32 f201, f169, f192;
fma.rn.f32 f202, f170, f190, f201;
mul.f32 f203, f200, f165;
mul.f32 f204, f202, f166;
sub.f32 f205, f203, f204;
mul.f32 f206, f200, f166;
fma.rn.f32 f207, f202, f165, f206;
mul.f32 f208, f169, f200;
mul.f32 f209, f170, f202;
sub.f32 f210, f208, f209;
mul.f32 f211, f169, f202;
fma.rn.f32 f212, f170, f200, f211;
mul.f32 f213, f210, f151;
mul.f32 f214, f212, f152;
sub.f32 f215, f213, f214;
mul.f32 f216, f210, f152;
fma.rn.f32 f217, f212, f151, f216;
mul.f32 f218, f169, f210;
mul.f32 f219, f170, f212;
sub.f32 f220, f218, f219;
mul.f32 f221, f169, f212;
fma.rn.f32 f222, f170, f210, f221;
mul.f32 f223, f220, f155;
mul.f32 f224, f222, f156;
sub.f32 f225, f223, f224;
mul.f32 f226, f220, f156;
fma.rn.f32 f227, f222, f155, f226;
mul.f32 f228, f169, f220;
mul.f32 f229, f170, f222;
sub.f32 f230, f228, f229;
mul.f32 f231, f169, f222;
fma.rn.f32 f232, f170, f220, f231;
mul.f32 f233, f230, f159;
mul.f32 f234, f232, f160;
sub.f32 f235, f233, f234;
mul.f32 f236, f230, f160;
fma.rn.f32 f237, f232, f159, f236;
mul.f32 f238, f169, f230;
mul.f32 f239, f170, f232;
sub.f32 f240, f238, f239;
mul.f32 f241, f169, f232;
fma.rn.f32 f242, f170, f230, f241;
mul.f32 f243, f240, f163;
mul.f32 f244, f242, f164;
sub.f32 f245, f243, f244;
mul.f32 f246, f240, f164;
fma.rn.f32 f247, f242, f163, f246;
mul.f32 f248, f169, f240;
mul.f32 f249, f170, f242;
sub.f32 f250, f248, f249;
mul.f32 f251, f169, f242;
fma.rn.f32 f252, f170, f240, f251;
mul.f32 f253, f250, f167;
mul.f32 f254, f252, f168;
sub.f32 f255, f253, f254;
mul.f32 f256, f250, f168;
fma.rn.f32 f257, f252, f167, f256;
mad.lo.s32 r8, r5, 400, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
st.shared.v2.f32 [r9], {f149, f175};
st.shared.v2.f32 [r9+8], {f185, f195};
st.shared.v2.f32 [r9+16], {f205, f215};
st.shared.v2.f32 [r9+24], {f225, f235};
st.shared.v2.f32 [r9+32], {f245, f255};
barrier.sync 0;
mad.lo.s32 r10, r7, -36, r9;
ld.shared.f32 f258, [r10];
ld.shared.f32 f259, [r10+40];
ld.shared.f32 f260, [r10+80];
ld.shared.f32 f261, [r10+120];
ld.shared.f32 f262, [r10+160];
ld.shared.f32 f263, [r10+200];
ld.shared.f32 f264, [r10+240];
ld.shared.f32 f265, [r10+280];
ld.shared.f32 f266, [r10+320];
ld.shared.f32 f267, [r10+360];
barrier.sync 0;
st.shared.v2.f32 [r9], {f150, f177};
st.shared.v2.f32 [r9+8], {f187, f197};
st.shared.v2.f32 [r9+16], {f207, f217};
st.shared.v2.f32 [r9+24], {f227, f237};
st.shared.v2.f32 [r9+32], {f247, f257};
barrier.sync 0;
ld.shared.f32 f268, [r10];
ld.shared.f32 f269, [r10+40];
ld.shared.f32 f270, [r10+80];
ld.shared.f32 f271, [r10+120];
ld.shared.f32 f272, [r10+160];
ld.shared.f32 f273, [r10+200];
ld.shared.f32 f274, [r10+240];
ld.shared.f32 f275, [r10+280];
ld.shared.f32 f276, [r10+320];
ld.shared.f32 f277, [r10+360];
add.f32 f278, f260, f266;
add.f32 f279, f258, f278;
add.f32 f280, f262, f264;
add.f32 f281, f280, f279;
add.f32 f282, f270, f276;
add.f32 f283, f268, f282;
add.f32 f284, f272, f274;
add.f32 f285, f284, f283;
fma.rn.f32 f286, f278, 0f3E9E377A, f258;
mul.f32 f287, f280, 0f3F4F1BBD;
sub.f32 f288, f286, f287;
sub.f32 f289, f270, f276;
mul.f32 f290, f289, 0f3F737871;
sub.f32 f291, f272, f274;
mul.f32 f292, f291, 0fBF167918;
sub.f32 f293, f292, f290;
sub.f32 f294, f288, f293;
add.f32 f295, f293, f288;
mul.f32 f296, f278, 0f3F4F1BBD;
sub.f32 f297, f258, f296;
fma.rn.f32 f298, f280, 0f3E9E377A, f297;
mul.f32 f299, f289, 0f3F167918;
mul.f32 f300, f291, 0f3F737871;
sub.f32 f301, f300, f299;
sub.f32 f302, f298, f301;
add.f32 f303, f301, f298;
fma.rn.f32 f304, f282, 0f3E9E377A, f268;
mul.f32 f305, f284, 0f3F4F1BBD;
sub.f32 f306, f304, f305;
sub.f32 f307, f260, f266;
mul.f32 f308, f307, 0f3F737871;
sub.f32 f309, f262, f264;
mul.f32 f310, f309, 0fBF167918;
sub.f32 f311, f310, f308;
add.f32 f312, f311, f306;
sub.f32 f313, f306, f311;
mul.f32 f314, f282, 0f3F4F1BBD;
sub.f32 f315, f268, f314;
fma.rn.f32 f316, f284, 0f3E9E377A, f315;
mul.f32 f317, f307, 0f3F167918;
mul.f32 f318, f309, 0f3F737871;
sub.f32 f319, f318, f317;
add.f32 f320, f319, f316;
sub.f32 f321, f316, f319;
add.f32 f322, f261, f267;
add.f32 f323, f259, f322;
add.f32 f324, f263, f265;
add.f32 f325, f324, f323;
add.f32 f326, f271, f277;
add.f32 f327, f269, f326;
add.f32 f328, f273, f275;
add.f32 f329, f328, f327;
fma.rn.f32 f330, f322, 0f3E9E377A, f259;
mul.f32 f331, f324, 0f3F4F1BBD;
sub.f32 f332, f330, f331;
sub.f32 f333, f271, f277;
mul.f32 f334, f333, 0f3F737871;
sub.f32 f335, f273, f275;
mul.f32 f336, f335, 0fBF167918;
sub.f32 f337, f336, f334;
sub.f32 f338, f332, f337;
add.f32 f339, f337, f332;
mul.f32 f340, f322, 0f3F4F1BBD;
sub.f32 f341, f259, f340;
fma.rn.f32 f342, f324, 0f3E9E377A, f341;
mul.f32 f343, f333, 0f3F167918;
mul.f32 f344, f335, 0f3F737871;
sub.f32 f345, f344, f343;
sub.f32 f346, f342, f345;
add.f32 f347, f345, f342;
fma.rn.f32 f348, f326, 0f3E9E377A, f269;
mul.f32 f349, f328, 0f3F4F1BBD;
sub.f32 f350, f348, f349;
sub.f32 f351, f261, f267;
mul.f32 f352, f351, 0f3F737871;
sub.f32 f353, f263, f265;
mul.f32 f354, f353, 0fBF167918;
sub.f32 f355, f354, f352;
add.f32 f356, f355, f350;
sub.f32 f357, f350, f355;
mul.f32 f358, f326, 0f3F4F1BBD;
sub.f32 f359, f269, f358;
fma.rn.f32 f360, f328, 0f3E9E377A, f359;
mul.f32 f361, f351, 0f3F167918;
mul.f32 f362, f353, 0f3F737871;
sub.f32 f363, f362, f361;
add.f32 f364, f363, f360;
sub.f32 f365, f360, f363;
mul.f32 f366, f338, 0f3F4F1BBD;
mul.f32 f367, f356, 0fBF167918;
sub.f32 f368, f366, f367;
mul.f32 f369, f356, 0f3F4F1BBD;
fma.rn.f32 f370, f338, 0fBF167918, f369;
mul.f32 f371, f346, 0f3E9E377A;
mul.f32 f372, f364, 0fBF737871;
sub.f32 f373, f371, f372;
mul.f32 f374, f364, 0f3E9E377A;
fma.rn.f32 f375, f346, 0fBF737871, f374;
mul.f32 f376, f347, 0fBE9E377A;
mul.f32 f377, f365, 0fBF737871;
sub.f32 f378, f376, f377;
mul.f32 f379, f365, 0fBE9E377A;
fma.rn.f32 f380, f347, 0fBF737871, f379;
mul.f32 f381, f339, 0fBF4F1BBD;
mul.f32 f382, f357, 0fBF167918;
sub.f32 f383, f381, f382;
mul.f32 f384, f357, 0fBF4F1BBD;
fma.rn.f32 f385, f339, 0fBF167918, f384;
add.f32 %0, f281, f325;
add.f32 %1, f285, f329;
add.f32 %3, f312, f370;
add.f32 %2, f294, f368;
add.f32 %5, f320, f375;
add.f32 %4, f302, f373;
add.f32 %7, f321, f380;
add.f32 %6, f303, f378;
add.f32 %9, f313, f385;
add.f32 %8, f295, f383;
sub.f32 %10, f281, f325;
sub.f32 %11, f285, f329;
sub.f32 %13, f312, f370;
sub.f32 %12, f294, f368;
sub.f32 %15, f320, f375;
sub.f32 %14, f302, f373;
sub.f32 %17, f321, f380;
sub.f32 %16, f303, f378;
sub.f32 %19, f313, f385;
sub.f32 %18, f295, f383;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y): "r"(smem), "l"(lut_sp_10_100), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y));
};


#endif
