use tqdm::Iter;
mod mdp;
use mdp::MDP;

fn main() {
    let mut model = MDP::new_tabular(5, 2);
    model.set_kernel(0, 0, & vec![1.0, 0.0, 0.0, 0.0, 0.0]);
    model.set_reward(0, 0, 0.5);
    let mut hist : Vec<(usize, f64)>= Vec::new();
    let mut x = 0;
    let a     = 0;
    for _ in (0..100000).tqdm() {
        let (r, y) = model.sample(x, a);
        hist.push((x, r));
        x = y;
    }
    println!("Hello world!");
}
