# README

This is the supplement code for the paper "Computationally Efficient Minimax Optimal Regret in Average-Reward MDPs".
The library has an accelerated core written in Rust dedicated to MDP specific operations.
THe remaining of the code is written in Python with a few bindings to the Rust library.

### Compiling the Rust library

- To compile the core, you will need the Rust compiler `cargo`.
- Once `cargo` is installed on your system, go to `rlib/` and compile it with `cargo build`.
- It should compile fine, with `cargo` complaining that a few functions should be named differently. Ignore it.

### To generate the figure of the paper

- Make sure the Rust library is compiled.
- Make sure you have the Python libraries `numpy`, `scipy` and `matplotlib` on your system.
- Go to `py/`. Run `python3 examples/fig2a.py` to generate the first half of Figure 2. Depending on the speed of your CPU, it may take between 20-60 minutes.
- Go to `py/`. Run `python3 examples/fig2b.py` to generate the second half of Figure 2. Depending on the speed of your CPU, it may take 10-30 minutes.

There are extra algorithms that you can play with in the code (`py/learners/evi.py`, check the prefabs).

Enjoy!
