import os, sys
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
import numpy as np

import mdp

def RiverSwim(S):
    model = mdp.MDP(S, 2)
    left  = 0
    right = 1

    # special transitions
    kernel_0_left  = [1.0]      + [0.0 for x in range(1, S)]
    kernel_0_right = [0.6, 0.4] + [0.0 for x in range(2, S)]
    kernel_S_right = [0.0 for x in range(S-2)] + [0.05, 0.95]
    model.set_kernel(  0,  left, kernel_0_left)
    model.set_kernel(  0, right, kernel_0_right)
    model.set_kernel(S-1, right, kernel_S_right)
    # generic left transitions
    for x in range(1, S):
        kernel_x_left = [int(y == x-1) for y in range(S)]
        model.set_kernel(x, left, kernel_x_left)
    # generic right transitions
    for x in range(1, S-1):
        kernel_x_right = [0.0 for y in range(S)]
        kernel_x_right[x-1] = 0.05
        kernel_x_right[x  ] = 0.60
        kernel_x_right[x+1] = 0.35
        model.set_kernel(x, right, kernel_x_right)

    # rewards
    for x in range(S):
        model.set_reward(x,  left, 0)
        model.set_reward(x, right, 0)
    model.set_reward(  0,  left, 0.05)
    model.set_reward(S-1, right, 0.95)
    
    # Done.
    return model

if __name__ == "__main__":
    model = RiverSwim(5)
    print(model)


