# Combine all the results for Original SEV into a single table
import pandas as pd

# read the table
df = pd.read_csv("../Results/csv/Exp1_original_summary_final_new.csv")

df_mean = df.groupby(["Dataset","Model"]).mean().round(2)
del df_mean["Iteration"]
df_std = df.groupby(["Dataset","Model"]).std().round(2)
del df_std["Iteration"]
df_std.columns = [i+"_std" for i in df_std.columns]

# for the one with the same column name make it mean+/-std in the same block
df_final = df_mean.copy()
# remove all the elements in df_final
df_final.iloc[:,:] = ""
for i in df_mean.index:
    for j in df_mean.columns:
        df_final.loc[i,j] = "$" + str(df_mean.loc[i,j])+"\\pm"+str(df_std.loc[i,j+"_std"])+ "$"

print(df_final.to_latex(escape=False))
# df_final.to_csv("../Results/csv/Exp1_original_summary_latex.csv")