import os
import shutil
from PIL import Image
from crop_subimg import crop_sub_image

# Call the function with CLI arguments
if __name__ == '__main__':
    import sys
    if len(sys.argv) not in [2, 3, 4, 5]:
        print("Usage: python crop_subimg.py <root_path> <iteration> <image1_index> <image2_index> ")
        exit()
    
    root_path = sys.argv[1]
    
    iteration = 9000
    if len(sys.argv) > 2:
        iteration = int(sys.argv[2])
    iteration_path = os.path.join(root_path, "save", f"it{iteration}-test")
    
    image1_index = 3
    if len(sys.argv) > 3:
        image1_index = int(sys.argv[3])
    image1_path = os.path.join(iteration_path, f"{image1_index}.png")
        
    image2_index = 28
    if len(sys.argv) > 4:
        image2_index = int(sys.argv[4])
    image2_path = os.path.join(iteration_path, f"{image2_index}.png")
    
    # clean the report_imgs directory
    shutil.rmtree("report_imgs", ignore_errors=True)
    os.makedirs("report_imgs", exist_ok=True)
    
    video_name = os.path.basename(root_path).split('@')[0]
    video_path = os.path.join(root_path, "save", f"it{iteration}-test.mp4")
    shutil.copy(video_path, f"report_imgs/{video_name}.mp4")
    
    # save the name of the video. Replace '_' with ' '
    with open("report_imgs/prompt.txt", "w") as f:
        f.write(video_name.replace("_", " "))
    
    crop_sub_image(image1_path, 0, 2, f"report_imgs/output_front.png")
    crop_sub_image(image1_path, 1, 2, f"report_imgs/output_front_geo.png")
    crop_sub_image(image2_path, 0, 2, f"report_imgs/output_back.png")
    
    for i, img_idx in enumerate([30, 40, 0, 8, 20]):
        img_path = os.path.join(iteration_path, f"{img_idx}.png")
        crop_sub_image(img_path, 0, 2, f"report_imgs/output_{i}.png")
        crop_sub_image(img_path, 1, 2, f"report_imgs/output_geo_{i}.png")
    
    
    # zip the directory
    shutil.make_archive("report_imgs", 'zip', "report_imgs")
    print("Saved arxive to report_imgs.zip")
        
    
