#!/bin/bash

# Define the root directory as a hyperparameter
root="/mnt/XXXX-2/playground/SDS/thirdparty/threestudio/outputs/full_runs/20240516_110912_OnlyTextureOrigPrompts/ours-inversion"

# Define the HF_HOME environment variable
export HF_HOME="/mnt/XXXX-2/data/HugginFacesCache"

# Iterate over the iteration numbers from 7000 to 10000, stepping by 500
for iteration in $(seq 7000 500 10000); do
    # Define the output file path, one directory up from root
    output_file="${root%/*}/_scores_${iteration}_pa.txt"
    
    # Execute the Python script and save the output to the file while also streaming to stdout
    python calculate_clipscore.py --root_folder "${root}" --iteration "${iteration}" | tee "${output_file}"
done