import torch
import torch.nn as nn
import torch.nn.functional as F


class L1ExpLoss(nn.Module):
    @staticmethod
    def forward(pred, target, reduction="mean"):
        delta = (pred - target).abs()
        l1_loss = F.l1_loss(pred, target, reduction="none")
        exp_loss = 1 - torch.exp(-delta)
        # if delta > 1 use exponential loss and mse otherwise
        # exp loss is rescaled such that if delta == 1 -> lr == exp
        loss = torch.where(delta > 1, 1.5819767713546753 * exp_loss, l1_loss)
        if reduction == "mean":
            return loss.mean()
        elif reduction == "none":
            return loss
        raise NotImplementedError
