#!/bin/bash




DATA=$1
OUTPUT=$2
METHOD=$3

echo "Running cascade on data ${DATA} with output ${OUTPUT}"




rm $OUTPUT
rm "${OUTPUT}.log"
# Save current time to a variable
start_time=$(date +%s)
python -m other_methods.gCastlePC.main -method $METHOD -alarms $DATA -output $OUTPUT -time-win-size "100" 2>&1 | tee "${OUTPUT}.log"
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
echo $elapsed_time > "${OUTPUT}_elapsed_time.txt"


