from datasets import Maze2dOfflineRLDataset, Diagonal2dOfflineRLDataset
from algorithms.diffusion_forcing import DiffusionForcingPlanning
from .exp_base import BaseLightningExperiment


class POMDPExperiment(BaseLightningExperiment):
    """
    A Partially Observed Markov Decision Process experiment
    """

    compatible_algorithms = dict(
        df_planning=DiffusionForcingPlanning,
    )

    compatible_datasets = dict(
        # Planning datasets
        maze2d_umaze=Maze2dOfflineRLDataset,
        maze2d_medium=Maze2dOfflineRLDataset,
        maze2d_large=Maze2dOfflineRLDataset,
        maze2d_umaze_dense=Maze2dOfflineRLDataset,
        maze2d_medium_dense=Maze2dOfflineRLDataset,
        maze2d_large_dense=Maze2dOfflineRLDataset,
        diagonal2d=Diagonal2dOfflineRLDataset,
    )
