import numpy as np
from scipy.stats import uniform
from comab.environment import greedy_allocation

### TEST greedy_allocation(.) using uniform distribution ###
N = 8
K = 3
p = np.arange(K, dtype=int)+1
P = K
F = [uniform(scale=(k+1)) for k in range(K)]
R = np.zeros((K, N+P))
for k in range(K):
  for n in range(N+P):
    ub = k+1
    R[k,n] = (k+1) * (1.0/(n+1) - 1.0/(n+2))

n_opt = np.array([1,3,3])
n_computed = greedy_allocation(R, p, N)
np.testing.assert_array_equal(n_opt, n_computed)
# This test is unstable as equality cases creates numerical issues.