import numpy as np


def neighborhood(n, p, N):
    lower_bound = np.ceil(np.maximum(np.minimum((n - p) / 2, n-1), 1)).astype(int)
    upper_bound = np.floor(np.minimum(np.maximum(3 * (n+p-1)/2 - p, n+1), N)).astype(int)
    return lower_bound, upper_bound


def grid(N, p):
    assert isinstance(p, int) or len(np.array(p)) == 1
    grid = [1]

    lb, ub = neighborhood(np.arange(N + 1), p, N)
    s = 1
    while s < N:
        s = np.max(np.nonzero((np.arange(N + 1) <= ub[s]) & (np.arange(N + 1) >= lb[s]) & (lb <= s) & (s <= ub)))
        if s < N:
            grid.append(s)
    return np.array(grid)


def v_lr(S, n, N):
    if n == 0:
        return 1,1
    _S_r = np.concatenate([S, [N]])
    v_l = S[np.max(np.nonzero(n >= S))]
    v_r = _S_r[np.min(np.nonzero(n <= _S_r))]
    return v_l, v_r


def v_lr_all(S, N):
    v_l = np.zeros(N + 1, dtype=int)
    v_r = np.zeros(N + 1, dtype=int)
    for n in range(N + 1):
        v_l[n], v_r[n] = v_lr(S, n, N)
    return v_l, v_r


def B_mask(v_l, N, S):
    mask = np.zeros((N + 1, N + 1), dtype=bool)
    for n in range(N + 1):
        for k in range(N + 1):
            mask[n, k] = (v_l[k] == v_l[n]) and (k not in S)
    mask[0, :] = False
    mask[:, 0] = False
    return mask