from comab.algo.baselines import Greedy
from comab.algo.exp3 import EXP3
from comab.algo.greedy_grid import GreedyGrid
from comab.algo.local_greedy import LocalGreedy
from comab.algo.osub import OSUB
from comab.algo.ucb1 import UCB1
from comab.reward_estimator.fixed_grid_estimator import WithFixedGridEstimation, WithFixedGridEstimationK


def build_algo(algo_name, K, N, T, p, **kwargs):
    match algo_name:
        case "greedy": return Greedy(K, N, p, WithFixedGridEstimation(K, N, p, **kwargs))
        case "local_greedy": return LocalGreedy(K, N, p, WithFixedGridEstimationK(K, N, p, **kwargs))
        case "osub": return OSUB(K, N, p, **kwargs)
        case "exp3": return EXP3(K, N, p, **kwargs)
        case "ucb1": return UCB1(K, N, p, **kwargs)
        case "greedy_grid": return GreedyGrid(K, N, p, T, **kwargs)
        case _: raise NotImplementedError("This algorithm does not exists: "+algo_name)