import importlib.util

def make_env(args):
    # Load the scenario from the script specified in args.maze_name
    maze_module_path = args.maze_name  # Assuming args.maze_name contains the module path
    spec = importlib.util.spec_from_file_location("Maze", maze_module_path)
    maze_module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(maze_module)

    # Assuming the maze class is named Maze within the loaded module
    env = maze_module.Maze()

    # Other initialization code can go here if needed

    return env, args
