import numpy as np
import matplotlib.pyplot as plt

def sech(x):
    return np.divide(2*np.exp(x), np.exp(2*x)+1)

def Tanh(Z):
    return np.tanh(Z)

def dTanh(Z):
    return sech(Z)**2

def Relu(Z):
    return np.maximum(0,Z)

def smoothAbs(Z, delta):
    return delta*(np.sqrt(Z**2/delta**2+1)-1)



x = np.linspace(-0.1, 0.1, 100)
y0 = Relu(x)
y1 = (smoothAbs(x, 0.01)+x)/2
y2 = (smoothAbs(x, 0.05)+x)/2
y3 = (smoothAbs(x, 0.1)+x)/2

plt.plot(x, y0, label="Relu", c="navy")
plt.plot(x, y1, label="smoothRelu, delta=0.01", c="royalblue")
plt.plot(x, y2, label="smoothRelu, delta=0.05", c="cornflowerblue")
plt.plot(x, y3, label="smoothRelu, delta=0.1", c="lightsteelblue")
plt.grid()
plt.legend()
plt.savefig("test.png")