clc;


for ww = 1:20

d = 1000;
k = 8;
m = 10;
N = 600;
n = N/m;
mag = 1;

sigma = 0.5;

% generate data
x_star = zeros(d,1);
indexs = randperm(d);

curr_index_starp = indexs(1:ceil(k/2));
x_star(curr_index_starp) = mag;
curr_index_starn = indexs(ceil(k/2)+1:k);
x_star(curr_index_starn) = -mag;

% x_star(indexs(k)) = 100;

curr_index_starc = indexs(k+1:d);

X = randn(N,d);
noise = sigma*randn(N,1);
Y = X*x_star + noise;

% uniform
for i = 1:m
    Xs{i} = X((i-1)*n+1:i*n,:);
    Ys{i} = Y((i-1)*n+1:i*n,:);
    noises{i} = noise((i-1)*n+1:i*n,:);
end



p = 0.95;
[W,rho] = generate_network(m,p);

spec = norm( W - 1/m*ones(m));

% run DGD
alpha = 1e-6;
alphas = alpha.*ones(d,m);
eta = 1*1e-1;
Maxiter = 300;

%[errs1{j},errs2{j},c_err1{j},comerr1{j}] = DGD_solver3(Xs,Ys,alpha,eta,Maxiter,x_star,m,W,curr_index_starc);
[w,w_errs2, errs,comerr,ws,us,vs] = GD_solver(X,Y,alpha,eta*1.75,Maxiter,x_star,curr_index_starc,indexs(1:k));
[w_errs1,errs3,errs4,c_err2,comerr2,~,~,~,wss,uss,vss] = DGD_solver1(Xs,Ys,alphas,eta*1,Maxiter,x_star,m,W,curr_index_starc,indexs(1:k));
[w_errs2,errs5,errs4,c_err2,comerr2,~,~,~,wss,uss,vss] = Trun_DGD_solver1(Xs,Ys,alphas,eta*1,Maxiter,x_star,m,W,curr_index_starc,indexs(1:k));


figure(ww)
plot(log(errs))
hold on
plot(log(errs3))
hold on
plot(log(errs5))


% figure(2)
% plot(log(w_errs1))
% hold on
% plot(log(w_errs2))



xlabel('Iteration', 'FontName', 'Arial', 'FontSize', 25, 'Interpreter', 'latex');
ylabel('$log(\|\overline{ w}^t -  w^{\star}\|^2)$', 'FontName', 'Arial', 'FontSize', 25, 'Interpreter', 'latex');

grid on

leg = legend({'$GD$','$DGD$','T-DGD'},'Interpreter', 'latex');
set(leg, 'Interpreter', 'latex', 'FontSize', 20, 'FontName', 'Times New Roman');


% title('$d = 1e3, s=10, N=200, m=20,\rho = 0.8927$', 'FontName', 'Arial', 'FontSize', 20, 'Interpreter', 'latex');



end