function [W,rho] = generate_network(I,p)



%%%%%%%%%%%%% network %%%%%%%%%%%

while true
    pErdosRenyi = p;
    p_data_gen = pErdosRenyi;
    
    Adj = rand(I) < p_data_gen;
    Adj = triu(Adj, 1);
    Adj = Adj + Adj';
    
    
    I_NN = eye(I);
    
    testAdj = (I_NN+Adj)^I; % check if G is connected
    
    if ~any(any(~testAdj))
        fprintf('The ER graph is connected\n');
        break;
    else
        % fprintf('The graph is disconnected\n');
    end
end

%%%% MH weight %%%%
degree=diag(sum(Adj));  %Degree matrix
A = zeros(I);
for i=1:I
    i_link=find(Adj(i,:)>0);
    for j=1:I
        if i~=j && sum(find(j==i_link))>0
            A(i,j)=1/(max(degree(i,i),degree(j,j))+1);
        end
    end
end
W=eye(I)-diag(sum(A))+A; %Weight matrix
W = W;
rho = norm( W - 1/I*ones(I,1)*ones(1,I),2);
