function [w,w_err,errs,comerr,ws,us,vs] = GD_solver(X,Y,alpha,eta,Maxiter,x_star,curr_index_starc,indexss)

[N,d] = size(X);

u = (alpha)*ones(d,1);
v = u;
w = u.^2 - v.^2;

%XX = X'*X/N;
XY = X'*Y/N;

iter  = 1;

while iter<Maxiter
   
    pre_u = u;
    pre_v = v;
    pre_w = pre_u.^2 - pre_v.^2;

    temp = X*pre_w;
    pre_grad = 4*eta*( X'*temp/N  - XY );

    u = pre_u.*(1-pre_grad);
    v = pre_v.*(1+pre_grad);
    w = u.^2 - v.^2;

    ws{iter} = w;
    us{iter} = u;
    vs{iter} = v;

    errs(iter) = norm(w-x_star,'fro')^2;
    comerr(iter) = norm(w(curr_index_starc),'inf');
    w_err(iter) = norm( w(indexss) - x_star(indexss),'inf');

    fprintf("Iter = %d, errs = %.8e\n",iter,errs(iter));

    iter = iter+1;


end