from openai import OpenAI
from model.utils import load_api_key
import os

home_directory = os.path.expanduser("~")
api_key = load_api_key(os.path.join(home_directory, "openai_api_key.txt"))
client = OpenAI(api_key=api_key)

batches = client.batches.list().data
for batch in batches:
  # if batch.status != "completed":
    # client.batches.cancel(batch.id)
  print(f"id: {batch.id}, created_at:{batch.created_at}, status: {batch.status}")
