import json
import matplotlib.pyplot as plt
import numpy as np

with open('tfcoder_results.json', 'r') as file:
    tfcoder_data = json.load(file)

with open('unguided_res.json', 'r') as file:
    unguided = json.load(file)

with open('new_gpt4o_100.json', 'r') as file:
    tfcoder_100 = json.load(file)

with open('new_gpt4o_50.json', 'r') as file:
    tfcoder_50 = json.load(file)

with open('new_gpt4o_20.json', 'r') as file:
    tfcoder_20 = json.load(file)

with open('new_gpt4o_10.json', 'r') as file:
    tfcoder_10 = json.load(file)

# Extract the times and sort them
tfcoder_times = [result['time'] for result in tfcoder_data['results'] if result['solved']]
unguided_times = [result['time'] for result in unguided['results'] if result['solved']]
res_times_100 = [result['time'] for result in tfcoder_100['results'] if result['solved']]
res_times_50 = [result['time'] for result in tfcoder_50['results'] if result['solved']]
res_times_20 = [result['time'] for result in tfcoder_20['results'] if result['solved']]
res_times_10 = [result['time'] for result in tfcoder_10['results'] if result['solved']]

# Sorting times to ensure the graph is plotted correctly
sorted_tf_times = sorted(tfcoder_times)
unguided_tf_times = sorted(unguided_times)
res_100 = sorted(res_times_100)
res_50 = sorted(res_times_50)
res_20 = sorted(res_times_20)
res_10 = sorted(res_times_10)

sorted_tf_times.append(600)
unguided_tf_times.append(600)
res_100.append(600)
res_50.append(600)
res_20.append(600)
res_10.append(600)

print(sorted_tf_times)
print(unguided_tf_times)
# Generating cumulative counts of problems solved over time
tf_cumulative_counts = np.cumsum([1 for _ in tfcoder_times])
ug_cumulative_counts = np.cumsum([1 for _ in unguided_times])
res_cumulative_counts_100 = np.cumsum([1 for _ in res_times_100])
res_cumulative_counts_50 = np.cumsum([1 for _ in res_times_50])
res_cumulative_counts_20 = np.cumsum([1 for _ in res_times_20])
res_cumulative_counts_10 = np.cumsum([1 for _ in res_times_10])

tf_cumulative_counts = np.append(tf_cumulative_counts, tf_cumulative_counts[-1])
ug_cumulative_counts = np.append(ug_cumulative_counts, ug_cumulative_counts[-1])
res_cumulative_counts_100 = np.append(res_cumulative_counts_100, res_cumulative_counts_100[-1])
res_cumulative_counts_50 = np.append(res_cumulative_counts_50, res_cumulative_counts_50[-1])
res_cumulative_counts_20 = np.append(res_cumulative_counts_20, res_cumulative_counts_20[-1])
res_cumulative_counts_10 = np.append(res_cumulative_counts_10, res_cumulative_counts_10[-1])

#plt.figure(figsize=(10, 6))
#plt.figure(figsize=(15, 7))
plt.xlim([0,604])
plt.ylim(0,80)
secs = [0] * 68
secs.append(600)
total = [1] * 68
total.append(1)

plt.plot(res_100, res_cumulative_counts_100, 'r--', linewidth=2, label='HySynth-TENSOR', markersize=4)
plt.legend(loc='best')

#plt.plot(res_50, res_cumulative_counts_50, 'm--', linewidth=2, label='HySynth-TF-50', markersize=4)
#plt.legend(loc='best')

#plt.plot(res_20, res_cumulative_counts_20, 'b--', linewidth=2, label='HySynth-TF-20', markersize=4)
#plt.legend(loc='best')

#plt.plot(res_10, res_cumulative_counts_10, 'g--', linewidth=2, label='HySynth-TF-10', markersize=4)
#plt.legend(loc='best')

plt.plot(sorted_tf_times, tf_cumulative_counts, 'c--', linewidth=2, label='TFCoder', markersize=4)
plt.legend(loc='best')

plt.plot(unguided_tf_times, ug_cumulative_counts, 'k--', linewidth=2, label='Unguided', markersize=4)
plt.legend(loc='best')
print(len(res_100), len(res_cumulative_counts_100))

plt.plot(secs, total, 'b--', linewidth=2, label='GPT4o', markersize=4)
plt.legend(loc='center right')
print(len(res_100), len(res_cumulative_counts_100))

plt.xlabel('Time (Seconds)', fontsize=12)
plt.ylabel('Cumulative Number of Problems Solved', fontsize=13)
plt.title('Number of Problems Solved Against Time', fontsize=13)
plt.savefig('plot_tfcoder_gpt4.pdf')