import csv
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.path as mpath
from collections import defaultdict
import matplotlib.pyplot as plt
import json
def postprocess(filename):
    with open(filename, 'r') as file :
        filedata = file.read()
    filedata = filedata.replace('""","""', '"",""')
    with open(filename, 'w') as file:
        file.write(filedata)

def process_benchmark_data(file_path):
    with open(file_path, 'r') as f:
        input_data = f.readlines()

    times_and_counts = []
    for line in input_data:
        if line.strip() and 'Benchmark' not in line:
            parts = line.split(',')
            if len(parts) > 2 and parts[2].strip():
                try:
                    time = float(parts[2])
                    times_and_counts.append((time, 1))
                except ValueError:
                    # If there is an issue with conversion, print the error and skip this line
                    print(f"Could not convert to float: {parts[2]}")
    times_and_counts.sort(key=lambda x: x[0])
    return times_and_counts

def process_benchmark_data(file_path):
    with open(file_path, 'r') as f:
        input_data = f.readlines()

    # Skip the header line and initialize the list for times and counts
    times_and_counts = []
    for line in input_data[1:]:  # Start from 1 to skip the header
        if line.strip():
            parts = line.split(',')
            if len(parts) > 1 and parts[1].strip():
                try:
                    time = float(parts[1])  # The time is now in the second column
                    times_and_counts.append((time, 1))
                except ValueError:
                    print(f"Could not convert to float: {parts[1]}")
    times_and_counts.sort(key=lambda x: x[0])
    return times_and_counts

def prepend_data_if_necessary(dataset):
    if dataset and dataset[0][0] > 0:
        dataset.insert(0, [0, 0])  # Ensure the plot starts at x=0

print("processing-probe-data:")
#probe_data = process_benchmark_data('probe_larger.csv')
print("processing-size-data:")
#size_data = process_benchmark_data('size_larger.csv')

#llm_10 = process_benchmark_data('pcfg_10.csv')
#llm_20 = process_benchmark_data('pcfg_20.csv')
#llm_50 = process_benchmark_data('pcfg_50.csv')
llm_100 = process_benchmark_data('pcfg_100.csv')
arga = process_benchmark_data('arga.csv')
unguided = process_benchmark_data('unguided.csv')
#llm_10.append([600,0])
#llm_20.append([600,0])
#llm_50.append([600,0])
llm_100.append([600,0])
arga.append([600,0])
unguided.append([600,0])
#prepend_data_if_necessary(llm_10)
#prepend_data_if_necessary(llm_20)
#prepend_data_if_necessary(llm_50)
prepend_data_if_necessary(llm_100)
secs = [0] * 69
secs.append(600)
print(secs)
total = [5] * 69
total.append(5)
plt.xlim([0,604])
plt.ylim(0,85)
plt.plot([x[0] for x in llm_100], np.cumsum(np.asarray([x[1] for x in llm_100])), 'r--', linewidth=2, label='HySynth-ARC', markersize = 3)
plt.legend(loc='best')
#plt.plot([x[0] for x in llm_50], np.cumsum(np.asarray([x[1] for x in llm_50])), 'm--', linewidth=2, label='HySynth-ARC-50', markersize = 3)
#plt.legend(loc='best')
#plt.plot([x[0] for x in llm_20], np.cumsum(np.asarray([x[1] for x in llm_20])), 'b--', linewidth=2, label='HySynth-ARC-20', markersize = 3)
#plt.legend(loc='best')
#plt.plot([x[0] for x in llm_10], np.cumsum(np.asarray([x[1] for x in llm_10])), 'g--', linewidth=2, label='HySynth-ARC-10', markersize = 3)
#plt.legend(loc='best')
plt.plot([x[0] for x in arga], np.cumsum(np.asarray([x[1] for x in arga])), 'c--', linewidth=2, label='ARGA', markersize = 3)
plt.legend(loc='best')
plt.plot([x[0] for x in unguided], np.cumsum(np.asarray([x[1] for x in unguided])), 'k--', linewidth=2, label='Unguided', markersize = 3)
plt.legend(loc='best')
plt.plot(secs, total, 'b--', linewidth=2, label='GPT4o', markersize = 3)
plt.legend(loc='upper left', fontsize=12)
plt.xlabel('Time (Seconds)', fontsize=12)
plt.ylabel('Cumulative Number of Problems Solved', fontsize=13)
plt.title('Number of Problems Solved Against Time', fontsize=13)
plt.savefig('arc_gpt4o.pdf')