import json
import matplotlib.pyplot as plt
import numpy as np

with open('tfcoder_results.json', 'r') as file:
    tfcoder_data = json.load(file)

with open('unguided_res.json', 'r') as file:
    unguided = json.load(file)

with open('tfcoder_gpt3_100_result.json', 'r') as file:
    tfcoder_100 = json.load(file)

with open('tfcoder_gpt3_50_result.json', 'r') as file:
    tfcoder_50 = json.load(file)

with open('tfcoder_gpt3_20_result.json', 'r') as file:
    tfcoder_20 = json.load(file)

with open('tfcoder_gpt3_10_result.json', 'r') as file:
    tfcoder_10 = json.load(file)

# Extract the times and sort them
tfcoder_times = [result['time'] for result in tfcoder_data['results'] if result['solved']]
unguided_times = [result['time'] for result in unguided['results'] if result['solved']]
res_times_100 = [result['time'] for result in tfcoder_100['results'] if result['solved']]
res_times_50 = [result['time'] for result in tfcoder_50['results'] if result['solved']]
res_times_20 = [result['time'] for result in tfcoder_20['results'] if result['solved']]
res_times_10 = [result['time'] for result in tfcoder_10['results'] if result['solved']]

# Sorting times to ensure the graph is plotted correctly
sorted_tf_times = sorted(tfcoder_times)
unguided_tf_times = sorted(unguided_times)
res_100 = sorted(res_times_100)
res_50 = sorted(res_times_50)
res_20 = sorted(res_times_20)
res_10 = sorted(res_times_10)

sorted_tf_times.append(600)
unguided_tf_times.append(600)
res_100.append(600)
res_50.append(600)
res_20.append(600)
res_10.append(600)

print(sorted_tf_times)
print(unguided_tf_times)
# Generating cumulative counts of problems solved over time
tf_cumulative_counts = np.cumsum([1 for _ in tfcoder_times])
ug_cumulative_counts = np.cumsum([1 for _ in unguided_times])
res_cumulative_counts_100 = np.cumsum([1 for _ in res_times_100])
res_cumulative_counts_50 = np.cumsum([1 for _ in res_times_50])
res_cumulative_counts_20 = np.cumsum([1 for _ in res_times_20])
res_cumulative_counts_10 = np.cumsum([1 for _ in res_times_10])

tf_cumulative_counts = np.append(tf_cumulative_counts, tf_cumulative_counts[-1])
ug_cumulative_counts = np.append(ug_cumulative_counts, ug_cumulative_counts[-1])
res_cumulative_counts_100 = np.append(res_cumulative_counts_100, res_cumulative_counts_100[-1])
res_cumulative_counts_50 = np.append(res_cumulative_counts_50, res_cumulative_counts_50[-1])
res_cumulative_counts_20 = np.append(res_cumulative_counts_20, res_cumulative_counts_20[-1])
res_cumulative_counts_10 = np.append(res_cumulative_counts_10, res_cumulative_counts_10[-1])

#plt.figure(figsize=(10, 6))
#plt.figure(figsize=(15, 7))
#plt.xlim(-4,605)
#plt.ylim(-4,80) 
plt.xlim([0,604])
plt.ylim(0,80)
secs = [0] * 68
secs.append(600)
total = [3] * 68
total.append(3)

plt.plot(res_100, res_cumulative_counts_100, 'r--', linewidth=2, label='HySynth-TENSOR-100', markersize=4)
plt.legend(loc='best')

plt.plot(res_50, res_cumulative_counts_50, 'm--', linewidth=2, label='HySynth-TENSOR-50', markersize=4)
plt.legend(loc='best')

plt.plot(res_20, res_cumulative_counts_20, 'b--', linewidth=2, label='HySynth-TENSOR-20', markersize=4)
plt.legend(loc='best')

plt.plot(res_10, res_cumulative_counts_10, 'g--', linewidth=2, label='HySynth-TENSOR-10', markersize=4)

plt.plot(sorted_tf_times, tf_cumulative_counts, 'c--', linewidth=2, label='TFCoder', markersize=4)
plt.legend(loc='best')

plt.plot(unguided_tf_times, ug_cumulative_counts, 'k--', linewidth=2, label='Unguided', markersize=4)
plt.legend(loc='best')

plt.plot(secs, total, 'y--', linewidth=2, label='GPT3.5', markersize=4)

plt.legend(loc=(0.55,0.1), fontsize=11)
plt.xlabel('Time (s)', fontsize=12)
plt.ylabel('Cumulative Number of Problems Solved', fontsize=12)
plt.title('Number of Problems Solved Against Time', fontsize=12)
plt.savefig('tfcoder_gpt3.pdf')