


import argparse
from chatbot.utils.asr_utils import set_asr_base_url, set_asr_model_name

from chatbot.utils.llm_utils import set_llm_base_url, set_llm_messages, set_llm_model_name, set_max_tokens
from chatbot.utils.realtime_asr_utils import set_realtime_asr_url
from chatbot.utils.tts_utils import set_tts_base_url


def get_args():
    parser = argparse.ArgumentParser()
    
    parser.add_argument("--llm_addr", type=str, default='')
    parser.add_argument("--llm_model_name", type=str, default='')
    parser.add_argument("--llm_max_token", type=int, default=256)
    parser.add_argument("--llm_type", type=str, default="baseline")
    
    parser.add_argument("--asr_addr", type=str, default='')
    parser.add_argument("--asr_model_name", type=str, default='')
    parser.add_argument("--stream_asr", action="store_true")
    
    parser.add_argument("--tts_addr", type=str, default='')
    parser.add_argument("--stream_tts", action="store_true")
    
    parser.add_argument("--benchmark_sample_path", type=str, default='')
    parser.add_argument("--audio_data_dir", type=str, default='')
    parser.add_argument("--record_result_path", type=str, default='')
    
    args = parser.parse_args()
    return args


def set_args(args):
    set_llm_base_url(args.llm_addr)
    set_llm_model_name(args.llm_model_name)
    set_max_tokens(args.llm_max_token)
    set_llm_messages(args.llm_type)
    
    if args.stream_asr:
        set_realtime_asr_url(args.asr_addr)
    else:
        set_asr_model_name(args.asr_model_name)
        set_asr_base_url(args.asr_addr)
    
    set_tts_base_url(args.tts_addr)


    