# -*- coding: utf-8 -*-
"""

"""
import asyncio
import contextvars
import re
import time
import typing
from functools import cache
from typing import List
import requests

import grpc


import requests
import pyaudio


TTS_BASE_URL = ""


def set_tts_base_url(tts_base_url):
    global TTS_BASE_URL
    TTS_BASE_URL = tts_base_url


def text2speech(text):
    res = requests.get(url=TTS_BASE_URL, params={"text": text})
    assert res.status_code == 200
    return res.content


def text2speech_stream(text):
    if text:
        response = requests.get(url=TTS_BASE_URL, params={"text": text}, stream=True)
        for chunk in response.iter_content(chunk_size=44000):
            if chunk:
                yield chunk


class Speaker:

    def __init__(self,
                 sample_width=2,
                 channels=1,
                 rate=24000,
                 frames_per_buffer: int = pyaudio.paFramesPerBufferUnspecified,
                 output_device_index=None):
        self.sample_width = sample_width
        self.channels = channels
        self.rate = rate
        self.output_device_index = output_device_index
        self.frames_per_buffer = frames_per_buffer
        self.open()
        

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        self.close()
        self.p.terminate()

    def play(self, audio_data):
        self.stream.write(audio_data)
        
    def open(self):
        self.p = pyaudio.PyAudio()
        self.stream = self.p.open(format=self.p.get_format_from_width(self.sample_width),
                                  channels=self.channels,
                                  rate=self.rate,
                                  output=True,
                                  output_device_index=self.output_device_index,
                                  frames_per_buffer=self.frames_per_buffer)
    
    def stop(self):
        self.stream.stop_stream()
        self.stream.close()
        self.p.terminate()
        
    def close(self):
        self.p.terminate()


if __name__ == '__main__':
    print("Begin")
    
    speech = text2speech("Hello World!")
    print(len(speech))
    speaker = Speaker()
    speaker.play(speech)
    
    print("End")
