import argparse
import os
import time
import typing
import pickle as pkl

import numpy as np

from paramrepulsor.utils import data as data_utils


def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--data", type=str, required=True)
    parser.add_argument("--reducer", type=str, required=True)
    parser.add_argument("--suffix", type=str, default="")
    parser.add_argument("--numexp", type=int, default=10,
                        help="Number of time an experiment should be performed")
    return parser.parse_args()


def main(args):
    output_base = "./eval_outputs"
    output_dir = os.path.join(output_base, f"{args.reducer}{args.suffix}")
    os.makedirs(output_dir, exist_ok=True)
    output_name = os.path.join(output_dir, f"{args.data}.npy")
    finished_data = []
    num_exp_remaining = args.numexp
    print(output_dir)

    # Preparing the data and reducers
    X, _ = data_utils.data_prep(args.data)
    dims = X.shape[1]
    reducer_instance = YOUR_REDUCER # Replace with any of the reducer, e.g. paramrepulsor.ParamRepulsor()

    # Perform experiments
    for i in range(num_exp_remaining):
        start = time.perf_counter()
        output = reducer_instance.fit_transform(X)
        end = time.perf_counter()
        time_used = end - start  # In seconds
        finished_data.append(output)
        # Save the output
        np.save(output_name, np.array(finished_data))

        # Record time
        time_name = os.path.join(output_dir, "time.pkl")
        if os.path.exists(time_name):
            with open(time_name, "rb") as fp:
                time_dict = pkl.load(fp)
        else:
            time_dict = {}

        time_dict[args.data].append(time_used)
        with open(time_name, "wb") as fp:
            pkl.dump(time_dict, fp)


if __name__ == "__main__":
    args = get_args()
    main(args)
