imagenet_path=""
log_dir_vq="train_logs_vq/vqgan_lc"
log_dir_gpt="train_logs_gpt/gpt_lc"
codebook_path="clustering_codebook_imagenet1k_100000.pth"

####Extract path-level features of training images
CUDA_VISIBLE_DEVICES=0 python codebook_generation/clip_feature_generation.py --batch_size 4096 --imagenet_path $imagenet_path

####Cluster the features to generate initialized codebook
CUDA_VISIBLE_DEVICES=0 python codebook_generation/minibatch_kmeans_per_class.py --start 0 \
                                                               --end 1000 \
                                                               --n_class 1000 \
                                                               --downsample 4 \
                                                               --save_dir "clustering_centers_1000" \
                                                               --imagenet_feature_path "Imagenet_clip_features/train"

####Training VQGAN-LC with the generated codebook
CUDA_VISIBLE_DEVICES=1 torchrun --nproc_per_node 1 --master_port=13247 training_vqgan.py \
    --batch_size 256 \
    --image_size 256 \
    --epochs 20 \
    --warmup_epochs 5 \
    --lr 1e-4 \
    --n_class 1000 \
    --imagenet_path $imagenet_path \
    --num_workers 16 \
    --rate_q 0.1 \
    --rate_p 1 \
    --vq_config_path vqgan_configs/vq-f16.yaml \
    --output_dir $log_dir_vq \
    --log_dir $log_dir_vq \
    --disc_start 0 \
    --n_vision_words 100000 \
    --local_embedding_path $codebook_path \
    --quantizer_type "org" \
    --tuning_codebook 0 \
    --use_cblinear 1 \
    --embed_dim 8

####Training V2L Tokenizer Stage2 (32-V100, 32 batches per GPU)
CUDA_VISIBLE_DEVICES=1 torchrun --nproc_per_node 1 --master_port=14297 training_gpt.py \
    --batch_size 32 \
    --image_size 256 \
    --epochs 100 \
    --lr 4.5e-4 \
    --n_class 4 \
    --imagenet_path $imagenet_path \
    --num_workers 16 \
    --vq_config_path vqgan_configs/vq-f16.yaml \
    --output_dir $log_dir_gpt \
    --local_embedding_path $codebook_path \
    --stage_1_ckpt $log_dir_vq"/vqgan_checkpoint-20.pth"   \
    --n_vision_words 100000 \
    --tuning_codebook 0 \
    --use_cblinear 1 \
    --embed_dim 8 \
    --deepspeed \
    --deepspeed_config "config/deepspeed_gpt_zero2_small.json" \
    --gpt_type "small"
