# Reproduce Instructions

## Environment Setup

```
# create dusa environment
conda create -n diff_tta -y python=3.9.19

# install torch
pip install torch==2.0.0+cu117 torchvision==0.15.0+cu117 -f https://download.pytorch.org/whl/torch_stable.html

# install others
conda env update -n diff_tta -f env.yml
```



## Prepare Models

Access pre-trained weights from the following resources:

+ [`ResNet50`](https://github.com/rwightman/pytorch-image-models/releases/download/v0.1-rsb-weights/resnet50_gn_a1h2-8fe6c4d0.pth)
+ [`ViT-B/16`](https://storage.googleapis.com/vit_models/augreg/B_16-i1k-300ep-lr_0.001-aug_strong2-wd_0.1-do_0.1-sd_0.1--imagenet2012-steps_20k-lr_0.01-res_224.npz)
+ [`ConvNeXt-L`](https://dl.fbaipublicfiles.com/convnext/convnext_large_1k_224_ema.pth)
+ [`DiT-XL`](https://dl.fbaipublicfiles.com/DiT/models/DiT-XL-2-256x256.pt)
  + [`stabilityai/sd-vae-ft-ema`](https://huggingface.co/stabilityai/sd-vae-ft-ema) is automatically downloaded

Download weights and place them in the `./pretrained_models` directory.

## Prepare Data

The ImageNet-C can be downloaded from the following links: 

[Download ImageNet-C here. (Mirror.)](https://zenodo.org/record/2235448)

Download the dataset and extract it to the `./data/imagenet-c` directory.

## Run Experiments

The scripts are available in the `./sh` directory.

### ConvNeXt-L

+ diffusion-tta
  ```shell
  bash sh/main/diffusiontta_convnext_in-c.sh
  ```

### ConvNeXt-L for Continual TTA
+ diffusion-tta
  ```shell
  bash sh/continual/diffusiontta_continual_convnext_in-c.sh
  ```

## ViT-B/16

+ diffusion-tta
  ```shell
  bash sh/main/diffusiontta_vit_in-c.sh
  ```

## ResNet50

+ diffusion-tta
  ```shell
  bash sh/main/diffusiontta_resnet50_in-c.sh
  ```