# Reproduce Instructions

## Environment Setup

```
# create dusa_seg environment
conda create -n dusa_seg -y python=3.9.5
conda activate dusa_seg
# install torch
pip install torch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 --index-url https://download.pytorch.org/whl/cu121
# install mmlab
pip install openmim==0.3.9
mim install "mmcv==2.1.0"
mim install "mmengine==0.10.2"
# install others
conda env update -n dusa_seg -f env.yml
```



## Prepare Models

Access pre-trained weights from the following resources:

+ [`Stable Diffusion v1.5`](https://huggingface.co/runwayml/stable-diffusion-v1-5)
+ [`Controlnet v1.1`](https://huggingface.co/lllyasviel/control_v11p_sd15_seg)
+ [`SegFormer-B5`](https://download.openmmlab.com/mmsegmentation/v0.5/segformer/segformer_mit-b5_512x512_160k_ade20k/segformer_mit-b5_512x512_160k_ade20k_20210726_145235-94cedf59.pth)

 Download weights and place them in the `./pretrained_models` directory.



## Prepare Data

The ADE20K can be accessed from the links:  [ADE20K](https://data.csail.mit.edu/places/ADEchallenge/ADEChallengeData2016.zip)

 Download data and place them in the `./data` directory.

To generate ADE20K-C, run the following  command:

```shell
bash build_ADE20k_c.sh
```



## Run Experiments

The scripts are available in the `./sh` directory.

- Baselines

```shell
bash sh/baseline/baseline.sh
```

- DUSA

```shell
bash sh/ours/ours.sh
```