# Contrastive Prototype-Image Adaptation
In this repository, we release the code regarding our proposed method named "Contrastive Prototype-Image Adaptation" which is designed to adapt different transformation models respectively for prototype and image instance encoders in the similar way of CLIP via subsituting text prompts with prototype embeddings. In this repo, we provide the code of CoPA based on the [original URL repo](https://github.com/VICO-UoE/URL). 
            

## Model Zoo
- [Single-domain networks (one for each dataset)](https://drive.google.com/file/d/1MvUcvQ8OQtoOk1MIiJmK6_G8p4h8cbY9/view?usp=sharing)

- [A single universal network (URL) learned from 8 training datasets](https://drive.google.com/file/d/1Dv8TX6iQ-BE2NMpfd0sQmH2q4mShmo1A/view?usp=sharing)


## Dependencies
This code requires the following software:
* Python 3.8
* PyTorch 1.7.1
* Torchvision 0.8.2
* TensorFlow 2.10
* tqdm 4.64.1
* tabulate 0.8.10

## Installation
* Clone or download this repository.
* Configure Meta-Dataset:
    * Follow the "User instructions" in the [Meta-Dataset repository](https://github.com/google-research/meta-dataset) for "Installation" and "Downloading and converting datasets".
    * To test unseen domain (out-of-domain) performance on additional datasets, i.e. MNIST, CIFAR-10 and CIFAR-100, follow the installation instruction in the [CNAPs repository](https://github.com/cambridge-mlg/cnaps) to get these datasets.


## Backbone Pre-training

### Train the Universal Representation Learning Network
1. The easiest way is to download [pre-trained URL model](https://drive.google.com/file/d/1Dv8TX6iQ-BE2NMpfd0sQmH2q4mShmo1A/view?usp=sharing) provided by URL. To download the pretrained URL model, one can use `gdown` (installed by ```pip install gdown```) and execute the following command in the root directory of this project:
    ```
    gdown https://drive.google.com/uc?id=1Dv8TX6iQ-BE2NMpfd0sQmH2q4mShmo1A && md5sum url.zip && unzip url.zip -d ./saved_results/ && rm url.zip
    
    ```

2. Alternatively, one can train the model from scratch: 1) train 8 single domain learning networks; 2) train the universal feature extractor as following. 

#### Train Single Domain Learning Networks
1. The easiest way is to download [pre-trained models](https://drive.google.com/file/d/1MvUcvQ8OQtoOk1MIiJmK6_G8p4h8cbY9/view?usp=sharing) and use them to obtain a universal set of features directly. To download single domain learning networks, execute the following command in the root directory of this project:
    ```
    gdown https://drive.google.com/uc?id=1MvUcvQ8OQtoOk1MIiJmK6_G8p4h8cbY9 && md5sum sdl.zip && unzip sdl.zip -d ./saved_results/ && rm sdl.zip
    ```

2. Alternatively, instead of using the pretrained models, one can train the models from scratch.
   To train 8 single domain learning networks, run:
    ```
    ./scripts/train_resnet18_sdl.sh
    ```


#### Train the Universal Feature Extractor
To learn the universal feature extractor by distilling the knowledge from pre-trained single domain learning networks, run: 
```
./scripts/train_resnet18_url.sh
```

## CoPA
### Meta-Testing with CoPA
This step would run CoPA procedure per task to learn the optimal task-specific parameters for each cross-domain few-shot classification task. Run:
```
./scripts/pa_adaptation.sh
```

### Meta-Testing with CoPA
This step would run CoPA procedure per task to learn the optimal task-specific parameters for each cross-domain few-shot classification task. Run:
```
./scripts/tsa_adaptation.sh
```
