# Sample 
bash rand/sample.sh
for dataset in tydiqa mmlu bbh;do
	bash kdeknn/prob_assign.sh $dataset
	bash kdeknn/sample.sh $dataset
done

# Finetuning and evaluation
for model in "meta-llama/Llama-2-7b-hf" "mistralai/Mistral-7B-v0.1";do
	# Finetune the model on random data
	bash ft_rand.sh ${model}

	for dataset in tydiqa mmlu bbh;do
		# eval for the model finetuned on random data
		for fraction in 0.005 0.01 0.05;do
			bash eval_all.sh ${dataset} rand ${fraction} 4
		done
		# run LESS (4 epochs)
		for fraction in 0.005 0.01 0.05;do
			bash ft.sh ${dataset} less ${fraction} 4 ${model}
			bash eval_all ${dataset} less ${fraction} 4
		done
		# run our method (the fraction is 4x and the epoch is 1 so the number of 
		# training steps are the same)
		for fraction in 0.02 0.04 0.2;do
			bash ft.sh ${dataset} kdeknn0.075sigma0.2 ${fraction} 1 ${model}
			bash eval_all.sh ${dataset} kdeknn0.075sigma0.2 ${fraction} 1
		done
	done
done
