TARGET_TASK_NAME=$1
METHOD_NAME=$2
PERCENTAGE=$3
EPOCHS=$4
MODEL_PATH=$5

for seed in 3 6 9;do
if [ "$METHOD_NAME" = "less" ]; then
    TRAIN_FILES=../selected_data_seed${seed}/${TARGET_TASK_NAME}/top_p${PERCENTAGE}.jsonl
else
    TRAIN_FILES=../selected_data_seed${seed}/${TARGET_TASK_NAME}/${METHOD_NAME}_p${PERCENTAGE}.jsonl
fi
echo $TRAIN_FILE
#MODEL_PATH="meta-llama/Llama-2-7b-hf"
#MODEL_PATH="mistralai/Mistral-7B-v0.1"
if [ "$MODEL_PATH" = "meta-llama/Llama-2-7b-hf" ]; then
    MODEL_TAG="llama2-7b"
    EVAL_DIR="evaluation"
else
    MODEL_TAG="mistral-7b"
    EVAL_DIR="evaluation_mistral"
fi

JOB_NAME=${MODEL_TAG}-${METHOD_NAME}-p${PERCENTAGE}-lora-seed${seed}-${TARGET_TASK_NAME}-epoch${EPOCHS}
GPU_ID=0

./less/scripts/train/lora_train.sh "$TRAIN_FILES" "$MODEL_PATH" "$JOB_NAME" "$GPU_ID" "$seed" "$EPOCHS"
done

