select_method=$1
seed=$2
device_id=$3
epochs=$4
percentage=$5
eval_dir=$6
version=$7
model=$8
submodel=$9
save_dir=results_${version}_${eval_dir}_${model}/${select_method}_seed${seed}_epoch${epochs}_p${percentage}_${submodel}/mmlu
mkdir -p $save_dir

if [ "$select_method" = "uniform" ] | [ "$select_method" = "barycenter" ] | [ "$select_method" = "rand" ]; then
    postfix=${select_method}
else
    postfix="mmlu"
fi

# Now you can use the postfix variable as needed
echo "The selected postfix is: $postfix"

CUDA_VISIBLE_DEVICES=${device_id} python -m ${version}.mmlu.run_eval \
    --ntrain 5 \
    --data_dir ../data/${eval_dir}/mmlu \
    --save_dir $save_dir \
    --model_name_or_path out/${model}-${select_method}-p${percentage}-lora-seed${seed}-${postfix}-epoch${epochs}/${submodel} \
    --tokenizer_name_or_path out/${model}-${select_method}-p${percentage}-lora-seed${seed}-${postfix}-epoch${epochs}/${submodel} \
    --eval_batch_size 4 \
    --convert_to_bf16
