# README

The code is split into a few files.

## baseline.py

Includes code for computing the privacy guarantees of the 'standard' binary mechanism, in particular when it is run with resets.
We consider the particular version that only uses left-subtrees, and never the root.

## our_algorithm.py

Includes code for computing the privacy guarantees of Algorithm 3 from the paper.

## helper_functions.py

Includes auxiliary functions, most notably code for computing dyadic interval covers for arbitrary [a, b].

## plots.ipynb

Jupyter Notebook file for producing all plots in the paper. Running it with the set parameters will reproduce all figures.

# A comment on dependencies

Only 'standard' modules are utilized with the exception of 'tueplots' for formatting the plots. It can be commented out in plots.ipynb.