#!/bin/bash

# architecture
phy="--range-dcoeff 5e-3 2e-1"
dec="--hidlayers-aux1-dec 64 64 --x-lnvar -13.8"
feat="--arch-feat mlp --hidlayers-feat 256 256 --num-units-feat 256"
unmix="--hidlayers-unmixer 256 256"
enc="--hidlayers-aux1-enc 64 32 --hidlayers-aux2-enc 64 32 --hidlayers-dcoeff 64 32"

# optimization
optim="--learning-rate 1e-3 --train-size 20000 --batch-size 500 --epochs 1000 --grad-clip 5.0 --intg-lev 2 --weight-decay 1e-6 --adam-eps 1e-3 --balance-kld 1.0"

others="--save-interval 9999999 --num-workers 0 --activation elu --seed 1234" # --cuda
outdir="./output1/"
options="--datadir ./data/ --outdir ${outdir} ${dec} ${feat} ${unmix} ${enc} ${optim} ${others}"
alpha=1e-1; beta=1e6; gamma=1e-2
commands="--dim-z-aux1 1 --dim-z-aux2 -1 --balance-unmix ${gamma} --balance-dataug ${beta} --balance-lact-dec ${alpha} --balance-lact-enc ${alpha}"
mkdir ${outdir}
python -m physvae.advdif.test_model ${options} ${commands}



