#!/bin/bash

MODEL='BERT'

DATASET='GLUE'
DATA_DIR='PATH_TO_DATASET'
LOGDIR_OUT='./log/log_stability'
LOGDIR='./log/runs_stability/'
if [ ! -d $LOGDIR_OUT ]; then
  mkdir -p $LOGDIR_OUT
fi
if [ ! -d ${LOGDIR_OUT}/${MODEL}_${DATASET} ]; then
  mkdir -p ${LOGDIR_OUT}/${MODEL}_${DATASET}
fi

NUM_WORKERS=8
BATCH_SIZE=16
EPOCH=200
SEED=42

DELAY_TYPE='random'

LR=0.01
DELAY=4
JOB_NAME=${LOGDIR_OUT}/${MODEL}_${DATASET}/log_worker-${NUM_WORKERS}_${DELAY_TYPE}-${DELAY}delay_bs-${BATCH_SIZE}_lr-${LR}_seed-${SEED}
echo $JOB_NAME
CUDA_VISIBLE_DEVICES=0 python -u asgd_bert.py --model $MODEL --cuda-ps --batch-size $BATCH_SIZE \
                                    --dataset $DATASET --delay $DELAY --logdir $LOGDIR \
                                    --delay-type $DELAY_TYPE --num-workers $NUM_WORKERS \
                                    --lr $LR --num-epochs $EPOCH --seed $SEED \
                                    --eval-freq=200 \
                                    --data_dir $DATA_DIR \
                                    --do_lower_case --vocab_file=./vocab/vocab \
                                    --config_file=bert_config.json --bert_model=bert-base-uncased \
                                    > ${JOB_NAME}.out 2>&1 &

LR=0.005
DELAY=8
JOB_NAME=${LOGDIR_OUT}/${MODEL}_${DATASET}/log_worker-${NUM_WORKERS}_${DELAY_TYPE}-${DELAY}delay_bs-${BATCH_SIZE}_lr-${LR}_seed-${SEED}
echo $JOB_NAME
CUDA_VISIBLE_DEVICES=1 python -u asgd_bert.py --model $MODEL --cuda-ps --batch-size $BATCH_SIZE \
                                    --dataset $DATASET --delay $DELAY --logdir $LOGDIR \
                                    --delay-type $DELAY_TYPE --num-workers $NUM_WORKERS \
                                    --lr $LR --num-epochs $EPOCH --seed $SEED\
                                    --eval-freq=200 \
                                    --data_dir $DATA_DIR \
                                    --do_lower_case --vocab_file=./vocab/vocab \
                                    --config_file=bert_config.json --bert_model=bert-base-uncased \
                                    > ${JOB_NAME}.out 2>&1 &

LR=0.0025
DELAY=16
JOB_NAME=${LOGDIR_OUT}/${MODEL}_${DATASET}/log_worker-${NUM_WORKERS}_${DELAY_TYPE}-${DELAY}delay_bs-${BATCH_SIZE}_lr-${LR}_seed-${SEED}
echo $JOB_NAME
CUDA_VISIBLE_DEVICES=2 python -u asgd_bert.py --model $MODEL --cuda-ps --batch-size $BATCH_SIZE \
                                    --dataset $DATASET --delay $DELAY --logdir $LOGDIR \
                                    --delay-type $DELAY_TYPE --num-workers $NUM_WORKERS \
                                    --lr $LR --num-epochs $EPOCH --seed $SEED\
                                    --eval-freq=200 \
                                    --data_dir $DATA_DIR \
                                    --do_lower_case --vocab_file=./vocab/vocab \
                                    --config_file=bert_config.json --bert_model=bert-base-uncased \
                                    > ${JOB_NAME}.out 2>&1 &

LR=0.00125
DELAY=32
JOB_NAME=${LOGDIR_OUT}/${MODEL}_${DATASET}/log_worker-${NUM_WORKERS}_${DELAY_TYPE}-${DELAY}delay_bs-${BATCH_SIZE}_lr-${LR}_seed-${SEED}
echo $JOB_NAME
CUDA_VISIBLE_DEVICES=3 python -u asgd_bert.py --model $MODEL --cuda-ps --batch-size $BATCH_SIZE \
                                    --dataset $DATASET --delay $DELAY --logdir $LOGDIR \
                                    --delay-type $DELAY_TYPE --num-workers $NUM_WORKERS \
                                    --lr $LR --num-epochs $EPOCH --seed $SEED\
                                    --eval-freq=200 \
                                    --data_dir $DATA_DIR \
                                    --do_lower_case --vocab_file=./vocab/vocab \
                                    --config_file=bert_config.json --bert_model=bert-base-uncased \
                                    > ${JOB_NAME}.out 2>&1 &

wait

echo 'finish!'

