export HDF5_USE_FILE_LOCKING=FALSE
export OMP_NUM_THREADS=6

master_node=$SLURMD_NODENAME
run_name="vmae_mask0.6_subsample0.02_$(date '+%Y-%m-%d')"
config="basic_config"   # options are "basic_config" for all or swe_only/comp_only/incomp_only/swe_and_incomp
yaml_config="./config/vmae_config.yaml"



export MASTER_ADDR=$(hostname)

# number of gpus
ngpu=4

# run command
cmd="python train_basic.py --run_name $run_name --config $config --yaml_config $yaml_config --use_ddp"

# source DDP vars first for data-parallel training (if not srun, just source and then run cmd; see pytorch docs for DDP)
srun -l -n $ngpu --cpus-per-task=10 --gpus-per-node $ngpu bash -c "source export_DDP_vars.sh && $cmd"
