### ServiceNow Open Source Code-of-Conduct

This code of conduct provides guidelines for participation in ServiceNow-managed open-source communities and projects.

**Discussion forum guidelines**

Communities thrive when members support each other and provide useful feedback.

- Be polite and courteous. Respect and treat others as you would expect to be treated yourself.
- Respect your audience. Posts should not upset, annoy, threaten, harass, abuse or embarrass other members.
- User Contributions must not include material that is defamatory, obscene, indecent, abusive, offensive, harassing, violent, hateful, inflammatory or otherwise objectionable.
- Lively and collegial discussions are always encouraged in a healthy community. It is okay to argue facts but not okay to argue personalities or personal beliefs.
- Do not use text formats such as all caps or bold that may be read as annoying, rude or send a strong message.
- Do not publish anyone’s private personal information without their explicit consent.
- Avoid using abbreviations or terminology that others may not understand. An abbreviation may mean something to you but in another context or country, it may have another meaning.
- Be accountable for your actions by correcting your mistakes and indicating where you have changed a previous post of yours.
- Mark content as correct and helpful, and provide feedback. If you read a discussion post that you find helpful, we encourage you to leave a positive vote and comment in the replies. If you find a post that is unhelpful, please provide more information in the issue comments.

**Issue board guidelines**

Many open-source projects provide an Issues board, with similar functionality to a Discussions forum. The same rules from the discussion forum guidelines apply to the Issues board.

ServiceNow suggests the following technical support pathways for open-source projects:

1. Clearly identify and document the issue or question you have.
2. View the Documentation.
3. Search the Discussions.
4. Search the project knowledge base or Wiki for known errors, useful solutions, and troubleshooting tips.
5. Check the project guidelines in the [`CONTRIBUTING.md`](CONTRIBUTING.md) file if you would like details on how you can submit a change. Community contributions are valued and appreciated!
6. Log an Issue if it hasn’t already been logged. If the issue has already been logged by another user, vote it up, and add a comment with additional or missing information. Do your best to choose the correct category when logging a new issue. This will make it easier to differentiate bugs from new feature requests or ideas. If after logging an issue you find the solution, please close your issue and provide a comment with the solution. This will help the project owners and other users.
7. Contact the project team contributors of the project to see if they can help as a last resort only.

**Repositories**

- Read and follow the license instructions
- Remember to include citations if you use someone else’s work in your own project. Use the [`CITATION.cff`](CITATION.cff) to find the correct project citation reference.
- ‘Star’ project repos to save for future reference.
- ‘Watch’ project repos to get notifications of changes – this can get noisy for some projects, so only watch the ones you really need to track closely.

**Enforcement and reporting**

We encourage community members and users to help each other and to resolve issues amongst themselves as much as possible. If a matter cannot be resolved in good faith within the means available, please reach out to a team member or email servicenow-research@servicenow.com.

**ServiceNow Disclaimer.**

We may, but are under no obligation to, monitor or censor comments made by users or content provided by contributors and we are not responsible for the accuracy, completeness, appropriateness or legality of anything posted, depicted or otherwise provided by third‑party users and we disclaim any and all liability relating thereto.
