#!/usr/bin/env python3 3.7.4 project3 env
# -*- coding: utf-8 -*-
"""
Run all scripts necessary to reproduce the paper.
"""

import sys
from threading import currentThread

sys.path.append("modules")


import setup_parameters
import setup_OFC_network
import adaptation_learning
from pathlib import Path


def run(opts):

    # this effectively removes the delay
    custom_delay = {}
    custom_delay["r_go_range"] = [70, 71]
    custom_delay["cor_go_range"] = [70, 71]

    savname = opts.out_dir
    setup_parameters.main(
        savname=savname,
        dataset_name=opts.dataset_name,
        rand_seed=opts.run_id,
        fb_density=opts.fb_density,
        fb_delay=opts.delay,
        protocol=[[opts.task, 5000]],
        rot_phi=30,
        learning_rate=opts.learning_rate,
        vel=10,
        batch_size=opts.batch_size,
        go_to_peak=opts.go_to_peak,
        custom_delay=custom_delay,
        fb_freeze=opts.fb_freeze,
        error_detach=opts.error_detach,
        get_grads_per_example=opts.get_grads_per_example,
        wfb_frozen_phase=opts.wfb_frozen_phase,
        pratio=opts.pratio,
    )
    setup_OFC_network.main(savname)


def main():
    from liftoff import parse_opts

    run(parse_opts())


if __name__ == "__main__":
    main()
