# Small-scale experiments for PV-tuning framework
This sub repository contains small-scale experiments for PV tuning framework.

## Formulation

For small experiments, we aim to minimize the following objective

$$
\phi(x) = \sum_{i=1}^d{a_i(x_i-x_i^{\star})^2}=(x-x^{\star})^T\Lambda(x-x^{\star}),
$$

where $a_i \in R^d$, $x^{\star}$ is a unique optimal point: $\nabla \phi(x^{\star}) = 0$ and

$$
\Lambda = \text{diag}(a_1, \cdots, a_d)= 
\begin{bmatrix}
a_1 & \cdots & 0 \\
\vdots & \ddots & 0 \\
0 & 0 & a_d 
\end{bmatrix}
$$

We set $a_i = i/d$ for $i \in {1, \cdots, d}$.

Hence, we have the Lipschitz continuity with $L = 1$.

## Experiments

* Tiny-scale experiments ($d=6$) are located in [pv_tiny_scale.ipynb](pv_tiny_scale.ipynb)
* Larger-scale experiments ($d=100$) are located in [pv_larger_scale.ipynb](pv_larger_scale.ipynb)

## Requirements

Run

```
pip install -r requirements.txt
```
