mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

world_size=32
model_name=openai-community/gpt2-large
base_output_path=${BASE_PATH}/output/summarize_from_feedback/${model_name}

# b4c4l5
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/b4c4l5/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/summarize_from_feedback/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=4 \
        --generation_configs.num_candidates=4 \
        --generation_configs.block_len=5 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

# b2c2l5
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/b2c2l5/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/summarize_from_feedback/gen_bt.py \
        --model_name=${model_name} \
        --output_path=${output_path} \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=2 \
        --generation_configs.num_candidates=2 \
        --generation_configs.block_len=5 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
