mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

base_generation_dir="${BASE_PATH}/output/summarize_from_feedback/openai-community/gpt2-large"

for generation_path in $(find ${base_generation_dir} -type d | sort | grep "gen"); do
    if [ -e ${generation_path/"gen"/"eval"}/raw.jsonl  ]; then continue ; fi
    echo ${generation_path/"gen"/"eval"}
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/summarize_from_feedback/eval.py \
        --generation_path ${generation_path} \
        --evaluation_path ${generation_path/"gen"/"eval"} &
    sleep .5
done

cd ..
