mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

world_size=64

for model_name in HuggingFaceH4/zephyr-7b-beta HuggingFaceH4/mistral-7b-sft-beta berkeley-nest/Starling-LM-7B-alpha openchat/openchat_3.5 allenai/tulu-2-dpo-7b allenai/tulu-2-7b; do
    base_output_path=${BASE_PATH}/output/alpaca_leaderboard/others/scorer/${model_name}
    for rank in $(seq 0 $((world_size-1))); do
        output_path=${base_output_path}/base/b1/gen
        if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
        echo "rank ${rank}/${world_size}"
        PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/gen_base.py \
            --model_name=${model_name} \
            --output_path=${output_path} \
            --generation_configs.temperature=0.7 \
            --generation_configs.top_p=1.0 \
            --rank=${rank} \
            --world_size=${world_size} &
        sleep .5
    done

done

cd ..
