mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-reserved} --gres=gpu:${GPU:-1} --cpus-per-task=16 --async"

world_size=16
model_name=openai/gpt-3.5-turbo-instruct
scorer_name=zephyr-7b-beta
base_output_path=${BASE_PATH}/output/alpaca_leaderboard/${model_name}/${scorer_name}-guidance

# num_beams=2,num_candidates=2,block_len=100
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/b2c2l100/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/sh/openai/gpt-3.5-turbo-instruct/gen_bt.py \
        --model_name=${model_name} \
        --scorer_name=${scorer_name} \
        --output_path=${output_path} \
        --generation_configs.num_beams=2 \
        --generation_configs.num_candidates=2 \
        --generation_configs.block_len=100 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
