mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:${GPU:-2} --cpus-per-task=8 --async"

world_size=64
model_name=meta-llama/Llama-2-7b-chat-hf
scorer_name=Starling-LM-7B-alpha
base_output_path=${BASE_PATH}/output/alpaca_leaderboard/${model_name}/${scorer_name}-guidance

# num_beams=2,num_candidates=2,block_len=30
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/b2c2l30/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/gen_bt.py \
        --model_name=${model_name} \
        --scorer_name=${scorer_name} \
        --output_path=${output_path} \
        --generation_configs.temperature=0.7 \
        --generation_configs.top_p=1.0 \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=2 \
        --generation_configs.num_candidates=2 \
        --generation_configs.block_len=30 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done
# num_beams=4,num_candidates=4,block_len=30
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/b4c4l30/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/gen_bt.py \
        --model_name=${model_name} \
        --scorer_name=${scorer_name} \
        --output_path=${output_path} \
        --generation_configs.temperature=0.7 \
        --generation_configs.top_p=1.0 \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=4 \
        --generation_configs.num_candidates=4 \
        --generation_configs.block_len=30 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done
# num_beams=1,num_candidates=16,block_len=30
for rank in $(seq 0 $((world_size-1))); do
    output_path=${base_output_path}/bt/b1c16l30/gen
    if [ -e "${output_path}/$(printf "%05d\n" $rank)-of-$(printf "%05d\n" $world_size).jsonl"  ]; then continue ; fi
    echo "rank ${rank}/${world_size}"
    PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/gen_bt.py \
        --model_name=${model_name} \
        --scorer_name=${scorer_name} \
        --output_path=${output_path} \
        --generation_configs.temperature=0.7 \
        --generation_configs.top_p=1.0 \
        --generation_configs.beta=1.0 \
        --generation_configs.num_beams=1 \
        --generation_configs.num_candidates=16 \
        --generation_configs.block_len=30 \
        --rank=${rank} \
        --world_size=${world_size} &
    sleep .5
done

cd ..
