mkdir -p tmp ; cd tmp
BASE_PATH=..
LAUNCH="srun -p llm-safety --quotatype=${QUOTATYPE:-auto} --gres=gpu:1 --cpus-per-task=8 --async"

base_generation_dir="${BASE_PATH}/output/alpaca_leaderboard"

# UltraRM-13b and Starling-RM-34B
for evaluator_name in UltraRM-13b Starling-RM-34B; do
    for generation_path in $(find ${base_generation_dir} -type d | sort | grep "gen"); do
        if [ -e ${generation_path/"gen"/"eval"}/${evaluator_name}/raw.jsonl  ]; then continue ; fi
        echo ${generation_path/"gen"/"eval"}/${evaluator_name}
        mkdir -p ${generation_path/"gen"/"eval"}/${evaluator_name}
        PYTHONPATH=${BASE_PATH} ${LAUNCH} python ${BASE_PATH}/scripts/alpaca_leaderboard/eval.py \
            --evaluator_name ${evaluator_name} \
            --generation_path ${generation_path} \
            --evaluation_path ${generation_path/"gen"/"eval"}/${evaluator_name} &
        sleep .5
    done
done

# merge for gpt eval
for generation_path in $(find ${base_generation_dir} -type d | sort | grep "gen"); do
    if [ -e ${generation_path/"gen"/"eval"}/gpt4/model_outputs.json ]; then continue ; fi
    mkdir -p ${generation_path/"gen"/"eval"}/gpt4
    python ${BASE_PATH}/scripts/alpaca_leaderboard/merge.py --input_path ${generation_path} --output_path ${generation_path/"gen"/"eval"}/gpt4/model_outputs.json
done

cd ..
