# (alpha, beta, gamma, delta, epsilon, phi, rho)
# theta = (0.67, 0.0, 0.33, 0.0, 0.33, 0.67, 0.0)
theta = (0.67, 0.0, 0.33, 0.0, 0.67, 0.33, 0.0)
# theta = (0.5, 0.0, 0.5, 0.0, 0.5, 0.5, 0.0)  # BTT
# theta = (0.5, 0.5, 0.0, 0.5, 0.5, 0.0, 0.0)  # TT
# theta = (1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5)  # Low-rank
d_in, d_out = 100, 100
# d_in, d_out = 100, 400
# d_in, d_out = 400, 100
assert len(theta) == 7
out = [d_in**th for th in theta[0:3]] + [d_out**th for th in theta[3:6]] + [d_in**theta[-1]]
alpha, beta, gamma, delta, epsilon, phi, rho = out

dA_in = alpha
dA_out = delta * phi * rho
sigma2_A = min(dA_in, dA_out) / dA_in**2.

dB_in = beta * gamma * rho
dB_out = epsilon
sigma2_B = min(dB_in, dB_out) / dB_in**2.

lA_mup = (dA_out / dA_in) * (1. / beta)
lA_rsgd = (1 / (beta * epsilon * sigma2_B)) * (d_out / d_in)

lB_mup = (dB_out / dB_in) * (1. / delta)
lB_rsgd = (1 / (alpha * delta * sigma2_A)) * (d_out / d_in)

print(f"A: mup {lA_mup:1.5e} | rsgd {lA_rsgd:1.5e}")
print(f"B: mup {lB_mup:1.5e} | rsgd {lB_rsgd:1.5e}")
print(f"\nR: mup {lA_mup / lB_mup:1.5e} | rsgd {lA_rsgd / lB_rsgd:1.5e}")
